/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.awt.Color;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import oracle.dbtools.insight.BasicSuggestedItem;
import oracle.dbtools.parser.plsql.doc.Substr;
import oracle.dbtools.raptor.config.CustomFormat;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.util.Service;
import oracle.ide.ceditor.options.S2Highlight;
import oracle.ide.ceditor.options.SyntaxColorsOptions;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.icons.OracleIcons;

public class SuggestedItem
extends BasicSuggestedItem
implements Comparable {
    static boolean isHTML = true;
    public String highlight = null;
    public static final String prefix = "[";
    public static final String suffix = "]";
    private static String placeholderPrefix = null;
    public static String placeholderSuffix = "</FONT>";

    public SuggestedItem(SuggestedItem suggestedItem, int n) {
        super((BasicSuggestedItem)suggestedItem, n);
        this.highlight = suggestedItem.highlight;
    }

    public SuggestedItem(String string, String string2, String string3) {
        this(string, string2, string3, -1);
    }

    public SuggestedItem(String string, String string2, String string3, int n) {
        this(string, string2, string3, n, true);
    }

    public SuggestedItem(String string, String string2, String string3, int n, boolean bl) {
        super(string, string2, string3, n);
        if ("KEYWORD".equals(string)) {
            String string4;
            if (bl && string3 != null) {
                CustomFormat.getInstance();
                CustomFormat customFormat = CustomFormat.getInstance();
                CustomFormat.getInstance();
                Map map = CustomFormat.getInstance().options;
                CustomFormat.getInstance();
                Objects.requireNonNull(CustomFormat.getInstance());
                string4 = customFormat.adjustCase(string3, map.get("kwCase"));
            } else {
                string4 = string3;
            }
            this.setName(string4);
        } else if (!"SNIPPET".equals(string) && !"TEMPLATE".equals(string)) {
            String string5;
            if (bl && string3 != null && string3.charAt(0) != '\"' && string3.charAt(string3.length() - 1) != '\"') {
                CustomFormat.getInstance();
                CustomFormat customFormat = CustomFormat.getInstance();
                CustomFormat.getInstance();
                Map map = CustomFormat.getInstance().options;
                Objects.requireNonNull(CustomFormat.getInstance());
                string5 = customFormat.adjustCase(string3, map.get("idCase"));
            } else {
                string5 = string3;
            }
            this.setName(string5);
        } else {
            this.setName(string3);
        }
    }

    public Icon getIcon() {
        if ("FUNCTION".equalsIgnoreCase(this._type)) {
            return RaptorImagesArb.getIcon("FUNCTION");
        }
        if ("PROCEDURE".equalsIgnoreCase(this._type)) {
            return RaptorImagesArb.getIcon("PROCEDURE");
        }
        if ("COLUMN".equalsIgnoreCase(this._type)) {
            return RaptorImagesArb.getIcon("COLUMN");
        }
        if ("TABLE".equalsIgnoreCase(this._type)) {
            return OracleIcons.getIcon((String)"table.png");
        }
        if ("VIEW".equalsIgnoreCase(this._type)) {
            return OracleIcons.getIcon((String)"view.png");
        }
        if (this._type != null && this._type.indexOf("CHAR") >= 0 || "STRING".equalsIgnoreCase(this._type)) {
            return RaptorImagesArb.getIcon("STRING");
        }
        if ("INTEGER".equalsIgnoreCase(this._type) || "NUMBER".equalsIgnoreCase(this._type)) {
            return OracleIcons.getIcon((String)"field.png");
        }
        if ("DATE".equalsIgnoreCase(this._type) || "TIMESTAMP".equalsIgnoreCase(this._type)) {
            return RaptorImagesArb.getIcon("DATE");
        }
        if ("BOOLEAN".equalsIgnoreCase(this._type)) {
            return RaptorImagesArb.getIcon("BOOLEAN");
        }
        if ("USER DEFINED".equals(this._type) || "TYPE".equals(this._type) || "SUBTYPE".equals(this._type)) {
            return OracleIcons.getIcon((String)"domain.png");
        }
        if ("SCHEMA".equalsIgnoreCase(this._type)) {
            return OracleIcons.getIcon((String)"user.png");
        }
        if ("PACKAGE".equalsIgnoreCase(this._type)) {
            return OracleIcons.getIcon((String)"package.png");
        }
        if ("SNIPPET".equalsIgnoreCase(this._type)) {
            return OracleIcons.getIcon((String)"library.png");
        }
        if ("SEQUENCE".equalsIgnoreCase(this._type)) {
            return OracleIcons.getIcon((String)"sequence.png");
        }
        if ("SYNONYM".equalsIgnoreCase(this._type)) {
            return OracleIcons.getIcon((String)"synonym.png");
        }
        if ("HISTORY".equalsIgnoreCase(this._type)) {
            return OracleIcons.getIcon((String)"history.png");
        }
        if ("EQUIJOIN CONDITION".equalsIgnoreCase(this._type)) {
            return RaptorImagesArb.getIcon("SIGMA");
        }
        return null;
    }

    public String getDisplayText() {
        if (!isHTML) {
            return this.toString();
        }
        int n = this.getPrefixLength();
        StringBuilder stringBuilder = new StringBuilder("<html>");
        if (!(this.getOwner() == null || 0 >= this.getOwner().length() || n != 0 && this.getName().indexOf(46) >= 0 && this.getName().substring(0, n).equalsIgnoreCase(this.getOwner() + ".") || "COLUMN".equals(this.getType()))) {
            stringBuilder.append("<font color=gray>" + this.getOwner() + ".</font>");
            n -= this.getOwner().length() + 1;
        }
        if (n > 0 && n < this.getName().length()) {
            stringBuilder.append("<b>" + this.getName().substring(0, n) + "</b>" + this.getName().substring(n));
        } else {
            String string;
            block6: {
                string = this.getName();
                try {
                    string = string.replace(prefix, SuggestedItem.getPlaceholderPrefix());
                    string = string.replace(suffix, placeholderSuffix);
                }
                catch (Exception exception) {
                    StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                    if (!stackTraceElementArray[stackTraceElementArray.length - 1].toString().startsWith("java.awt.EventDispatchThread.run")) break block6;
                    System.err.println("Unexpected: " + exception.toString());
                }
            }
            stringBuilder.append(string);
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    public String toString() {
        String string;
        int n;
        StringBuilder stringBuilder = new StringBuilder("<html>");
        if (this.highlight != null && 0 <= (n = (string = this.getName().toUpperCase()).indexOf(this.highlight.toUpperCase()))) {
            stringBuilder.append(this.getName().substring(0, n));
            stringBuilder.append("<font color=green><b>");
            stringBuilder.append(this.getName().substring(n, n + this.highlight.length()));
            stringBuilder.append("</b></font>");
            stringBuilder.append(this.getName().substring(n + this.highlight.length()));
            stringBuilder.append("</html>");
            return stringBuilder.toString();
        }
        return super.toString();
    }

    public static List<SuggestedItem> addSuggestions(Set<Substr> set, String string) {
        LinkedList<SuggestedItem> linkedList = new LinkedList<SuggestedItem>();
        for (Substr substr : set) {
            String string2 = substr.cutSrc();
            string2 = string2.replace("<", "&lt;");
            string2 = string2.replace(">", "&gt;");
            SuggestedItem suggestedItem = new SuggestedItem(string, null, string2);
            suggestedItem.doc = substr.getDoc();
            linkedList.add(suggestedItem);
        }
        return linkedList;
    }

    public static int countOwners(Set<SuggestedItem> set) {
        HashSet<String> hashSet = new HashSet<String>();
        for (SuggestedItem suggestedItem : set) {
            hashSet.add(suggestedItem.getOwner());
        }
        return hashSet.size();
    }

    public static String getPlaceholderPrefix() {
        block4: {
            if (placeholderPrefix != null) {
                return placeholderPrefix;
            }
            try {
                Color color = Color.gray;
                Preferences preferences = Preferences.getPreferences();
                SyntaxColorsOptions syntaxColorsOptions = SyntaxColorsOptions.getInstance((PropertyStorage)preferences);
                for (Object e : syntaxColorsOptions.getStyleList()) {
                    S2Highlight s2Highlight;
                    if (!(e instanceof S2Highlight) || !"tab-field".equals((s2Highlight = (S2Highlight)e).getStyleName())) continue;
                    color = new Color(s2Highlight.getBackgroundRGB());
                }
                placeholderPrefix = "<FONT style=\"BACKGROUND-COLOR: #" + Integer.toHexString(color.getRGB()).substring(2) + "\">";
            }
            catch (Exception exception) {
                StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                if (!stackTraceElementArray[stackTraceElementArray.length - 1].toString().startsWith("java.awt.EventDispatchThread.run")) break block4;
                System.err.println("Unexpected: " + exception.toString());
            }
        }
        return placeholderPrefix;
    }

    public String format() {
        String string = this.toString();
        if (!"ARGUMENT".equals(this.getType())) {
            return string;
        }
        CustomFormat.getInstance();
        Map map = CustomFormat.getInstance().options;
        CustomFormat.getInstance();
        Objects.requireNonNull(CustomFormat.getInstance());
        if (!((Boolean)map.get("breaksProcArgs")).booleanValue()) {
            return string;
        }
        CustomFormat.getInstance();
        Map map2 = CustomFormat.getInstance().options;
        CustomFormat.getInstance();
        Objects.requireNonNull(CustomFormat.getInstance());
        String string2 = Service.padln((String)"", (int)((Integer)map2.get("identSpaces")));
        return "\n" + string2 + string.replace(",", ",\n" + string2);
    }
}

