/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.plugin.evaluator;

import java.util.HashMap;
import java.util.Map;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.util.FastStringBuffer;
import oracle.ideimpl.debugger.evaluator.ConditionEvaluationResult;
import oracle.ideimpl.debugger.evaluator.ConditionEvaluationResultType;
import oracle.jdevimpl.debugger.plugin.CommonHelperFunctions;
import oracle.jdevimpl.debugger.plugin.evaluator.ExpressionEvaluationException;
import oracle.jdevimpl.debugger.plugin.evaluator.PluginDebuggerEvaluator;
import oracle.jdevimpl.debugger.plugin.evaluator.PluginEvaluatorContext;
import oracle.jdevimpl.debugger.res.EvaluatorImplArb;
import oracle.jdevimpl.debugger.shared.DebugSharedPrimitives;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataArrayInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugEvaluator;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugHasDataInfo;
import oracle.jdevimpl.debugger.support.DebugHeapObjectInfo;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugStackSlotInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.debugger.support.EvaluationInfo;

public abstract class PluginEvaluatorBase
implements PluginDebuggerEvaluator,
DebugEvaluator {
    protected PluginEvaluatorContext debugContext;
    private Map cachedSimple;
    private static final Object cachedSimpleNull = Boolean.FALSE;

    protected PluginEvaluatorBase(PluginEvaluatorContext debugContext) {
        this.debugContext = debugContext;
        this.cachedSimple = new HashMap();
    }

    @Override
    public void clearCache() {
        this.cachedSimple.clear();
    }

    @Override
    @Deprecated
    public abstract int evaluateConditionResult(Object var1, boolean var2);

    @Override
    public ConditionEvaluationResult evaluateCondition(String condition, boolean allowMethodInvocation) {
        ConditionEvaluationResult result = new ConditionEvaluationResult();
        Object o = this.evaluate(condition, allowMethodInvocation);
        if (o instanceof ExpressionEvaluationException) {
            ExpressionEvaluationException eee = (ExpressionEvaluationException)o;
            if (eee.getRetriable()) {
                result.setResultType(ConditionEvaluationResultType.RETRIABLE_EXCEPTION);
                result.setException((Throwable)eee);
                return result;
            }
            result.setResultType(ConditionEvaluationResultType.COULD_NOT_EVALUATE);
            result.setException((Throwable)eee);
            return result;
        }
        if (o != null) {
            int conditionResult = this.evaluateConditionResult(o, allowMethodInvocation);
            switch (conditionResult) {
                case -2: {
                    break;
                }
                case -1: {
                    String msg = EvaluatorImplArb.format(1, condition);
                    result.setResultType(ConditionEvaluationResultType.NOT_BOOLEAN);
                    result.setMessage(msg);
                    return result;
                }
                case 1: {
                    result.setResultType(ConditionEvaluationResultType.TRUE);
                    result.setMessage(EvaluatorImplArb.getString(2));
                    return result;
                }
                case 0: {
                    result.setResultType(ConditionEvaluationResultType.FALSE);
                    result.setMessage(EvaluatorImplArb.getString(3));
                    return result;
                }
            }
        }
        String msg = EvaluatorImplArb.format(0, condition);
        result.setResultType(ConditionEvaluationResultType.COULD_NOT_EVALUATE);
        result.setMessage(msg);
        if (o instanceof Throwable) {
            result.setException((Throwable)o);
        }
        return result;
    }

    @Override
    public abstract Object evaluate(String var1, boolean var2);

    @Override
    public abstract boolean canEvaluate(String var1);

    @Override
    public abstract boolean validate(String var1);

    protected Object evaluateSimple(String exp) {
        Object o = null;
        int dot = -1;
        do {
            String simpleExp;
            if ((o = (Object)this.cachedSimple.get(simpleExp = (dot = exp.indexOf(46, dot + 1)) != -1 ? exp.substring(0, dot) : exp)) == null) {
                o = this.evaluateSimpleInternal(simpleExp);
                if (o != null) {
                    this.cachedSimple.put(simpleExp, o);
                    continue;
                }
                this.cachedSimple.put(simpleExp, cachedSimpleNull);
                continue;
            }
            if (o != cachedSimpleNull) continue;
            o = null;
        } while (o == null && dot != -1);
        if (o != null && dot != -1) {
            if (o instanceof DebugVariableInfo) {
                o = ((DebugVariableInfo)o).getDataInfo();
            } else if (o instanceof DebugFieldInfo) {
                o = ((DebugFieldInfo)o).getDataInfo();
            }
            o = this.partialMatch(exp, dot, exp.length(), o);
        }
        return o;
    }

    protected Object evaluateSimpleInternal(String exp) {
        Object found = null;
        if (!this.debugContext.getVariables().isEmpty() && (found = this.debugContext.getVariables().get(exp)) != null) {
            return found;
        }
        if (this.debugContext.getDataObject() != null) {
            if (exp.equals("this")) {
                return this.debugContext.getDataObject();
            }
            found = this.checkThisFields(this.debugContext.getDataObject(), exp);
            if (found != null) {
                return found;
            }
        }
        DebugVariableInfo[] args = null;
        if (this.debugContext.getFrame() != null) {
            DebugVariableInfo[] vars = this.debugContext.getFrame().listLocals();
            found = this.checkVars(exp, vars, true);
            if (found != null) {
                return found;
            }
            args = this.debugContext.getFrame().listArguments();
            found = this.checkVars(exp, args, false);
            if (found != null) {
                return found;
            }
            DebugVariableInfo argThis = PluginEvaluatorBase.findThis(args);
            if (argThis != null) {
                found = this.checkThisFields(argThis.getDataInfo(), exp);
                if (found != null) {
                    return found;
                }
                try {
                    boolean atOutermostClass = false;
                    DebugHasDataInfo currentThis = argThis;
                    while (!atOutermostClass) {
                        DebugClassInfo currentCI = currentThis.getDataInfo().getClassInfo();
                        String currentThisClassName = currentCI.getNameWithoutPackage();
                        String nodollars = currentThisClassName.replaceAll("\\$", "");
                        int innerNestingLevel = currentThisClassName.length() - nodollars.length();
                        if (innerNestingLevel <= 0) {
                            atOutermostClass = true;
                            continue;
                        }
                        Object outerThisAsObject = this.checkThisFields(currentThis.getDataInfo(), "this$" + (innerNestingLevel - 1));
                        if (outerThisAsObject instanceof DebugFieldInfo) {
                            DebugFieldInfo outerThis = (DebugFieldInfo)outerThisAsObject;
                            found = this.checkThisFields(outerThis.getDataInfo(), exp);
                            if (found != null) {
                                return found;
                            }
                            currentThis = outerThis;
                            continue;
                        }
                        atOutermostClass = true;
                    }
                }
                catch (Throwable t) {
                    FeedbackManager.reportException((String)("Search for " + exp + " in outer class failed"), (Throwable)t);
                }
            } else {
                DebugClassInfo clazz = this.debugContext.getFrame().getLocation().getClassInfo();
                if (clazz != null) {
                    DebugFieldInfo[] fields = clazz.getStaticFields(-1);
                    found = this.checkFields(exp, fields);
                    if (found != null) {
                        return found;
                    }
                    fields = new DebugFieldInfo[]{clazz.getStaticField(exp)};
                    if (fields[0] != null && (found = this.checkFields(exp, fields)) != null) {
                        return found;
                    }
                    String className = clazz.getName();
                    if (className.startsWith("$Oracle.PackageBody.")) {
                        FastStringBuffer sb = new FastStringBuffer(className);
                        for (int i = 0; i < 4; ++i) {
                            sb.removeCharAt(15);
                        }
                        String specClassName = sb.toString();
                        DebugClassInfo specClass = this.debugContext.getVM().findFirstClassByName(specClassName);
                        if (specClass != null) {
                            fields = specClass.getStaticFields(-1);
                            found = this.checkFields(exp, fields);
                            if (found != null) {
                                return found;
                            }
                            fields = new DebugFieldInfo[]{specClass.getStaticField(exp)};
                            if (fields[0] != null && (found = this.checkFields(exp, fields)) != null) {
                                return found;
                            }
                        }
                    }
                }
            }
            found = this.checkVars(exp, vars, false);
            if (found != null) {
                return found;
            }
            found = this.debugContext.getFrame().getVariable(exp);
            if (found != null) {
                return found;
            }
        }
        if (this.debugContext.getVM() != null) {
            found = this.checkClasses(exp);
            if (found != null) {
                return found;
            }
            String clazzName = this.debugContext.getFrame().getLocation().getClassInfo().getName();
            found = this.checkClasses(clazzName + "$" + exp);
            if (found != null) {
                return found;
            }
            if (this.debugContext.getThread() != null && this.debugContext.getFrame() != null && this.debugContext.getFrame().getFrameNumber() == 0) {
                DebugVariableInfo currentReturn;
                DebugVariableInfo currentReturned;
                if (this.debugContext.getThread().equals(this.debugContext.getVM().getCurrentThread())) {
                    DebugDataInfo futureValue;
                    DebugDataObjectInfo currentThrow;
                    if (exp.equals(PluginEvaluatorBase.getThrowExpressionPart()) && (currentThrow = this.debugContext.getVM().getCurrentThrow()) != null) {
                        return currentThrow;
                    }
                    if (exp.equals(PluginEvaluatorBase.getWatchpointObjectExpressionPart())) {
                        DebugDataObjectInfo watchpointObject = this.debugContext.getVM().getWatchpointObject();
                        if (watchpointObject != null) {
                            return watchpointObject;
                        }
                    } else if (exp.equals(PluginEvaluatorBase.getWatchpointFieldExpressionPart())) {
                        DebugFieldInfo watchpointField = this.debugContext.getVM().getWatchpointField();
                        if (watchpointField != null) {
                            return watchpointField;
                        }
                    } else if (exp.equals(PluginEvaluatorBase.getWatchpointFieldFutureValueExpressionPart()) && (futureValue = this.debugContext.getVM().getWatchpointFieldFutureValue()) != null) {
                        return futureValue;
                    }
                }
                if (exp.equals(PluginEvaluatorBase.getReturnedExpressionPart()) && (currentReturned = this.debugContext.getThread().getReturnedValue()) != null) {
                    return currentReturned;
                }
                if (exp.equals(PluginEvaluatorBase.getReturnExpressionPart()) && (currentReturn = this.debugContext.getThread().getReturnValue()) != null) {
                    return currentReturn;
                }
            }
            if (this.debugContext.getFrame() != null) {
                String name = PluginEvaluatorBase.getSlotExpressionPartPrefix();
                if (exp.startsWith(name)) {
                    try {
                        String s = exp.substring(name.length());
                        int index = Integer.parseInt(s.toString());
                        if (index < args.length) {
                            DebugVariableInfo arg = args[index];
                            return arg;
                        }
                        DebugStackSlotInfo[] slots = this.debugContext.getFrame().listSlots();
                        if (index < slots.length) {
                            DebugStackSlotInfo slot = slots[index];
                            DebugDataCompositeInfo slotData = slot.getDataInfo();
                            if (slotData != null) {
                                return slotData;
                            }
                            DebugClassInfo primitiveIntClass = this.findPrimitiveIntClass();
                            if (primitiveIntClass != null) {
                                String value = slot.getValue();
                                return new EvaluationInfo(DebugSharedPrimitives.intDecode(value), primitiveIntClass);
                            }
                        }
                    }
                    catch (Exception s) {
                        // empty catch block
                    }
                }
                if (exp.equals(PluginEvaluatorBase.getClassNameExpressionPart())) {
                    try {
                        DebugClassInfo clazz = this.debugContext.getFrame().getLocation().getClassInfo();
                        if (clazz != null) {
                            DebugClassInfo stringClass = this.findClass("java.lang.String");
                            return new EvaluationInfo(clazz.getName(), stringClass);
                        }
                    }
                    catch (Exception clazz) {
                        // empty catch block
                    }
                }
            }
            if (this.debugContext.getVM().getCapabilities().canGetHeap() && exp.startsWith("_0x")) {
                try {
                    String s = exp.substring(3);
                    long address = Long.parseLong(s, 16);
                    DebugHeapObjectInfo heapObject = this.debugContext.getVM().getHeapObjectAtAddress(address);
                    if (heapObject != null) {
                        DebugDataCompositeInfo data = heapObject.getDataInfo();
                        return data;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private Object checkThisFields(DebugDataInfo data, String exp) {
        Object found = null;
        if (data instanceof DebugDataObjectInfo) {
            DebugDataObjectInfo o = (DebugDataObjectInfo)data;
            String valDollarExp = "val$" + exp;
            String vDollarExp = "v$" + exp;
            if (o.canGetFieldByName()) {
                String vDollarPartial;
                String valDollarPartial;
                String partial;
                DebugFieldInfo field;
                int endPartial = exp.indexOf(46);
                if (endPartial == -1) {
                    endPartial = exp.length();
                }
                if ((field = o.getField(partial = exp.substring(0, endPartial))) != null) {
                    DebugFieldInfo[] fields = new DebugFieldInfo[]{field};
                    found = this.checkFields(exp, fields);
                    if (found != null) {
                        return found;
                    }
                }
                if ((field = o.getField(valDollarPartial = "val$" + partial)) != null) {
                    DebugFieldInfo[] fields = new DebugFieldInfo[]{field};
                    found = this.checkFields(valDollarExp, fields);
                    if (found != null) {
                        return found;
                    }
                }
                if ((field = o.getField(vDollarPartial = "v$" + partial)) != null) {
                    DebugFieldInfo[] fields = new DebugFieldInfo[]{field};
                    found = this.checkFields(vDollarExp, fields);
                    if (found != null) {
                        return found;
                    }
                }
            } else {
                DebugFieldInfo[] fields = o.getFields(-1);
                found = this.checkFields(exp, fields);
                if (found != null) {
                    return found;
                }
                found = this.checkFields(valDollarExp, fields);
                if (found != null) {
                    return found;
                }
                found = this.checkFields(vDollarExp, fields);
                if (found != null) {
                    return found;
                }
            }
        }
        return null;
    }

    protected Object checkVars(String exp, DebugVariableInfo[] vars, boolean skipOutOfScope) {
        for (DebugVariableInfo var : vars) {
            if (skipOutOfScope && !var.isInScope() || !exp.equals(var.getName())) continue;
            return var;
        }
        return null;
    }

    public static DebugVariableInfo findThis(DebugVariableInfo[] args) {
        for (DebugVariableInfo arg : args) {
            if (!arg.getName().equals("this")) continue;
            return arg;
        }
        return null;
    }

    protected Object checkFields(String name, DebugFieldInfo[] fields) {
        for (DebugFieldInfo field : fields) {
            if (!name.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    private Object checkFields(String exp, int expStart, int expLength, DebugFieldInfo[] fields) {
        for (DebugFieldInfo field : fields) {
            int nameLength;
            String name = field.getName();
            if (!exp.regionMatches(expStart, name, 0, nameLength = name.length())) continue;
            if (expLength - expStart == nameLength) {
                return field;
            }
            DebugDataInfo data = field.getDataInfo();
            Object found = this.partialMatch(exp, expStart + nameLength, expLength, data);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    protected DebugClassInfo checkClasses(String exp) {
        if (this.debugContext.getVM() != null) {
            DebugClassInfo clazz = this.debugContext.getVM().findFirstClassByName(exp);
            if (clazz != null) {
                return clazz;
            }
            clazz = this.debugContext.getVM().findFirstClassByName(exp, true);
            if (clazz != null) {
                return clazz;
            }
        }
        return null;
    }

    protected Object partialMatch(String exp, int expStart, int expLength, Object data) {
        char c = exp.charAt(expStart);
        if (c == '.') {
            ++expStart;
            if (data instanceof DebugDataObjectInfo) {
                DebugDataObjectInfo o = (DebugDataObjectInfo)data;
                if (o.canGetFieldByName()) {
                    String partial;
                    DebugFieldInfo field;
                    int endPartial = exp.indexOf(46, expStart);
                    if (endPartial == -1 || endPartial > expLength) {
                        endPartial = expLength;
                    }
                    if ((field = o.getField(partial = exp.substring(expStart, endPartial))) != null) {
                        DebugFieldInfo[] fields = new DebugFieldInfo[]{field};
                        return this.checkFields(exp, expStart, expLength, fields);
                    }
                    return null;
                }
                DebugFieldInfo[] fields = o.getFields(-1);
                return this.checkFields(exp, expStart, expLength, fields);
            }
            if (data instanceof DebugDataArrayInfo) {
                int length;
                DebugDataArrayInfo a = (DebugDataArrayInfo)data;
                if (!a.isNull() && expLength - expStart == 6 && exp.regionMatches(expStart, "length", 0, 6) && (length = a.getArrayCount()) != -1) {
                    try {
                        DebugClassInfo primitiveIntClass = this.findPrimitiveIntClass();
                        if (primitiveIntClass != null) {
                            return new EvaluationInfo(length, primitiveIntClass);
                        }
                    }
                    catch (Exception primitiveIntClass) {}
                }
            } else if (data instanceof DebugClassInfo) {
                DebugClassInfo clazz = (DebugClassInfo)data;
                DebugFieldInfo[] fields = clazz.getStaticFields(-1);
                Object found = this.checkFields(exp, expStart, expLength, fields);
                if (found != null) {
                    return found;
                }
                fields = new DebugFieldInfo[]{clazz.getStaticField(exp.substring(expStart, expLength))};
                if (fields[0] != null && (found = this.checkFields(exp, expStart, expLength, fields)) != null) {
                    return found;
                }
            }
        }
        return null;
    }

    public static DebugDataInfo getDataInfo(Object o) {
        if (o instanceof DebugDataInfo) {
            return (DebugDataInfo)o;
        }
        if (o instanceof DebugHasDataInfo) {
            return ((DebugHasDataInfo)o).getDataInfo();
        }
        if (o instanceof EvaluationInfo) {
            return (DebugDataInfo)((EvaluationInfo)o).getDataInfo();
        }
        return null;
    }

    protected long getComparableId(EvaluationInfo eval1) throws Exception {
        long id;
        DebugDataInfo data1 = (DebugDataInfo)eval1.getDataInfo();
        if (data1 instanceof DebugDataCompositeInfo && (id = CommonHelperFunctions.getObjectNumber((DebugDataCompositeInfo)data1)) != 0L) {
            return id;
        }
        if (eval1.isNull()) {
            return 0L;
        }
        throw new Exception("Unable to evaluate comparison operator");
    }

    protected DebugMethodInfo getCurrentMethod() {
        if (this.debugContext.getFrame() != null) {
            return this.debugContext.getFrame().getLocation().getMethod();
        }
        return null;
    }

    protected DebugClassInfo findClass(String name) {
        return this.checkClasses(name);
    }

    protected DebugClassInfo findPrimitiveIntClass() {
        return null;
    }

    public static String getThrowExpressionPart() {
        return "_throw";
    }

    public static String getReturnedExpressionPart() {
        return "Returned_value";
    }

    public static String getReturnExpressionPart() {
        return "Return_value";
    }

    public static String getSlotExpressionPartPrefix() {
        return "_slot";
    }

    static String getClassNameExpressionPart() {
        return "_classname";
    }

    static String getWatchpointObjectExpressionPart() {
        return "_watchpointObject";
    }

    static String getWatchpointFieldExpressionPart() {
        return "_watchpointField";
    }

    static String getWatchpointFieldFutureValueExpressionPart() {
        return "_watchpointFutureValue";
    }
}

