/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.extender.evaluator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import oracle.ide.debugger.extender.evaluator.DebuggerExtenderData;
import oracle.ide.runner.DebuggeeData;
import oracle.ideimpl.debugger.extender.evaluator.CommonDataBase;
import oracle.ideimpl.runner.SonOfDebuggeeData;
import oracle.jdevimpl.debugger.extender.evaluator.CustomDataProvider;
import oracle.jdevimpl.debugger.extender.evaluator.EvaluatorHandle;
import oracle.jdevimpl.debugger.extender.evaluator.ExtenderEvaluatorContext;
import oracle.jdevimpl.debugger.support.DebugDataArrayInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugDataPrimitiveInfo;
import oracle.jdevimpl.runner.debug.DataItem;

class DebuggeeDataInfo {
    protected DataItem customDataItem;
    protected EvaluatorHandle evaluator;
    protected CustomDataProvider customDataProvider;
    protected DebuggeeDataInfo parent;

    private DebuggeeDataInfo() {
    }

    public static DebuggeeDataInfoVersion12 createDebuggeeDataInfoVersion12(DebuggeeDataInfo parent, DataItem customDataItem, EvaluatorHandle evaluator, CustomDataProvider customDataProvider) {
        return new DebuggeeDataInfo().new DebuggeeDataInfoVersion12(parent, customDataItem, evaluator, customDataProvider);
    }

    public static DebuggeeDataInfoVersion13 createDebuggeeDataInfoVersion13(DebuggeeDataInfo parent, DataItem customDataItem, EvaluatorHandle evaluator, CustomDataProvider customDataProvider) {
        return new DebuggeeDataInfo().new DebuggeeDataInfoVersion13(parent, customDataItem, evaluator, customDataProvider);
    }

    protected Object getDataInfo() {
        return this.customDataProvider.getDataInfo(this.customDataItem);
    }

    protected DataItem getCustomDataItem() {
        return this.customDataItem;
    }

    protected boolean setCustomProviderContext() {
        ExtenderEvaluatorContext context = this.evaluator.getEvaluatorContext();
        if (context != null) {
            this.customDataProvider.updateContext(context.getDebuggingProcess(), context.getVm(), context.getThread(), context.getStackFrame());
            return true;
        }
        return false;
    }

    public boolean mayHaveChildren() {
        if (this.setCustomProviderContext()) {
            return this.customDataProvider.mayHaveChildren(this.customDataItem);
        }
        return false;
    }

    public String getShortLabel() {
        if (this.setCustomProviderContext()) {
            return this.customDataProvider.getName(this.customDataItem);
        }
        return null;
    }

    public String getLongLabel() {
        if (this.setCustomProviderContext()) {
            return this.customDataProvider.getValue(this.customDataItem);
        }
        return null;
    }

    public Icon getIcon() {
        if (this.setCustomProviderContext()) {
            return this.customDataProvider.getIcon(this.customDataItem);
        }
        return null;
    }

    public String getToolTipText() {
        return null;
    }

    public String getActualType() {
        if (this.setCustomProviderContext()) {
            return this.customDataProvider.getActualType(this.customDataItem);
        }
        return null;
    }

    public String getFullyQualifiedActualType() {
        if (this.setCustomProviderContext()) {
            return this.customDataProvider.getFullyQualifiedActualType(this.customDataItem);
        }
        return null;
    }

    public String getDeclaredType() {
        if (this.setCustomProviderContext()) {
            return this.customDataProvider.getDeclaredType(this.customDataItem);
        }
        return null;
    }

    public String getFullyQualifiedDeclaredType() {
        if (this.setCustomProviderContext()) {
            return this.customDataProvider.getFullyQualifiedDeclaredType(this.customDataItem);
        }
        return null;
    }

    public String getHexValue() {
        if (this.setCustomProviderContext()) {
            return this.customDataProvider.getHexValue(this.customDataItem);
        }
        return null;
    }

    public String getAddress() {
        if (this.setCustomProviderContext()) {
            return this.customDataProvider.getAddress(this.customDataItem);
        }
        return null;
    }

    public void inspect() {
        if (this.setCustomProviderContext()) {
            this.customDataProvider.inspect(this.createTreePath(), this.customDataItem);
        }
    }

    public boolean canInspect() {
        if (this.setCustomProviderContext()) {
            return this.customDataProvider.canInspect(this.createTreePath(), this.customDataItem);
        }
        return false;
    }

    public void watch() {
        if (this.setCustomProviderContext()) {
            this.customDataProvider.watch(this.createTreePath(), this.customDataItem);
        }
    }

    public boolean canWatch() {
        if (this.setCustomProviderContext()) {
            return this.customDataProvider.canWatch(this.createTreePath(), this.customDataItem);
        }
        return false;
    }

    public void inspectClassLoader() {
        if (this.setCustomProviderContext()) {
            this.customDataProvider.inspectClassLoader(this.customDataItem);
        }
    }

    public boolean canInspectClassLoader() {
        if (this.setCustomProviderContext()) {
            return this.customDataProvider.canInspectClassLoader(this.customDataItem);
        }
        return false;
    }

    public void watchClassLoader() {
        if (this.setCustomProviderContext()) {
            this.customDataProvider.watchClassLoader(this.customDataItem);
        }
    }

    public boolean canWatchClassLoader() {
        if (this.setCustomProviderContext()) {
            return this.customDataProvider.canWatchClassLoader(this.customDataItem);
        }
        return false;
    }

    public void viewWholeValue() {
        if (this.setCustomProviderContext()) {
            this.customDataProvider.viewWholeValue(this.customDataItem);
        }
    }

    public boolean canViewWholeValue() {
        if (this.setCustomProviderContext()) {
            return this.customDataProvider.canViewWholeValue(this.customDataItem);
        }
        return false;
    }

    public void gotoDeclaredType() {
        if (this.setCustomProviderContext()) {
            this.customDataProvider.gotoDeclaredType(this.customDataItem);
        }
    }

    public String canGotoDeclaredType() {
        if (this.setCustomProviderContext()) {
            return this.customDataProvider.canGotoDeclaredType(this.customDataItem);
        }
        return null;
    }

    public void gotoActualType() {
        if (this.setCustomProviderContext()) {
            this.customDataProvider.gotoActualType(this.customDataItem);
        }
    }

    public String canGotoActualType() {
        if (this.setCustomProviderContext()) {
            return this.customDataProvider.canGotoActualType(this.customDataItem);
        }
        return null;
    }

    public void gotoField() {
        if (this.setCustomProviderContext()) {
            this.customDataProvider.gotoField(this.customDataItem);
        }
    }

    public String canGotoField() {
        if (this.setCustomProviderContext()) {
            return this.customDataProvider.canGotoField(this.customDataItem);
        }
        return null;
    }

    public void adjustRange() {
        if (this.setCustomProviderContext()) {
            this.customDataProvider.adjustRange(this.createTreePath(), this.customDataItem);
        }
    }

    public boolean setRange(int start, int count) {
        if (this.setCustomProviderContext()) {
            return this.customDataProvider.adjustRange(this.createTreePath(), this.customDataItem, start, count);
        }
        return false;
    }

    public boolean setMaximumRange() {
        if (this.setCustomProviderContext()) {
            int max = this.customDataItem.getRangeLength();
            return this.customDataProvider.adjustRange(this.createTreePath(), this.customDataItem, 0, max);
        }
        return false;
    }

    public int getRangeStart() {
        if (this.setCustomProviderContext()) {
            return this.customDataProvider.getRangeStart(this.customDataItem);
        }
        return -1;
    }

    public int getRangeCount() {
        if (this.setCustomProviderContext()) {
            return this.customDataProvider.getRangeCount(this.customDataItem);
        }
        return -1;
    }

    public boolean canAdjustRange() {
        if (this.setCustomProviderContext()) {
            return this.customDataProvider.canAdjustRange(this.customDataItem);
        }
        return false;
    }

    public void showObjectPreferences() {
        if (this.setCustomProviderContext()) {
            this.customDataProvider.showObjectPreferences(this.customDataItem);
        }
    }

    public boolean canShowObjectPreferences() {
        if (this.setCustomProviderContext()) {
            return this.customDataProvider.canShowObjectPreferences(this.customDataItem);
        }
        return false;
    }

    public void toggleValue() {
        if (this.setCustomProviderContext()) {
            this.customDataProvider.toggleValue(this.customDataItem);
        }
    }

    public boolean canToggleValue() {
        if (this.setCustomProviderContext()) {
            return this.customDataProvider.canToggleValue(this.customDataItem);
        }
        return false;
    }

    public void viewAnnotations() {
        if (this.setCustomProviderContext()) {
            this.customDataProvider.viewAnnotations(this.customDataItem);
        }
    }

    public String canViewAnnotations() {
        if (this.setCustomProviderContext()) {
            return this.customDataProvider.canViewAnnotations(this.customDataItem);
        }
        return null;
    }

    public void viewAnnotationsForClass() {
        if (this.setCustomProviderContext()) {
            this.customDataProvider.viewAnnotationsForClass(this.customDataItem);
        }
    }

    public boolean canViewAnnotationsForClass() {
        if (this.setCustomProviderContext()) {
            return this.customDataProvider.canViewAnnotationsForClass(this.customDataItem);
        }
        return false;
    }

    public void modifyValue() {
        if (this.setCustomProviderContext()) {
            this.customDataProvider.modifyValue(this.customDataItem);
        }
    }

    public boolean canModifyValue() {
        if (this.setCustomProviderContext()) {
            return this.customDataProvider.canModifyValue(this.customDataItem);
        }
        return false;
    }

    public void setDisplayName(String displayName) {
        if (this.setCustomProviderContext()) {
            this.customDataItem.setDisplayName(displayName);
        }
    }

    protected TreePath createTreePath() {
        ArrayList<DataItem> elements = new ArrayList<DataItem>();
        DebuggeeDataInfo element = this;
        do {
            elements.add(0, element.customDataItem);
        } while ((element = element.parent) != null);
        return new TreePath(elements.toArray(new DataItem[elements.size()]));
    }

    public String getID() {
        return this.customDataItem.getID();
    }

    public String getReasonValueIsNotAvailable() {
        return this.customDataItem.getReasonValueIsNotAvailable();
    }

    public class DebuggeeDataInfoVersion12
    extends DebuggeeDataInfo
    implements SonOfDebuggeeData {
        private DebuggeeDataInfoVersion12(DebuggeeDataInfo parent, DataItem customDataItem, EvaluatorHandle evaluator, CustomDataProvider customDataProvider) {
            this.parent = parent;
            this.customDataItem = customDataItem;
            this.evaluator = evaluator;
            this.customDataProvider = customDataProvider;
        }

        private DebuggeeDataInfoVersion12 createDebuggeeDataInfo(DataItem dataItem) {
            return DebuggeeDataInfo.createDebuggeeDataInfoVersion12(this, dataItem, this.evaluator, this.customDataProvider);
        }

        public List<? extends DebuggeeData> getChildren() {
            if (this.setCustomProviderContext()) {
                Iterator<DataItem> dataItems = this.customDataProvider.getChildren(this.customDataItem);
                ArrayList<DebuggeeDataInfoVersion12> children = new ArrayList<DebuggeeDataInfoVersion12>();
                while (dataItems.hasNext()) {
                    children.add(this.createDebuggeeDataInfo(dataItems.next()));
                }
                return children;
            }
            return null;
        }

        public CommonDataBase.DataKind getKind() {
            Object dataInfo = this.getDataInfo();
            if (dataInfo instanceof DebugDataObjectInfo) {
                return CommonDataBase.DataKind.OBJECT;
            }
            if (dataInfo instanceof DebugDataPrimitiveInfo) {
                return CommonDataBase.DataKind.PRIMITIVE;
            }
            if (dataInfo instanceof DebugDataArrayInfo) {
                return CommonDataBase.DataKind.ARRAY;
            }
            return null;
        }

        public List<? extends DebuggeeData> getFields() {
            List<DataItem> fields;
            if (this.setCustomProviderContext() && (fields = this.customDataItem.getFields()) != null) {
                return this.makeDebuggeeData(fields);
            }
            return null;
        }

        public List<? extends DebuggeeData> getDeclaredFields() {
            List<DataItem> fields;
            if (this.setCustomProviderContext() && (fields = this.customDataItem.getDeclaredFields()) != null) {
                return this.makeDebuggeeData(fields);
            }
            return null;
        }

        public DebuggeeData getField(String fieldName) {
            DataItem dataItem;
            if (this.setCustomProviderContext() && (dataItem = this.customDataItem.getField(fieldName)) != null) {
                return this.createDebuggeeDataInfo(dataItem);
            }
            return null;
        }

        private List<DebuggeeDataInfoVersion12> makeDebuggeeData(List<DataItem> dataItems) {
            ArrayList<DebuggeeDataInfoVersion12> debuggeeDataList = new ArrayList<DebuggeeDataInfoVersion12>();
            for (DataItem dataItem : dataItems) {
                debuggeeDataList.add(this.createDebuggeeDataInfo(dataItem));
            }
            return debuggeeDataList;
        }
    }

    public class DebuggeeDataInfoVersion13
    extends DebuggeeDataInfo
    implements DebuggerExtenderData {
        private DebuggeeDataInfoVersion13(DebuggeeDataInfo parent, DataItem customDataItem, EvaluatorHandle evaluator, CustomDataProvider customDataProvider) {
            this.parent = parent;
            this.customDataItem = customDataItem;
            this.evaluator = evaluator;
            this.customDataProvider = customDataProvider;
        }

        private DebuggeeDataInfoVersion13 createDebuggeeDataInfo(DataItem dataItem) {
            return DebuggeeDataInfo.createDebuggeeDataInfoVersion13(this, dataItem, this.evaluator, this.customDataProvider);
        }

        public List<? extends DebuggerExtenderData> getChildren() {
            if (this.setCustomProviderContext()) {
                Iterator<DataItem> dataItems = this.customDataProvider.getChildren(this.customDataItem);
                ArrayList<DebuggeeDataInfoVersion13> children = new ArrayList<DebuggeeDataInfoVersion13>();
                while (dataItems.hasNext()) {
                    children.add(this.createDebuggeeDataInfo(dataItems.next()));
                }
                return children;
            }
            return null;
        }

        public CommonDataBase.DataKind getKind() {
            Object dataInfo = this.getDataInfo();
            if (dataInfo instanceof DebugDataObjectInfo) {
                return CommonDataBase.DataKind.OBJECT;
            }
            if (dataInfo instanceof DebugDataPrimitiveInfo) {
                return CommonDataBase.DataKind.PRIMITIVE;
            }
            if (dataInfo instanceof DebugDataArrayInfo) {
                return CommonDataBase.DataKind.ARRAY;
            }
            return null;
        }

        public List<? extends DebuggerExtenderData> getFields() {
            List<DataItem> fields;
            if (this.setCustomProviderContext() && (fields = this.customDataItem.getFields()) != null) {
                return this.makeDebuggeeData(fields);
            }
            return null;
        }

        public List<? extends DebuggerExtenderData> getDeclaredFields() {
            List<DataItem> fields;
            if (this.setCustomProviderContext() && (fields = this.customDataItem.getDeclaredFields()) != null) {
                return this.makeDebuggeeData(fields);
            }
            return null;
        }

        public DebuggerExtenderData getField(String fieldName) {
            DataItem dataItem;
            if (this.setCustomProviderContext() && (dataItem = this.customDataItem.getField(fieldName)) != null) {
                return this.createDebuggeeDataInfo(dataItem);
            }
            return null;
        }

        private List<DebuggeeDataInfoVersion13> makeDebuggeeData(List<DataItem> dataItems) {
            ArrayList<DebuggeeDataInfoVersion13> debuggeeDataList = new ArrayList<DebuggeeDataInfoVersion13>();
            for (DataItem dataItem : dataItems) {
                debuggeeDataList.add(this.createDebuggeeDataInfo(dataItem));
            }
            return debuggeeDataList;
        }
    }
}

