/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.runner;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.ceditor.CodeEditorGutterView;
import oracle.ide.ceditor.LineNavigationPoint;
import oracle.ide.config.DTCache;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.file.ProjectCache;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.PackagedSourceNode;
import oracle.ide.model.Project;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.navigation.DefaultNavigationPoint;
import oracle.ide.navigation.NavigationContext;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ide.util.ResourceUtils;
import oracle.ide.view.View;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Log;
import oracle.jdeveloper.runner.RunMgrArb;
import oracle.jdeveloper.runner.SourceFinder;
import oracle.jdeveloper.runner.SourceFinderManager;
import oracle.jdevimpl.debugger.plugin.hooks.DebuggerHelperHook;
import oracle.jdevimpl.debugger.plugin.hooks.DebuggerLanguageHelper;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.SourceHook;

public final class Source {
    private static final Log logger = new Log("Runner_Source");
    private static final String SOURCE_NOT_FOUND_PANEL_PICKS = "SOURCE.NOT.FOUND.PANEL.PICKS";
    private static ProgressBar findSourceProgressBar;
    private static final int DO_NOTHING = 0;
    private static final int LOOK_IN_PROJECT = 1;
    private static final int LOOK_IN_SOURCE_FINDER = 2;
    private static final int URL_CHOOSER = 3;
    private static final int GENERATE_STUB = 4;
    private static final int DONT_ASK = 5;
    private static final int USE_LOCATOR_RESULT = 6;
    private static List<String> dontAsk;

    private Source() {
    }

    public static boolean showSourceFile(Workspace workspace, Project project, String pkg, String fullClassName, String filename, int line, boolean selectLine) {
        return Source.showSourceFile(workspace, project, pkg, fullClassName, filename, line, selectLine, null);
    }

    public static boolean showSourceFile(Workspace workspace, Project project, String pkg, String fullClassName, String filename, int line, boolean selectLine, String sourceNotFoundMessage) {
        return Source.showSourceFile(workspace, project, pkg, fullClassName, filename, line, selectLine, sourceNotFoundMessage, null);
    }

    public static boolean showSourceFile(Workspace workspace, Project project, String pkg, String fullClassName, String filename, int line, boolean selectLine, String sourceNotFoundMessage, DebugVirtualMachine vm) {
        Node node;
        URL url;
        try {
            url = Source.findSourceFile(workspace, project, pkg, filename);
            if (url != null && (node = NodeFactory.findOrCreate((URL)url)) != null && Source.showSourceFile(workspace, project, node, line, selectLine)) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (fullClassName != null) {
            try {
                url = Source.findURLForClassSource(workspace, project, fullClassName);
                if (url != null && (node = NodeFactory.findOrCreate((URL)url)) != null && filename.equals(Source.getFilenameFromNode(node)) && Source.packageMatches(pkg, node, project) && Source.showSourceFile(workspace, project, node, line, selectLine)) {
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                url = Source.findOpenSourceStub(workspace, project, fullClassName);
                if (url != null && (node = NodeFactory.findOrCreate((URL)url)) != null && Source.showSourceFile(workspace, project, node, line, selectLine)) {
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        StringBuilder urlKeyStringSB = new StringBuilder();
        if (workspace != null && workspace.getURL() != null) {
            urlKeyStringSB.append(workspace.getURL().toString());
        }
        if (vm != null) {
            if (project != null && project.getURL() != null) {
                urlKeyStringSB.append(project.getURL().toString());
            }
            if (pkg != null) {
                urlKeyStringSB.append(pkg);
            }
            if (filename != null) {
                urlKeyStringSB.append(filename);
            }
            if (fullClassName != null) {
                urlKeyStringSB.append(fullClassName);
            }
            if (urlKeyStringSB.length() != 0) {
                try {
                    Node node2;
                    URL url2 = vm.getChachedUserFoundLocation(urlKeyStringSB.toString());
                    if (url2 != null && (node2 = NodeFactory.findOrCreate((URL)url2)) != null && Source.showSourceFile(workspace, project, node2, line, selectLine)) {
                        return true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return Source.showSourceNotFoundDialog(workspace, project, pkg, filename, fullClassName, line, selectLine, sourceNotFoundMessage, vm, urlKeyStringSB == null ? "" : urlKeyStringSB.toString());
    }

    public static boolean showSourceFile(Workspace workspace, Project project, URL url, int line, boolean selectLine) {
        return Source.showSourceFile(workspace, project, url, line, selectLine, true);
    }

    public static boolean showSourceFile(Workspace workspace, Project project, URL url, int line, boolean selectLine, boolean showInNavHistory) {
        try {
            Node node = NodeFactory.findOrCreate((URL)url);
            if (node != null) {
                return Source.showSourceFile(workspace, project, node, line, selectLine, showInNavHistory);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean showSourceFile(Workspace workspace, Project project, Node node, int line, boolean selectLine) {
        return Source.showSourceFile(workspace, project, node, line, selectLine, true);
    }

    public static boolean showSourceFile(Workspace workspace, Project project, Node node, int line, boolean selectLine, boolean showInNavHistory) {
        Context context = Source.findOpenContext(workspace, node);
        if (context == null) {
            context = Source.createContext(workspace, project, node);
        }
        if (context != null) {
            try {
                NavigationContext navigationContext = new NavigationContext();
                navigationContext.set(NavigationContext.ContextKey.Context, (Object)context);
                navigationContext.set(NavigationContext.ContextKey.Line, (Object)line);
                navigationContext.set(NavigationContext.ContextKey.Node, (Object)node);
                final NavigationManager mgr = NavigationManager.getNavigationManager();
                NavigationPoint point = NavigationManager.getNavigationPoint((NavigationContext)navigationContext);
                if (point == null) {
                    point = new LineNavigationPoint(context, line, 0, selectLine);
                }
                final NavigationPoint navPoint = point;
                Callable<Boolean> navigationTask = mgr != null ? new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        try {
                            if (mgr.navigateTo(navPoint) != 0) {
                                return false;
                            }
                        }
                        catch (Exception e) {
                            return false;
                        }
                        return true;
                    }
                } : new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        try {
                            if (navPoint.navigate() != 0) {
                                return false;
                            }
                        }
                        catch (Exception e) {
                            return false;
                        }
                        return true;
                    }
                };
                Boolean navigationSuccess = Boolean.TRUE;
                if (SwingUtilities.isEventDispatchThread()) {
                    navigationSuccess = navigationTask.call();
                } else {
                    FutureTask<Boolean> ft = new FutureTask<Boolean>(navigationTask);
                    SwingUtilities.invokeLater(ft);
                    navigationSuccess = ft.get(5L, TimeUnit.SECONDS);
                }
                if (!navigationSuccess.booleanValue()) {
                    return false;
                }
                if (!showInNavHistory && point instanceof DefaultNavigationPoint) {
                    ((DefaultNavigationPoint)point).contextRemoved();
                }
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
            return true;
        }
        return false;
    }

    public static CodeEditor showNodeInCodeEditor(Workspace workspace, Project project, Node node) {
        try {
            Context context = Source.createContext(workspace, project, node);
            return (CodeEditor)EditorManager.getEditorManager().openEditorInFrame(CodeEditor.class, context);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Editor showNodeInDefaultEditor(Workspace workspace, Project project, Node node) {
        try {
            Context context = Source.createContext(workspace, project, node);
            return EditorManager.getEditorManager().openDefaultEditorInFrame(context);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Context findOpenContext(Workspace workspace, Node node) {
        for (Object e : EditorManager.getEditorManager().getAllEditors()) {
            URL codeEditorWorkspaceURL;
            CodeEditor editor;
            Context context;
            if (!(e instanceof CodeEditor) || (context = (editor = (CodeEditor)e).getContext()) == null || context.getNode() != node) continue;
            URL workspaceURL = workspace != null ? workspace.getURL() : null;
            Workspace codeEditorWorkspace = context.getWorkspace();
            URL uRL = codeEditorWorkspaceURL = codeEditorWorkspace != null ? codeEditorWorkspace.getURL() : null;
            if (workspaceURL != null && codeEditorWorkspaceURL != null && !URLFileSystem.equals((URL)workspaceURL, (URL)codeEditorWorkspaceURL)) continue;
            return context;
        }
        return null;
    }

    private static Context createContext(Workspace workspace, Project project, Node node) {
        try {
            Context ideContext = Context.newIdeContext((Node)node);
            if (workspace != null && workspace != Ide.getDefaultWorkspace()) {
                ideContext.setWorkspace(workspace);
            }
            ideContext.setProject(project);
            List<DebuggerLanguageHelper> helpers = DebuggerHelperHook.getLanguageSpecificHelpers(project);
            for (DebuggerLanguageHelper helper : helpers) {
                Project definingProject;
                if (!helper.canGetDefiningProjectFromContext(ideContext) || (definingProject = helper.getDefiningProjectFromContext(ideContext, node.getURL())) == null) continue;
                ideContext.setProject(definingProject);
            }
            return ideContext;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void addSourceFinder(SourceFinder finder) {
        SourceHook.addSourceFinder(finder);
    }

    public static void removeSourceFinder(SourceFinder finder) {
        SourceHook.removeSourceFinder(finder);
    }

    public static void addSourceFinderManager(SourceFinderManager manager) {
        SourceHook.addSourceFinderManager(manager);
    }

    public static void removeSourceFinderManager(SourceFinderManager manager) {
        SourceHook.removeSourceFinderManager(manager);
    }

    public static boolean showUIDesigner(Workspace workspace, Project project, URL url) {
        try {
            Node node = NodeFactory.findOrCreate((URL)url);
            if (node != null) {
                return Source.showUIDesigner(workspace, project, node);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean showUIDesigner(Workspace workspace, Project project, Node node) {
        try {
            Context ideContext = Context.newIdeContext((Node)node);
            if (workspace != null && workspace != Ide.getDefaultWorkspace()) {
                ideContext.setWorkspace(workspace);
            }
            if (project != null && project != Ide.getDefaultProject()) {
                ideContext.setProject(project);
            }
            List<DebuggerLanguageHelper> helpers = DebuggerHelperHook.getLanguageSpecificHelpers(project);
            for (DebuggerLanguageHelper helper : helpers) {
                if (!helper.canOpenEditorForContext(ideContext)) continue;
                return helper.openEditorForContext(ideContext);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL findSourceFile(Workspace workspace, Project project, String pkg, String filename) {
        WaitCursor wc = new WaitCursor((Component)Ide.getMainWindow());
        try {
            wc.show(0);
            Node[] openedFiles = Source.getOpenedFiles(workspace, project);
            URL found = Source.lookForFile(pkg, filename, project, openedFiles);
            if (found != null) {
                URL uRL = found;
                return uRL;
            }
            if (project != null) {
                int lastDot = filename.lastIndexOf(46);
                Object fullClassName = lastDot == -1 ? filename : filename.substring(0, lastDot);
                if (pkg != null && pkg.length() > 0) {
                    fullClassName = pkg + "." + (String)fullClassName;
                }
                if ((found = Source.findURLForClassSource(workspace, project, (String)fullClassName)) != null) {
                    try {
                        Node node = NodeFactory.findOrCreate((URL)found);
                        if (node != null && filename.equals(Source.getFilenameFromNode(node)) && Source.packageMatches(pkg, node, project)) {
                            URL uRL = found;
                            return uRL;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            URL uRL = Source.askSourceFinders(workspace, project, pkg, filename);
            return uRL;
        }
        finally {
            wc.hide();
        }
    }

    public static URL askSourceFinders(Workspace workspace, Project project, String pkg, String filename) {
        URL found = null;
        Iterator<SourceFinder> sourceFinderIterator = SourceHook.getSourceFinders(workspace, project).iterator();
        while (found == null && sourceFinderIterator.hasNext()) {
            SourceFinder finder = sourceFinderIterator.next();
            found = finder.findSourceFile(workspace, project, pkg, filename);
        }
        return found;
    }

    public static URL findURLForClass(Workspace workspace, Project project, String fullClassName) {
        return Source.findURLForClassSource(workspace, project, fullClassName);
    }

    public static URL findURLForClassSource(Workspace workspace, Project project, String fullClassName) {
        return Source.findURLForClassSource(project, fullClassName);
    }

    public static URL findURLForClassSource(Project project, String fullClassName) {
        List<DebuggerLanguageHelper> helpers = DebuggerHelperHook.getLanguageSpecificHelpers(project);
        for (DebuggerLanguageHelper helper : helpers) {
            if (!helper.canGetURLForSourceClass()) continue;
            return helper.getURLForSourceClass(project, fullClassName);
        }
        return null;
    }

    public static URL findURLForClassStub(Workspace workspace, Project project, String fullClassName) {
        return Source.findURLForClassStub(project, fullClassName);
    }

    public static URL findURLForClassStub(Project project, String fullClassName) {
        List<DebuggerLanguageHelper> helpers = DebuggerHelperHook.getLanguageSpecificHelpers(project);
        for (DebuggerLanguageHelper helper : helpers) {
            if (!helper.canGetURLForClassStubByName()) continue;
            return helper.getURLForClassStubByName(project, fullClassName);
        }
        return null;
    }

    public static URL findOpenSourceStub(Workspace workspace, Project project, String fullClassName) {
        URL urlStub = Source.findURLForClassStub(workspace, project, fullClassName);
        if (urlStub != null) {
            Node[] openedFiles = Source.getOpenedFiles();
            for (int i = openedFiles.length - 1; i >= 0; --i) {
                if (!urlStub.equals(openedFiles[i].getURL())) continue;
                return urlStub;
            }
        }
        return null;
    }

    public static Node[] getProjectFileList(Project project) {
        ArrayList<Node> al = new ArrayList<Node>();
        if (project != null) {
            Source.recurseFileList((Node)project, al);
        }
        return al.toArray(new Node[al.size()]);
    }

    private static void recurseFileList(Node node, ArrayList<Node> al) {
        Iterator childIter = node.getChildren();
        if (childIter != null) {
            while (childIter.hasNext()) {
                Object next = childIter.next();
                if (!(next instanceof Node)) continue;
                Node child = (Node)next;
                if (child.mayHaveChildren()) {
                    Source.recurseFileList(child, al);
                    continue;
                }
                al.add(child);
            }
        }
    }

    private static URL lookForFile(String pkg, String filename, Project project, Node[] files) {
        for (int i = files.length - 1; i >= 0; --i) {
            Node file = files[i];
            if (!filename.equals(Source.getFilenameFromNode(file)) || !Source.packageMatches(pkg, file, project)) continue;
            return file.getURL();
        }
        return null;
    }

    public static Node[] getOpenedFiles() {
        final ArrayList resultList = new ArrayList();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                List editors = EditorManager.getEditorManager().getAllEditors();
                for (int i = editors.size() - 1; i >= 0; --i) {
                    Node node;
                    CodeEditor editor;
                    Context context;
                    Object e = editors.get(i);
                    if (!(e instanceof CodeEditor) || (context = (editor = (CodeEditor)e).getContext()) == null || (node = context.getNode()) == null) continue;
                    resultList.add(node);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return resultList.toArray(new Node[resultList.size()]);
    }

    public static Node[] getOpenedFiles(final Workspace workspace, Project project) {
        final ArrayList resultList = new ArrayList();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                URL workspaceURL = workspace != null ? workspace.getURL() : null;
                List editors = EditorManager.getEditorManager().getAllEditors();
                for (int i = editors.size() - 1; i >= 0; --i) {
                    Node node;
                    URL codeEditorWorkspaceURL;
                    CodeEditor editor;
                    Context context;
                    Object e = editors.get(i);
                    if (!(e instanceof CodeEditor) || (context = (editor = (CodeEditor)e).getContext()) == null) continue;
                    Workspace codeEditorWorkspace = context.getWorkspace();
                    URL uRL = codeEditorWorkspaceURL = codeEditorWorkspace != null ? codeEditorWorkspace.getURL() : null;
                    if (workspaceURL != null && codeEditorWorkspaceURL != null && !URLFileSystem.equals((URL)workspaceURL, (URL)codeEditorWorkspaceURL) || (node = context.getNode()) == null) continue;
                    resultList.add(node);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return resultList.toArray(new Node[resultList.size()]);
    }

    public static String getFilenameFromNode(Node node) {
        if (node instanceof PackagedSourceNode) {
            String fileName = ((PackagedSourceNode)node).getSourceFile();
            return fileName != null ? fileName : "";
        }
        return URLFileSystem.getFileName((URL)node.getURL());
    }

    public static String getPackageFromNode(Node node, Project project) {
        if (node instanceof PackagedSourceNode) {
            try {
                String pkg = ((PackagedSourceNode)node).getPackage(project);
                if (pkg != null && pkg.contains("_WEB-INF")) {
                    boolean caseSensitive = System.getProperty("weblogic.jsp.windows.caseSensitive") != null || System.getProperty("weblogic.jsp.caseSensitive") != null;
                    pkg = caseSensitive ? pkg.replaceAll("_WEB-INF", "_WEB_45_INF") : pkg.replaceAll("_WEB-INF", "_web_45_inf");
                }
                return pkg != null ? pkg : "";
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    public static boolean packageMatches(String pkg, Node node, Project project) {
        String nodePkg = Source.getPackageFromNode(node, project);
        return Source.packageMatches(pkg, nodePkg);
    }

    public static boolean packageMatches(String pkg, String nodePkg) {
        if (pkg.equals(nodePkg)) {
            return true;
        }
        if (nodePkg != null && nodePkg.length() > 0 && nodePkg.charAt(0) == '*' && pkg.endsWith(nodePkg.substring(1))) {
            return true;
        }
        if (pkg.length() > 0 && pkg.charAt(0) == '*' && nodePkg.endsWith(pkg.substring(1))) {
            return true;
        }
        return pkg.startsWith("jsp_servlet") && pkg.equalsIgnoreCase(nodePkg);
    }

    public static CodeEditor getCodeEditorFromContext(Context context) {
        if (context != null) {
            View view = context.getView();
            if (view instanceof CodeEditor) {
                return (CodeEditor)view;
            }
            if (view instanceof CodeEditorGutterView) {
                return (CodeEditor)view.owner();
            }
        }
        return null;
    }

    public static Node getNodeFromCodeEditor(Context context) {
        CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
        if (codeEditor != null) {
            return context.getNode();
        }
        return null;
    }

    public static int getLineFromCodeEditor(Context context) {
        View view;
        if (context != null && (view = context.getView()) != null && view instanceof CodeEditorGutterView) {
            int line = CodeEditorGutter.getLineForContext((Context)context);
            if (line != -1) {
                return line;
            }
            return 0;
        }
        CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
        if (codeEditor != null) {
            return codeEditor.getCaretLine();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean showSourceNotFoundDialog(Workspace workspace, Project project, String pkg, String filename, String fullClassName, int line, boolean selectLine, String sourceNotFoundMessage, DebugVirtualMachine vm, String urlCacheKey) {
        if (Source.getShouldAsk(pkg, filename)) {
            String title = RunMgrArb.getString(10);
            ArrayList<Project> projectsSearched = new ArrayList<Project>();
            if (project != null) {
                projectsSearched.add(project);
            }
            boolean canGenerateStub = Source.canGenerateStub(workspace, project, fullClassName, filename);
            while (true) {
                SourceNotFoundPanel panel = new SourceNotFoundPanel(workspace, project, pkg, filename, fullClassName, sourceNotFoundMessage, projectsSearched, canGenerateStub);
                JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, (Component)panel.getFirstComponent(), (String)title);
                boolean dialogResult = false;
                HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_run_sourcenotfound_html");
                try {
                    panel.setJEWTDialog(dlg);
                    dlg.setOKButtonEnabled(panel.canOk());
                    if (findSourceProgressBar != null) {
                        findSourceProgressBar.setDoneStatus();
                    }
                    dialogResult = WizardLauncher.runDialog((JDialog)dlg);
                }
                finally {
                    panel.stopLocator();
                }
                if (!dialogResult) break;
                switch (panel.getChoice()) {
                    case 1: {
                        Project p = panel.getSelectedProject();
                        if (Source.lookInOtherProject(p, workspace, pkg, filename, line, selectLine)) {
                            return true;
                        }
                        projectsSearched.add(p);
                        break;
                    }
                    case 2: {
                        SourceFinder sf = panel.getSelectedSourceFinder();
                        if (!Source.lookInSourceFinder(sf, workspace, project, pkg, filename, line, selectLine)) break;
                        return true;
                    }
                    case 3: {
                        if (!Source.showURLChooser(workspace, project, pkg, filename, line, selectLine, vm, urlCacheKey)) break;
                        return true;
                    }
                    case 4: {
                        if (!Source.generateStub(workspace, project, fullClassName)) break;
                        return true;
                    }
                    case 5: {
                        Source.setShouldAsk(pkg, filename, false);
                        return false;
                    }
                    case 6: {
                        SourceNotFoundLocatorResult locatorResult = panel.getSelectedLocatorResult();
                        if (locatorResult == null) break;
                        if (Source.showUrl(locatorResult.url, workspace, locatorResult.project, line, selectLine, vm, urlCacheKey)) {
                            return true;
                        }
                        projectsSearched.add(locatorResult.project);
                        break;
                    }
                }
            }
            return false;
        }
        return false;
    }

    private static boolean getShouldAsk(String pkg, String filename) {
        String pkgFilename;
        return dontAsk == null || !dontAsk.contains(pkgFilename = pkg + "." + filename);
    }

    private static void setShouldAsk(String pkg, String filename, boolean shouldAsk) {
        if (dontAsk == null) {
            dontAsk = new ArrayList<String>();
        }
        String pkgFilename = pkg + "." + filename;
        if (shouldAsk) {
            dontAsk.remove(pkgFilename);
        } else {
            dontAsk.add(pkgFilename);
        }
    }

    private static boolean lookInOtherProject(Project otherProject, Workspace workspace, String pkg, String filename, int line, boolean selectLine) {
        try {
            Node node;
            URL url = Source.findSourceFile(workspace, otherProject, pkg, filename);
            if (url != null && (node = NodeFactory.findOrCreate((URL)url)) != null && Source.showSourceFile(workspace, otherProject, node, line, selectLine)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean lookInSourceFinder(SourceFinder sf, Workspace workspace, Project project, String pkg, String filename, int line, boolean selectLine) {
        try {
            Node node;
            URL url = sf.findSourceFile(workspace, project, pkg, filename);
            if (url != null && (node = NodeFactory.findOrCreate((URL)url)) != null && Source.showSourceFile(workspace, project, node, line, selectLine)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean showURLChooser(Workspace workspace, Project project, String pkg, String filename, int line, boolean selectLine, DebugVirtualMachine vm, String urlCacheKey) {
        URL url;
        String title = pkg.length() > 0 ? RunMgrArb.format(19, pkg, filename) : RunMgrArb.format(20, filename);
        Context context = Context.newIdeContext();
        if (workspace != null) {
            context.setWorkspace(workspace);
        }
        if (project != null) {
            context.setProject(project);
        }
        URLChooser chooser = DialogUtil.newURLChooser((Context)context);
        chooser.setSelectionMode(0);
        return chooser.showOpenDialog((Component)Ide.getMainWindow(), title) == 0 && Source.showUrl(url = chooser.getSelectedURL(), workspace, project, line, selectLine, vm, urlCacheKey);
    }

    private static boolean showUrl(URL url, Workspace workspace, Project project, int line, boolean selectLine, DebugVirtualMachine vm, String urlCacheKey) {
        if (url != null) {
            try {
                Node node = NodeFactory.findOrCreate((URL)url);
                if (node != null && Source.showSourceFile(workspace, project, node, line, selectLine)) {
                    if (vm != null && urlCacheKey.length() > 0) {
                        vm.cacheUserFoundURL(urlCacheKey, url);
                    }
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean canGenerateStub(Workspace workspace, Project project, String fullClassName, String filename) {
        URL urlStub;
        return project != null && fullClassName != null && filename != null && filename.toUpperCase().endsWith(".JAVA") && (urlStub = Source.findURLForClassStub(workspace, project, fullClassName)) != null;
    }

    private static boolean generateStub(Workspace workspace, Project project, String fullClassName) {
        URL urlStub;
        return project != null && fullClassName != null && (urlStub = Source.findURLForClassStub(workspace, project, fullClassName)) != null && Source.showSourceFile(workspace, project, urlStub, 0, false);
    }

    static {
        dontAsk = null;
    }

    private static final class SourceNotFoundPanel
    extends JPanel
    implements ItemListener {
        private JEWTDialog dlg;
        private JRadioButton radioLocator;
        private JList<SourceNotFoundLocatorResult> locatorResultListBox;
        private Set<URL> locatorResultURLs = new HashSet<URL>();
        private JScrollPane locatorScroller;
        private Boolean locatorDone = Boolean.FALSE;
        private JLabel locatorLabel;
        private LocatorThread locatorThread;
        private Object locatorThreadSemaphore = new Object();
        private List<Project> locatorProjects;
        private boolean locatorProjectsSorted;
        private Set<String> locatorProjectsSearched = new HashSet<String>();
        private int locatorProjectsIndex;
        private JRadioButton radioProject;
        private JComboBox<Project> comboboxProjects;
        private List<SourceFinderManager> sourceFinderManagers;
        private List<JRadioButton> radioSourceFinders;
        private List<JComboBox> comboboxSourceFinders;
        private JRadioButton radioURLChooser;
        private JRadioButton radioGenerateStub;
        private JRadioButton radioDontAskAgain;
        private Workspace workspace;
        private Project project;
        private String pkg;
        private String filename;
        private Map<Project, Project> otherProjects;
        private Set<String> previousProjectPicks = new HashSet<String>(10);

        SourceNotFoundPanel(Workspace workspace, Project project, String pkg, String filename, String fullClassName, String sourceNotFoundMessage, List<Project> projectsSearched, boolean canGenerateStub) {
            super(new GridBagLayout());
            int i;
            JComboBox combobox;
            JRadioButton radioButton;
            List<SourceFinderManager> registeredSourceFinderManagers;
            int size;
            this.workspace = workspace;
            this.project = project;
            this.pkg = pkg;
            this.filename = filename;
            this.retrievePreviousProjectPicks();
            JLabel specialLabel = null;
            if (sourceNotFoundMessage != null) {
                specialLabel = new JLabel(sourceNotFoundMessage);
            }
            String message = filename.length() > 0 ? (pkg.length() > 0 ? RunMgrArb.format(11, pkg, filename) : RunMgrArb.format(12, filename)) : RunMgrArb.format(13, fullClassName);
            JLabel label = new JLabel(message);
            int projectsSearchedSize = projectsSearched.size();
            JLabel[] labelLookedInProject = new JLabel[projectsSearchedSize];
            for (int i2 = 0; i2 < projectsSearchedSize; ++i2) {
                Project p = projectsSearched.get(i2);
                labelLookedInProject[i2] = new JLabel(RunMgrArb.format(14, p.getShortLabel()));
            }
            this.otherProjects = SourceNotFoundPanel.getOtherProjects(workspace, projectsSearched);
            if (this.otherProjects.size() > 0) {
                Project[] projectArray = this.otherProjects.keySet().toArray(new Project[this.otherProjects.size()]);
                Arrays.sort(projectArray, new ProjectComparator());
                this.radioProject = new JRadioButton();
                this.comboboxProjects = new JComboBox<Project>(projectArray);
            }
            if ((size = (registeredSourceFinderManagers = SourceHook.getSourceFinderManagers(workspace, project)).size()) > 0) {
                this.sourceFinderManagers = new ArrayList<SourceFinderManager>();
                this.radioSourceFinders = new ArrayList<JRadioButton>();
                this.comboboxSourceFinders = new ArrayList<JComboBox>();
                for (int i3 = 0; i3 < size; ++i3) {
                    SourceFinderManager sourceFinderManager = registeredSourceFinderManagers.get(i3);
                    String[] names = sourceFinderManager.getSourceFinderNames();
                    if (names == null || names.length <= 0) continue;
                    radioButton = new JRadioButton();
                    ResourceUtils.resButton((AbstractButton)radioButton, (String)sourceFinderManager.getRadioLabel());
                    combobox = new JComboBox(names);
                    this.sourceFinderManagers.add(sourceFinderManager);
                    this.radioSourceFinders.add(radioButton);
                    this.comboboxSourceFinders.add(combobox);
                }
                if (this.sourceFinderManagers.isEmpty()) {
                    this.sourceFinderManagers = null;
                    this.radioSourceFinders = null;
                    this.comboboxSourceFinders = null;
                }
            }
            this.radioURLChooser = new JRadioButton();
            if (canGenerateStub) {
                this.radioGenerateStub = new JRadioButton();
            }
            this.radioDontAskAgain = new JRadioButton();
            if (this.otherProjects.size() > 0) {
                this.radioLocator = new JRadioButton();
                this.locatorResultListBox = new JList(new DefaultListModel());
                this.locatorResultListBox.setVisibleRowCount(5);
                this.locatorResultListBox.setSelectionMode(0);
                this.locatorResultListBox.setLayoutOrientation(0);
                this.locatorResultListBox.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (e.getClickCount() == 2 && locatorResultListBox.getSelectedIndex() >= 0) {
                            radioLocator.setSelected(true);
                            dlg.closeDialog(false);
                        }
                    }
                });
                this.locatorScroller = new JScrollPane(this.locatorResultListBox);
                this.locatorScroller.setVerticalScrollBarPolicy(22);
                this.locatorScroller.setHorizontalScrollBarPolicy(32);
                this.locatorLabel = new JLabel();
                this.locatorLabel.setHorizontalTextPosition(10);
                this.locatorProjects = new ArrayList<Project>(this.otherProjects.size());
                this.locatorProjects.addAll(this.otherProjects.keySet());
            }
            ButtonGroup group = new ButtonGroup();
            if (this.radioLocator != null) {
                group.add(this.radioLocator);
            }
            if (this.radioProject != null) {
                group.add(this.radioProject);
            }
            if (this.radioSourceFinders != null) {
                for (int i4 = 0; i4 < this.radioSourceFinders.size(); ++i4) {
                    group.add(this.radioSourceFinders.get(i4));
                }
            }
            group.add(this.radioURLChooser);
            if (this.radioGenerateStub != null) {
                group.add(this.radioGenerateStub);
            }
            group.add(this.radioDontAskAgain);
            this.setResources();
            this.selectRadio(filename);
            int y = 0;
            if (specialLabel != null) {
                this.add((Component)specialLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 10, 5), 0, 0));
            }
            this.add((Component)label, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 10, 5), 0, 0));
            for (i = 0; i < labelLookedInProject.length; ++i) {
                this.add((Component)labelLookedInProject[i], new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            }
            if (this.radioLocator != null) {
                this.add((Component)this.radioLocator, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
                this.add((Component)this.locatorLabel, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
                this.add((Component)this.locatorScroller, new GridBagConstraints(0, y++, 0, 1, 1.0, 1.0, 17, 1, new Insets(10, 5, 0, 5), 0, 0));
            }
            if (this.radioProject != null) {
                this.add((Component)this.radioProject, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 4), 0, 0));
                this.add(this.comboboxProjects, new GridBagConstraints(1, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 4, 0, 0), 0, 0));
            }
            if (this.radioSourceFinders != null) {
                for (i = 0; i < this.radioSourceFinders.size(); ++i) {
                    radioButton = this.radioSourceFinders.get(i);
                    combobox = this.comboboxSourceFinders.get(i);
                    JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
                    panel.add(radioButton);
                    panel.add(combobox);
                    this.add((Component)panel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
                }
            }
            this.add((Component)this.radioURLChooser, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
            if (this.radioGenerateStub != null) {
                this.add((Component)this.radioGenerateStub, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
            }
            this.add((Component)this.radioDontAskAgain, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
            if (this.radioLocator == null) {
                this.add((Component)new JLabel(), new GridBagConstraints(0, y, 0, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
            this.addListeners();
        }

        private void retrievePreviousProjectPicks() {
            DTCache dtCache = Ide.getDTCache();
            String allPicks = dtCache.getString(Source.SOURCE_NOT_FOUND_PANEL_PICKS);
            if (allPicks != null) {
                String[] previousPicks;
                for (String previousPick : previousPicks = allPicks.split(";")) {
                    this.previousProjectPicks.add(previousPick);
                }
            }
        }

        private void storePreviousProjectPicks() {
            DTCache dtCache = Ide.getDTCache();
            StringBuilder buf = new StringBuilder();
            boolean addSemiColon = false;
            for (String previousPick : this.previousProjectPicks) {
                if (addSemiColon) {
                    buf.append(';');
                } else {
                    addSemiColon = true;
                }
                buf.append(previousPick);
            }
            dtCache.putString(Source.SOURCE_NOT_FOUND_PANEL_PICKS, buf.toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Collection<Project> getDependencies(Workspace workspace, Project project) {
            if (project == null) {
                return Collections.emptySet();
            }
            try (ProjectCache cache = ProjectCache.getInstance((Workspace)workspace);){
                Collection collection = cache.getDirectDependencies(project);
                return collection;
            }
        }

        private void setResources() {
            if (this.radioLocator != null) {
                ResourceUtils.resButton((AbstractButton)this.radioLocator, (String)RunMgrArb.getString(115));
            }
            if (this.radioProject != null) {
                ResourceUtils.resButton((AbstractButton)this.radioProject, (String)RunMgrArb.getString(15));
            }
            ResourceUtils.resButton((AbstractButton)this.radioURLChooser, (String)RunMgrArb.getString(16));
            if (this.radioGenerateStub != null) {
                ResourceUtils.resButton((AbstractButton)this.radioGenerateStub, (String)RunMgrArb.getString(17));
            }
            ResourceUtils.resButton((AbstractButton)this.radioDontAskAgain, (String)RunMgrArb.getString(18));
        }

        private void selectRadio(String filename) {
            if (this.radioSourceFinders != null && filename.toUpperCase().endsWith(".PLS")) {
                this.radioSourceFinders.get(0).setSelected(true);
            } else if (this.radioLocator != null) {
                this.radioLocator.setSelected(true);
            } else if (this.radioProject != null) {
                this.radioProject.setSelected(true);
            } else {
                this.radioURLChooser.setSelected(true);
            }
        }

        private void addListeners() {
            if (this.radioLocator != null) {
                this.radioLocator.addItemListener(this);
            }
            if (this.radioProject != null) {
                this.radioProject.addItemListener(this);
                this.comboboxProjects.addItemListener(this);
                this.comboboxProjects.setEnabled(this.radioProject.isSelected());
            }
            if (this.radioSourceFinders != null) {
                for (int i = 0; i < this.radioSourceFinders.size(); ++i) {
                    JRadioButton radioButton = this.radioSourceFinders.get(i);
                    radioButton.addItemListener(this);
                    JComboBox combobox = this.comboboxSourceFinders.get(i);
                    combobox.addItemListener(this);
                    combobox.setEnabled(radioButton.isSelected());
                }
            }
            if (this.radioGenerateStub != null) {
                this.radioGenerateStub.addItemListener(this);
            }
            this.radioURLChooser.addItemListener(this);
        }

        private static Map<Project, Project> getOtherProjects(Workspace workspace, List<Project> projectsSearched) {
            IdentityHashMap<Project, Project> otherProjects = new IdentityHashMap<Project, Project>();
            if (workspace != null) {
                IdentityHashMap<Project, Project> knownProjects = new IdentityHashMap<Project, Project>();
                for (Project project : projectsSearched) {
                    knownProjects.put(project, project);
                    Collection<Project> dependentProjects = SourceNotFoundPanel.getDependencies(workspace, project);
                    for (Project dependentProject : dependentProjects) {
                        knownProjects.put(dependentProject, dependentProject);
                    }
                }
                Iterator children = workspace.getChildren();
                while (children.hasNext()) {
                    Object o = children.next();
                    if (knownProjects.get(o) != null) continue;
                    otherProjects.put((Project)o, (Project)o);
                }
            }
            return otherProjects;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            if (source instanceof JRadioButton) {
                if (this.radioLocator != null) {
                    this.toggleLocator(this.radioLocator.isSelected());
                }
                if (this.radioProject != null) {
                    this.comboboxProjects.setEnabled(this.radioProject.isSelected());
                }
                if (this.radioSourceFinders != null) {
                    for (int i = 0; i < this.radioSourceFinders.size(); ++i) {
                        JRadioButton radioButton = this.radioSourceFinders.get(i);
                        JComboBox combobox = this.comboboxSourceFinders.get(i);
                        combobox.setEnabled(radioButton.isSelected());
                    }
                }
                this.dlg.setOKButtonEnabled(this.canOk());
            } else if (source instanceof JComboBox) {
                this.dlg.setOKButtonEnabled(this.canOk());
            }
        }

        private void setJEWTDialog(JEWTDialog dlg) {
            this.dlg = dlg;
            if (this.radioLocator != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.runLocator();
                    }
                });
            }
        }

        private boolean canOk() {
            if (this.radioLocator != null && this.radioLocator.isSelected()) {
                return this.locatorResultListBox.getSelectedIndex() >= 0;
            }
            if (this.radioProject != null && this.radioProject.isSelected() && this.getSelectedProject() == null) {
                return false;
            }
            if (this.radioSourceFinders != null) {
                for (int i = 0; i < this.radioSourceFinders.size(); ++i) {
                    JRadioButton radioButton = this.radioSourceFinders.get(i);
                    if (!radioButton.isSelected() || this.getSelectedSourceFinder() != null) continue;
                    return false;
                }
            }
            return true;
        }

        private Component getFirstComponent() {
            if (this.radioLocator != null) {
                return this.radioLocator;
            }
            if (this.radioProject != null) {
                return this.radioProject;
            }
            if (this.radioSourceFinders != null) {
                return this.radioSourceFinders.get(0);
            }
            return this.radioURLChooser;
        }

        private int getChoice() {
            if (this.radioLocator != null && this.radioLocator.isSelected()) {
                return 6;
            }
            if (this.radioProject != null && this.radioProject.isSelected()) {
                return 1;
            }
            if (this.radioSourceFinders != null) {
                for (int i = 0; i < this.radioSourceFinders.size(); ++i) {
                    JRadioButton radioButton = this.radioSourceFinders.get(i);
                    if (!radioButton.isSelected()) continue;
                    return 2;
                }
            }
            if (this.radioGenerateStub != null && this.radioGenerateStub.isSelected()) {
                return 4;
            }
            if (this.radioURLChooser.isSelected()) {
                return 3;
            }
            if (this.radioDontAskAgain.isSelected()) {
                return 5;
            }
            return 0;
        }

        Project getSelectedProject() {
            if (this.radioProject != null && this.radioProject.isSelected()) {
                Project project = (Project)this.comboboxProjects.getSelectedItem();
                if (project != null) {
                    this.previousProjectPicks.add(project.getShortLabel());
                    this.storePreviousProjectPicks();
                }
                return project;
            }
            return null;
        }

        SourceFinder getSelectedSourceFinder() {
            if (this.radioSourceFinders != null) {
                for (int i = 0; i < this.radioSourceFinders.size(); ++i) {
                    JRadioButton radioButton = this.radioSourceFinders.get(i);
                    if (!radioButton.isSelected()) continue;
                    SourceFinderManager sourceFinderManager = this.sourceFinderManagers.get(i);
                    JComboBox combobox = this.comboboxSourceFinders.get(i);
                    String name = (String)combobox.getSelectedItem();
                    return sourceFinderManager.getSourceFinder(name);
                }
            }
            return null;
        }

        SourceNotFoundLocatorResult getSelectedLocatorResult() {
            if (this.locatorResultListBox != null && this.locatorResultListBox.getSelectedIndex() >= 0) {
                SourceNotFoundLocatorResult result = this.locatorResultListBox.getSelectedValue();
                if (result != null) {
                    this.previousProjectPicks.add(result.project.getShortLabel());
                    this.storePreviousProjectPicks();
                }
                return result;
            }
            return null;
        }

        private void toggleLocator(boolean turnOn) {
            if (turnOn) {
                this.runLocator();
            } else {
                this.pauseLocator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runLocator() {
            Boolean bl = this.locatorDone;
            synchronized (bl) {
                if (!this.locatorDone.booleanValue() && this.locatorThread == null) {
                    this.locatorThread = new LocatorThread(this.locatorProjects);
                    this.locatorThread.start();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void pauseLocator() {
            this.pauseLocatorLabel();
            Boolean bl = this.locatorDone;
            synchronized (bl) {
                if (this.locatorThread != null) {
                    this.locatorThread.stopLocator = true;
                    this.locatorThread = null;
                }
            }
        }

        private void pauseLocatorLabel() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!locatorDone.booleanValue()) {
                        locatorLabel.setText(RunMgrArb.getString(116));
                        locatorLabel.setIcon(null);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void finishLocator() {
            Boolean bl = this.locatorDone;
            synchronized (bl) {
                this.locatorDone = Boolean.TRUE;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        locatorLabel.setText(RunMgrArb.getString(117));
                        locatorLabel.setIcon(null);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopLocator() {
            Boolean bl = this.locatorDone;
            synchronized (bl) {
                this.locatorDone = Boolean.TRUE;
            }
        }

        private class LocatorThread
        extends Thread {
            private List<Project> projects;
            private boolean stopLocator = false;

            private LocatorThread(List<Project> projects) {
                this.projects = projects;
                this.setName("SourceNotFoundLocator");
                logger.trace("Starting new locator thread");
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SourceNotFoundPanel.this.locatorLabel.setHorizontalTextPosition(2);
                        SourceNotFoundPanel.this.locatorLabel.setIconTextGap(8);
                        SourceNotFoundPanel.this.locatorLabel.setIcon(OracleIcons.getIcon((String)"throbber.gif"));
                        LocatorThread.this.setLocatorLabel();
                    }
                });
            }

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 10[WHILELOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            private void setLocatorLabel() {
                int len = SourceNotFoundPanel.this.locatorResultListBox.getModel().getSize();
                if (len == 0) {
                    SourceNotFoundPanel.this.locatorLabel.setText(null);
                } else if (len == 1) {
                    SourceNotFoundPanel.this.locatorLabel.setText(RunMgrArb.getString(118));
                } else {
                    SourceNotFoundPanel.this.locatorLabel.setText(RunMgrArb.format(119, len));
                }
            }

            private void sortLocatorProjects() {
                WorkingSets workingSets = WorkingSets.getInstance((Workspace)SourceNotFoundPanel.this.workspace);
                final WorkingSet workingSet = workingSets.getCurrentWorkingSet();
                Comparator<Project> c = new Comparator<Project>(){

                    @Override
                    public int compare(Project p1, Project p2) {
                        int i2;
                        int i1 = SourceNotFoundPanel.this.previousProjectPicks.contains(p1.getShortLabel()) ? 4 : 0;
                        int n = i2 = SourceNotFoundPanel.this.previousProjectPicks.contains(p2.getShortLabel()) ? 4 : 0;
                        if (workingSet != null) {
                            if (workingSet.isIncluded(p1)) {
                                i1 += 2;
                            }
                            if (workingSet.isIncluded(p2)) {
                                i2 += 2;
                            }
                        }
                        if (p1.isOpen()) {
                            ++i1;
                        }
                        if (p2.isOpen()) {
                            ++i2;
                        }
                        return i2 - i1;
                    }
                };
                Collections.sort(this.projects, c);
                SourceNotFoundPanel.this.locatorProjectsSorted = true;
            }
        }
    }

    private static class SourceNotFoundLocatorResult {
        Project project;
        URL url;

        private SourceNotFoundLocatorResult() {
        }

        public String toString() {
            return this.url.getPath();
        }
    }

    private static class ProjectComparator
    implements Comparator<Project> {
        private final Collator COLLATOR = Collator.getInstance();

        private ProjectComparator() {
        }

        @Override
        public int compare(Project project1, Project project2) {
            return this.COLLATOR.compare(project1.getShortLabel(), project2.getShortLabel());
        }
    }
}

