/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideri.navigator.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.AddContentCommand;
import oracle.ide.controller.IdeAction;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.ContentSetProviderReference;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.net.URLFactory;
import oracle.ide.util.Assert;
import oracle.ide.util.dnd.DefaultDropTargetListener;
import oracle.ide.util.dnd.DropHelper;
import oracle.ide.util.dnd.TransferableTreeNode;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.ModelUtil;

public class ProjectNodeDropHelper
implements DropHelper {
    public static final Class DROP_NODE_TYPE = Project.class;

    public float getWeight() {
        return 10.0f;
    }

    public boolean canTransferData(Object dropTarget, DataFlavor[] transferFlavors, int action) {
        TNode tnode;
        TNode project;
        if ((action & 3) > 0 && dropTarget instanceof TNode && (project = (tnode = (TNode)dropTarget).getAncestorTNode(Project.class, true)) != null) {
            for (int i = 0; i < transferFlavors.length; ++i) {
                if (transferFlavors[i].equals(DefaultDropTargetListener.JAVA_FILELIST_FLAVOR)) {
                    return true;
                }
                if (!transferFlavors[i].equals(TransferableTreeNode.TREE_NODE_FLAVOR)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean transferData(Object dropTarget, Transferable[] transferablesForSelection, int action) {
        if (!(dropTarget instanceof TNode)) {
            return false;
        }
        try {
            if (transferablesForSelection.length == 1) {
                DefaultMutableTreeNode node;
                Transferable transferable = transferablesForSelection[0];
                if (transferable.isDataFlavorSupported(DefaultDropTargetListener.JAVA_FILELIST_FLAVOR)) {
                    List list = (List)transferable.getTransferData(DefaultDropTargetListener.JAVA_FILELIST_FLAVOR);
                    if (list.size() == 1) {
                        this.transferExternalFileList(dropTarget, list);
                        return true;
                    }
                } else if (transferable.isDataFlavorSupported(TransferableTreeNode.TREE_NODE_FLAVOR) && (node = (DefaultMutableTreeNode)transferable.getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR)) instanceof TNode) {
                    return this.transferTNode(dropTarget, (TNode)node, action);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean transferTNode(Object dropTargetTNode, TNode dragSourceTNode, int action) throws Exception {
        URL[] urls;
        TNode parentProjectNode = dragSourceTNode.getAncestorTNode(Project.class, false);
        if (ModelUtil.areEqual((Object)dropTargetTNode, (Object)parentProjectNode)) {
            return false;
        }
        if (dragSourceTNode == parentProjectNode) {
            return false;
        }
        Element element = dragSourceTNode.getData();
        if (element instanceof Locatable) {
            URL url = ((Locatable)element).getURL();
            urls = new URL[]{url};
        } else if (element instanceof RelativeDirectoryContextFolder) {
            ArrayList children = new ArrayList();
            this.addChildren((RelativeDirectoryContextFolder)element, children);
            urls = new URL[children.size()];
            children.toArray(urls);
        } else {
            urls = new URL[]{};
        }
        boolean dropped = false;
        if (urls.length > 0) {
            ArrayList<Node> added = new ArrayList<Node>(urls.length);
            Element sourceElement = dragSourceTNode.getAncestor(Project.class);
            if (sourceElement != null) {
                Project sourceProject = (Project)sourceElement;
                ProjectContent pc = ProjectContent.getInstance((PropertyStorage)sourceProject);
                ContentSetProviderReference[] refs = ProjectContent.getContentSetProviderReferences();
                TNode targetProjectNode = (TNode)dropTargetTNode;
                Project targetProject = (Project)targetProjectNode.getData();
                for (int i = 0; i < urls.length; ++i) {
                    Node node = null;
                    try {
                        for (int x = 0; x < refs.length; ++x) {
                            String key = refs[x].key();
                            if (!pc.getContentSet(key).canHaveMember(urls[i])) continue;
                            if (node == null) {
                                node = NodeFactory.findOrCreate((URL)urls[i]);
                                added.add(node);
                            }
                            targetProject.add(node, key);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        Assert.printStackTrace((Throwable)e);
                        continue;
                    }
                }
                int numAdded = added.size();
                if (numAdded > 0) {
                    Element[] selection = new Element[numAdded];
                    added.toArray(selection);
                    if (action == 2) {
                        Context remContext = new Context(Ide.getActiveWorkspace(), sourceProject);
                        remContext.setSelection(selection);
                        IdeAction removeAction = IdeAction.find((int)21);
                        removeAction.performAction(remContext);
                    }
                    TreeExplorer explorer = targetProjectNode.getOwner();
                    TNode explorerNode = explorer.findTNode(selection[0], targetProjectNode);
                    explorer.setSelected(explorerNode);
                    dropped = true;
                }
            }
        }
        return dropped;
    }

    private void addChildren(RelativeDirectoryContextFolder folder, List urls) {
        Iterator iterator = folder.getChildren();
        while (iterator.hasNext()) {
            URL url;
            Element element = (Element)iterator.next();
            if (element instanceof RelativeDirectoryContextFolder) {
                this.addChildren((RelativeDirectoryContextFolder)element, urls);
                continue;
            }
            if (!(element instanceof Locatable) || urls.contains(url = ((Locatable)element).getURL())) continue;
            urls.add(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferExternalFileList(Object dropTargetTNode, List list) throws Exception {
        Iterator iterator = list.iterator();
        ArrayList<Node> nodes = new ArrayList<Node>();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            URL fileURL = URLFactory.newFileURL((File)file);
            try {
                nodes.add(NodeFactory.findOrCreate((URL)fileURL));
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
        if (nodes.size() == 1) {
            TNode projectNode = (TNode)dropTargetTNode;
            Project project = (Project)projectNode.getData();
            Context context = new Context(Ide.getActiveWorkspace(), project);
            context.setNode((Node)nodes.get(0));
            AddContentCommand cmd = new AddContentCommand();
            cmd.setContext(context);
            if (cmd.doit(true) == 0) {
                TreeExplorer explorer = projectNode.getOwner();
                TNode tnode = explorer.findTNode((Element)nodes.get(0), projectNode);
                explorer.setSelected(tnode);
            }
        }
    }
}

