/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.geometry;

import java.util.ArrayList;
import oracle.spatial.geometry.Buffer;
import oracle.spatial.geometry.JPoint2DD;

public final class Chain {
    private Chain otherEnd;
    private ArrayList<JPoint2DD> axy = new ArrayList();
    private ArrayList<Chain> metaData = null;

    private Chain() {
    }

    static Chain[] create() {
        Chain[] chainArray = new Chain[]{new Chain(), new Chain()};
        chainArray[0].otherEnd = chainArray[1];
        chainArray[1].otherEnd = chainArray[0];
        return chainArray;
    }

    boolean sameChain(Chain chain) {
        if (this.otherEnd == chain) {
            return true;
        }
        return this == chain;
    }

    Chain otherEnd() {
        return this.otherEnd;
    }

    void reverse() {
        ArrayList<JPoint2DD> arrayList = this.axy;
        this.axy = this.otherEnd.axy;
        this.otherEnd.axy = arrayList;
    }

    int size() {
        return this.axy.size() + this.otherEnd.axy.size();
    }

    void add(JPoint2DD jPoint2DD) {
        this.axy.add(jPoint2DD);
    }

    void addDistinct(JPoint2DD jPoint2DD) {
        if (this.size() == 0 || !jPoint2DD.equals(this.get(0))) {
            this.axy.add(jPoint2DD);
        }
    }

    void addDistinctArc(JPoint2DD jPoint2DD, JPoint2DD jPoint2DD2, double d, boolean bl) {
        JPoint2DD jPoint2DD3 = this.get(0);
        if (jPoint2DD.equals(jPoint2DD3)) {
            return;
        }
        this.axy.add(new CenterPoint(jPoint2DD2, d, bl));
        this.axy.add(jPoint2DD);
    }

    JPoint2DD get(int n) {
        int n2 = this.axy.size();
        if (n < n2) {
            return this.axy.get(n2 - 1 - n);
        }
        return this.otherEnd.axy.get(n - n2);
    }

    void set(int n, JPoint2DD jPoint2DD) {
        int n2 = this.axy.size();
        if (n < n2) {
            this.axy.set(n2 - 1 - n, jPoint2DD);
        } else {
            this.otherEnd.axy.set(n - n2, jPoint2DD);
        }
    }

    void remove(int n) {
        int n2;
        if (n != 0) {
            throw new IllegalArgumentException();
        }
        int n3 = this.axy.size();
        if (n3 > 0) {
            this.axy.remove(n3 - 1);
            return;
        }
        int n4 = this.otherEnd.axy.size();
        n3 = (n4 + 1) / 2;
        this.axy.ensureCapacity(n3);
        for (n2 = 0; n2 < n3 - 1; ++n2) {
            this.axy.add(this.otherEnd.axy.get(n3 - 1 - n2));
        }
        n2 = 0;
        while (n2 + n3 < n4) {
            this.otherEnd.axy.set(n2, this.otherEnd.axy.get(n3 + n2));
            ++n2;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            this.otherEnd.axy.remove(n4 - 1 - n2);
        }
    }

    void merge(Chain chain) {
        this.merge(chain, false);
    }

    Chain merge(Chain chain, boolean bl) {
        Chain chain2;
        Chain chain3 = this;
        Chain chain4 = chain;
        if (chain.size() < this.size()) {
            chain3 = chain;
            chain4 = this;
        }
        chain3.otherEnd.metaData = chain3.getMetaData();
        chain3.metaData = null;
        chain4.otherEnd.metaData = chain4.getMetaData();
        chain4.metaData = null;
        int n = 0;
        if (bl && this.size() > 0 && chain.size() > 0 && this.get(0).equals(chain.get(0))) {
            n = 1;
        }
        chain4.axy.ensureCapacity(chain4.axy.size() + chain3.size() - n);
        for (int i = n; i < chain3.size(); ++i) {
            chain4.add(chain3.get(i));
        }
        chain3.otherEnd.axy = chain4.axy;
        Chain chain5 = this.otherEnd;
        chain5.otherEnd = chain2 = chain.otherEnd;
        chain2.otherEnd = chain5;
        this.otherEnd = null;
        this.axy = null;
        chain.otherEnd = null;
        chain.axy = null;
        return chain5;
    }

    ArrayList<Chain> getMetaData() {
        this.metaData = Chain.merge(this.metaData, this.otherEnd.metaData);
        this.otherEnd.metaData = null;
        return this.metaData;
    }

    void addMetaData(Chain chain) {
        Chain chain2 = this.otherEnd;
        if (chain2.metaData == null) {
            chain2 = this;
            if (chain2.metaData == null) {
                chain2.metaData = new ArrayList();
            }
        }
        chain2.metaData.add(chain);
    }

    void addMetaData(ArrayList<Chain> arrayList) {
        this.metaData = Chain.merge(this.metaData, arrayList);
    }

    void clearMetaData() {
        this.metaData = null;
        this.otherEnd.metaData = null;
    }

    double signedArea() {
        int n = this.size();
        if (n < 3) {
            return 0.0;
        }
        if (!this.get(0).equals(this.get(n - 1))) {
            throw new IllegalArgumentException();
        }
        if (this.get(0) instanceof CenterPoint) {
            throw new IllegalArgumentException();
        }
        if (this.get(n - 1) instanceof CenterPoint) {
            throw new IllegalArgumentException();
        }
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += this.get((int)i).y;
        }
        double d2 = d / (double)n;
        AccurateSum accurateSum = new AccurateSum();
        JPoint2DD jPoint2DD = this.get(0);
        if (jPoint2DD instanceof CenterPoint) {
            throw new IllegalArgumentException();
        }
        for (int i = 1; i < n; ++i) {
            double d3;
            JPoint2DD jPoint2DD2 = this.get(i);
            CenterPoint centerPoint = null;
            if (jPoint2DD2 instanceof CenterPoint) {
                centerPoint = (CenterPoint)jPoint2DD2;
                jPoint2DD2 = this.get(++i);
            }
            if (jPoint2DD2 instanceof CenterPoint) {
                throw new IllegalArgumentException();
            }
            if (centerPoint == null) {
                d3 = (jPoint2DD.y - d2 + jPoint2DD2.y - d2) * (jPoint2DD2.x - jPoint2DD.x) / 2.0;
                accurateSum.add(d3);
            } else {
                double d4;
                double d5;
                d3 = 2.0 * Math.abs(Math.atan2(jPoint2DD.y - centerPoint.y, Math.abs(centerPoint.x - jPoint2DD.x)));
                if (Double.isNaN(d3)) {
                    d3 = Math.PI;
                }
                if (Double.isNaN(d5 = 2.0 * Math.abs(Math.atan2(jPoint2DD2.y - centerPoint.y, Math.abs(centerPoint.x - jPoint2DD2.x))))) {
                    d5 = Math.PI;
                }
                if (jPoint2DD2.x > jPoint2DD.x && jPoint2DD.x > centerPoint.x) {
                    d3 = Math.PI * 2 - d3;
                }
                if (jPoint2DD2.x < jPoint2DD.x && jPoint2DD.x < centerPoint.x) {
                    d3 = Math.PI * 2 - d3;
                }
                if (jPoint2DD2.x > jPoint2DD.x && jPoint2DD2.x < centerPoint.x) {
                    d5 = Math.PI * 2 - d5;
                }
                if (jPoint2DD2.x < jPoint2DD.x && jPoint2DD2.x > centerPoint.x) {
                    d5 = Math.PI * 2 - d5;
                }
                double d6 = centerPoint.radius * centerPoint.radius * (d3 - Math.sin(d3)) / 2.0;
                double d7 = centerPoint.radius * centerPoint.radius * (d5 - Math.sin(d5)) / 2.0;
                if (centerPoint.CUW) {
                    if (jPoint2DD.y > centerPoint.y || jPoint2DD2.y > centerPoint.y) {
                        throw new IllegalArgumentException();
                    }
                    d4 = Math.abs(jPoint2DD2.x - jPoint2DD.x) * (centerPoint.y - d2) - Math.PI * centerPoint.radius * centerPoint.radius / 2.0 + d6 / 2.0 + d7 / 2.0;
                } else {
                    if (jPoint2DD.y < centerPoint.y || jPoint2DD2.y < centerPoint.y) {
                        throw new IllegalArgumentException();
                    }
                    d4 = Math.abs(jPoint2DD2.x - jPoint2DD.x) * (centerPoint.y - d2) + Math.PI * centerPoint.radius * centerPoint.radius / 2.0 - d6 / 2.0 - d7 / 2.0;
                }
                if (jPoint2DD.x < jPoint2DD2.x) {
                    accurateSum.add(d4);
                } else if (jPoint2DD.x > jPoint2DD2.x) {
                    accurateSum.add(-d4);
                }
            }
            jPoint2DD = jPoint2DD2;
        }
        return accurateSum.get();
    }

    static ArrayList<Chain> merge(ArrayList<Chain> arrayList, ArrayList<Chain> arrayList2) {
        if (arrayList == null) {
            return arrayList2;
        }
        if (arrayList2 == null) {
            return arrayList;
        }
        ArrayList<Chain> arrayList3 = arrayList;
        ArrayList<Chain> arrayList4 = arrayList2;
        if (arrayList2.size() < arrayList.size()) {
            arrayList3 = arrayList2;
            arrayList4 = arrayList;
        }
        arrayList4.ensureCapacity(arrayList4.size() + arrayList3.size());
        for (int i = 0; i < arrayList3.size(); ++i) {
            arrayList4.add(arrayList3.get(i));
        }
        arrayList3.clear();
        return arrayList4;
    }

    public String WKT() {
        return "LINESTRING" + this.WKTList();
    }

    public String WKTList() {
        StringBuffer stringBuffer = new StringBuffer("(");
        String string = "";
        JPoint2DD jPoint2DD = null;
        for (int i = 0; i < this.size(); ++i) {
            JPoint2DD jPoint2DD2 = this.get(i);
            CenterPoint centerPoint = null;
            if (jPoint2DD2 instanceof CenterPoint) {
                centerPoint = (CenterPoint)jPoint2DD2;
                jPoint2DD2 = this.get(++i);
                stringBuffer.append(Buffer.debugArcExpansion(jPoint2DD, jPoint2DD2, centerPoint, centerPoint.radius, centerPoint.CUW));
            } else {
                stringBuffer.append(string + this.get((int)i).x + " " + this.get((int)i).y);
            }
            string = ", ";
            jPoint2DD = jPoint2DD2;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String toString() {
        if (this.size() == 0) {
            return "*(0)*";
        }
        return this.get(0) + " (" + this.size() + ") " + this.get(this.size() - 1);
    }

    public static final class AccurateSum {
        private double sum;
        private double surplus;

        public void reset() {
            this.sum = 0.0;
            this.surplus = 0.0;
        }

        public AccurateSum() {
            this.reset();
        }

        public void add(double d) {
            double d2 = d - this.surplus;
            double d3 = this.sum + d2;
            this.surplus = d3 - this.sum - d2;
            this.sum = d3;
        }

        public double get() {
            return this.sum;
        }
    }

    public static class CenterPoint
    extends JPoint2DD {
        private static final long serialVersionUID = 1996381016013365072L;
        double radius;
        boolean CUW;

        CenterPoint() {
            this.radius = 0.0;
            this.CUW = false;
        }

        CenterPoint(JPoint2DD jPoint2DD, double d, boolean bl) {
            super(jPoint2DD);
            this.radius = d;
            this.CUW = bl;
        }

        CenterPoint(CenterPoint centerPoint) {
            super(centerPoint);
            this.radius = centerPoint.radius;
            this.CUW = centerPoint.CUW;
        }

        final boolean validateYside(double d) {
            if (d == this.y) {
                return true;
            }
            return d > this.y ^ this.CUW;
        }

        @Override
        public String toString() {
            return super.toString() + " :" + this.radius + (this.CUW ? "CUW" : "CDN");
        }
    }
}

