/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.geometry;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import oracle.spatial.geometry.BufGeom;
import oracle.spatial.geometry.Chain;
import oracle.spatial.geometry.JPoint2DD;
import oracle.spatial.geometry.PSSegment;
import oracle.spatial.geometry.SkipList;
import oracle.spatial.geometry.SkipListData;
import oracle.spatial.geometry.SpatialSort;
import oracle.spatial.util.Logger;

class Buffer {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_PLOTEVENTS = false;
    private static final boolean DEBUG_DUMPSLICE = false;
    private static final boolean DEBUG_DUMPEVENTQUEUE = false;
    private static final boolean DEBUG_REVALIDATE_LINES = false;
    private static final boolean DEBUG_EVENTS = false;
    private static final boolean DEBUG_TIMING = false;
    private static final boolean DEBUG_CHECK_MER = false;
    private static final boolean DEBUG_WARNFATAL = false;
    private static final boolean DEBUG_DUMPSAUSAGIZEINPUT = false;
    private static final boolean DEBUG_DUMPSPATIALORDERING = false;
    private static final boolean DEBUG_OUTPUT = false;
    private static final boolean DEBUG_HOLEFORMATION = false;
    private static final boolean DEBUG_GROUPING = false;
    private static final boolean DEBUG_SEG_BY_SEG_PROCESSING = false;
    private static final boolean DEBUG_NUMERICERRORS = false;
    private static final boolean DEBUG_RINGSWAP = false;
    private static final boolean DEBUG_UNCOMMON = false;
    private static final double DEBUG_FUZZY_LEFTSWAP = 1.0E-8;
    private static final String GEOMLOG_FILE = "Buffer-geom.log";
    private int eventCount = 0;
    private static Logger logger;
    private static Logger geomLog;
    boolean logFinest;
    boolean logDebug;
    final double width;
    static final double MACHINE_TOL_FRACTION = 1.0E-12;
    double machineTol;
    double machineTol2;
    private static final double ACCEPTABLE_CIRCLE_ERROR2 = 0.1;
    private static final double SEGS_PER_CIRCLE = 24.0;
    private SkipList slice = new SkipList();
    private BufGeom result;
    private int ringId = 0;
    private PriorityQueue<Event> events = new PriorityQueue();
    private int pairCount = 0;
    SpatialSort sorter = new SpatialSort();
    private static final int MAXWORK = 250;
    private static double maxMERdiff;

    static final boolean DEBUG_DUMPRANGE(int n) {
        return true;
    }

    Buffer(double d) {
        this.width = d;
        if (d <= 0.0) {
            throw new IllegalArgumentException();
        }
        geomLog = logger = Logger.getLogger((String)"oracle.spatial.geometry.Buffer");
        this.logFinest = logger.getLevel() <= 0;
        this.logDebug = logger.getLevel() <= 3;
    }

    void sausagize(final JPoint2DD jPoint2DD) {
        ++this.ringId;
        double d = 0.0;
        if (jPoint2DD instanceof Chain.CenterPoint) {
            d = ((Chain.CenterPoint)jPoint2DD).radius;
        }
        final double d2 = this.width + d;
        final JPoint2DD jPoint2DD2 = new JPoint2DD(jPoint2DD.x - d2, jPoint2DD.y);
        final JPoint2DD jPoint2DD3 = new JPoint2DD(jPoint2DD.x + d2, jPoint2DD.y);
        PSSegment pSSegment = new PSSegment(this.ringId, 1, new PSSegment.MonotoneUpdater(){
            boolean done = false;

            @Override
            public boolean nextSegment(PSSegment pSSegment) {
                if (this.done) {
                    return false;
                }
                this.done = true;
                pSSegment.setArcValues(jPoint2DD2, jPoint2DD3, jPoint2DD, d2, false);
                return true;
            }
        });
        PSSegment pSSegment2 = new PSSegment(this.ringId, -1, new PSSegment.MonotoneUpdater(){
            boolean done = false;

            @Override
            public boolean nextSegment(PSSegment pSSegment) {
                if (this.done) {
                    return false;
                }
                this.done = true;
                pSSegment.setArcValues(jPoint2DD2, jPoint2DD3, jPoint2DD, d2, true);
                return true;
            }
        });
        this.events.add(new Event(jPoint2DD2, EventType.START, pSSegment, pSSegment2, null));
        this.events.add(new Event(jPoint2DD3, EventType.END, pSSegment, pSSegment2, null));
    }

    void sausagize(JPoint2DD jPoint2DD, JPoint2DD jPoint2DD2) {
        JPoint2DD jPoint2DD3;
        ++this.ringId;
        if (jPoint2DD.equals(jPoint2DD2)) {
            this.sausagize(jPoint2DD);
            return;
        }
        if (PSSegment.compare(jPoint2DD2, jPoint2DD) < 0) {
            jPoint2DD3 = jPoint2DD;
            jPoint2DD = jPoint2DD2;
            jPoint2DD2 = jPoint2DD3;
        }
        jPoint2DD3 = jPoint2DD;
        final JPoint2DD jPoint2DD4 = jPoint2DD2;
        double d = jPoint2DD4.x - jPoint2DD3.x;
        double d2 = jPoint2DD4.y - jPoint2DD3.y;
        double d3 = Math.hypot(d, d2);
        double d4 = (jPoint2DD4.y - jPoint2DD3.y) / d3 * this.width;
        double d5 = (jPoint2DD4.x - jPoint2DD3.x) / d3 * this.width;
        double d6 = this.magnitude(jPoint2DD3, jPoint2DD4);
        double d7 = Math.nextAfter(this.width + d6, Double.NEGATIVE_INFINITY) - d6;
        d7 = Math.max(d7, 0.0);
        if (d4 == 0.0) {
            d5 = this.width;
        } else if (d5 == 0.0) {
            d4 = Math.copySign(this.width, d4);
        } else if (d5 >= d7) {
            d5 = d7;
        } else if (Math.abs(d4) >= d7) {
            d4 = Math.copySign(d7, d4);
        }
        double d8 = -d4;
        double d9 = d5;
        final JPoint2DD jPoint2DD5 = new JPoint2DD(jPoint2DD3.x - this.width, jPoint2DD3.y);
        final JPoint2DD jPoint2DD6 = new JPoint2DD(jPoint2DD3.x + d8, jPoint2DD3.y + d9);
        final JPoint2DD jPoint2DD7 = new JPoint2DD(jPoint2DD3.x - d8, jPoint2DD3.y - d9);
        final JPoint2DD jPoint2DD8 = new JPoint2DD(jPoint2DD4.x + this.width, jPoint2DD4.y);
        final JPoint2DD jPoint2DD9 = new JPoint2DD(jPoint2DD4.x + d8, jPoint2DD4.y + d9);
        final JPoint2DD jPoint2DD10 = new JPoint2DD(jPoint2DD4.x - d8, jPoint2DD4.y - d9);
        PSSegment pSSegment = new PSSegment(this.ringId, 1, new PSSegment.MonotoneUpdater(){
            int used = 0;

            @Override
            public boolean nextSegment(PSSegment pSSegment) {
                if (jPoint2DD3.x == jPoint2DD4.x && jPoint2DD4.y > jPoint2DD3.y && this.used == 0) {
                    ++this.used;
                }
                if (jPoint2DD3.x == jPoint2DD4.x && jPoint2DD4.y < jPoint2DD3.y && this.used == 2) {
                    ++this.used;
                }
                switch (++this.used) {
                    case 1: {
                        pSSegment.setArcValues(jPoint2DD5, jPoint2DD6, jPoint2DD3, Buffer.this.width, false);
                        break;
                    }
                    case 2: {
                        pSSegment.setLinearValues(jPoint2DD6, jPoint2DD9);
                        break;
                    }
                    case 3: {
                        pSSegment.setArcValues(jPoint2DD9, jPoint2DD8, jPoint2DD4, Buffer.this.width, false);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
        });
        PSSegment pSSegment2 = new PSSegment(this.ringId, -1, new PSSegment.MonotoneUpdater(){
            int used = 0;

            @Override
            public boolean nextSegment(PSSegment pSSegment) {
                if (jPoint2DD3.x == jPoint2DD4.x && jPoint2DD4.y < jPoint2DD3.y && this.used == 0) {
                    ++this.used;
                }
                if (jPoint2DD3.x == jPoint2DD4.x && jPoint2DD4.y > jPoint2DD3.y && this.used == 2) {
                    ++this.used;
                }
                switch (++this.used) {
                    case 1: {
                        pSSegment.setArcValues(jPoint2DD5, jPoint2DD7, jPoint2DD3, Buffer.this.width, true);
                        break;
                    }
                    case 2: {
                        pSSegment.setLinearValues(jPoint2DD7, jPoint2DD10);
                        break;
                    }
                    case 3: {
                        pSSegment.setArcValues(jPoint2DD10, jPoint2DD8, jPoint2DD4, Buffer.this.width, true);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
        });
        this.events.add(new Event(jPoint2DD5, EventType.START, pSSegment, pSSegment2, null));
        this.events.add(new Event(jPoint2DD8, EventType.END, pSSegment, pSSegment2, null));
    }

    void sausagize(JPoint2DD jPoint2DD, Chain.CenterPoint centerPoint, JPoint2DD jPoint2DD2) {
        JPoint2DD jPoint2DD3;
        JPoint2DD jPoint2DD4;
        double d;
        double d2;
        ++this.ringId;
        if (jPoint2DD.equals(jPoint2DD2)) {
            this.sausagize(jPoint2DD2);
            return;
        }
        if (PSSegment.compare(jPoint2DD2, jPoint2DD) < 0) {
            JPoint2DD jPoint2DD5 = jPoint2DD;
            jPoint2DD = jPoint2DD2;
            jPoint2DD2 = jPoint2DD5;
        }
        double d3 = Math.hypot(jPoint2DD.x - centerPoint.x, jPoint2DD.y - centerPoint.y);
        double d4 = (jPoint2DD.y - centerPoint.y) / d3 * this.width;
        double d5 = (jPoint2DD.x - centerPoint.x) / d3 * this.width;
        d3 = Math.hypot(jPoint2DD2.x - centerPoint.x, jPoint2DD2.y - centerPoint.y);
        double d6 = (jPoint2DD2.y - centerPoint.y) / d3 * this.width;
        double d7 = (jPoint2DD2.x - centerPoint.x) / d3 * this.width;
        if (d4 < 0.0 || d4 == 0.0 && Math.signum(d5) == Math.signum(jPoint2DD2.y - jPoint2DD.y)) {
            d2 = d4;
            double d8 = -d5;
            d = -d6;
            double d9 = d7;
        } else {
            d2 = -d4;
            double d10 = d5;
            d = d6;
            double d11 = -d7;
        }
        JPoint2DD jPoint2DD6 = new JPoint2DD(jPoint2DD.x + d5, jPoint2DD.y + d4);
        JPoint2DD jPoint2DD7 = new JPoint2DD(jPoint2DD2.x + d7, jPoint2DD2.y + d6);
        if (this.width < centerPoint.radius && jPoint2DD.x - d5 < jPoint2DD2.x - d7) {
            jPoint2DD4 = new JPoint2DD(jPoint2DD.x - d5, jPoint2DD.y - d4);
            jPoint2DD3 = new JPoint2DD(jPoint2DD2.x - d7, jPoint2DD2.y - d6);
        } else {
            double d12;
            double d13;
            double d14 = jPoint2DD2.x - jPoint2DD.x;
            double d15 = jPoint2DD2.y - jPoint2DD.y;
            d3 = Math.sqrt(d14 * d14 + d15 * d15);
            d14 /= d3;
            d15 /= d3;
            double d16 = (jPoint2DD.x + jPoint2DD2.x) / 2.0;
            double d17 = (jPoint2DD.y + jPoint2DD2.y) / 2.0;
            double d18 = d3 / 2.0;
            double d19 = d18 >= this.width ? 0.0 : Math.sqrt(this.width * this.width - d18 * d18);
            if (centerPoint.CUW) {
                d13 = -d15;
                d12 = d14;
            } else {
                d13 = d15;
                d12 = -d14;
            }
            jPoint2DD3 = jPoint2DD4 = new JPoint2DD(d16 + d19 * d13, d17 + d19 * d12);
        }
        Chain chain = Chain.create()[0];
        chain.add(jPoint2DD4);
        if (jPoint2DD4 != jPoint2DD3 && centerPoint.radius > this.width) {
            this.addSaneArcUnordered(chain, jPoint2DD3, centerPoint, centerPoint.radius - this.width, centerPoint.CUW);
        }
        double d20 = Math.signum(d);
        this.splitAndAddArc(chain, jPoint2DD2, this.width, !centerPoint.CUW, d20, jPoint2DD7);
        this.addSaneArcUnordered(chain, jPoint2DD6, centerPoint, centerPoint.radius + this.width, centerPoint.CUW);
        double d21 = Math.signum(d2);
        this.splitAndAddArc(chain, jPoint2DD, this.width, !centerPoint.CUW, d21, jPoint2DD4);
        this.mergeRing(chain, true);
    }

    private void splitAndAddArc(Chain chain, JPoint2DD jPoint2DD, double d, boolean bl, double d2, JPoint2DD jPoint2DD2) {
        JPoint2DD jPoint2DD3 = chain.get(0);
        if (jPoint2DD3.y < jPoint2DD.y && jPoint2DD2.y > jPoint2DD.y || jPoint2DD3.y > jPoint2DD.y && jPoint2DD2.y < jPoint2DD.y) {
            bl = jPoint2DD3.y < jPoint2DD.y || jPoint2DD2.y > jPoint2DD.y;
            double d3 = Math.copySign(d, d2);
            JPoint2DD jPoint2DD4 = new JPoint2DD(jPoint2DD.x + d3, jPoint2DD.y);
            this.addSaneArcUnordered(chain, jPoint2DD4, jPoint2DD, d, bl);
            bl = !bl;
            jPoint2DD3 = jPoint2DD4;
        }
        this.addSaneArcUnordered(chain, jPoint2DD2, jPoint2DD, d, bl);
    }

    void sausagizeLinear(Chain chain, boolean bl) {
        int n;
        JPoint2DD jPoint2DD;
        int n2 = chain.size();
        if (n2 == 1) {
            this.sausagize(chain.get(0));
            return;
        }
        if (bl && !chain.get(0).equals(chain.get(n2 - 1))) {
            jPoint2DD = chain.get(n2 - 1);
            n = 0;
        } else {
            jPoint2DD = chain.get(0);
            n = 1;
        }
        while (n < n2) {
            JPoint2DD jPoint2DD2 = chain.get(n);
            Chain.CenterPoint centerPoint = null;
            if (jPoint2DD2 instanceof Chain.CenterPoint) {
                centerPoint = (Chain.CenterPoint)jPoint2DD2;
                jPoint2DD2 = chain.get(++n);
            }
            if (centerPoint == null) {
                this.sausagize(jPoint2DD, jPoint2DD2);
            } else {
                this.sausagize(jPoint2DD, centerPoint, jPoint2DD2);
            }
            jPoint2DD = jPoint2DD2;
            ++n;
        }
    }

    void mergeRing(Chain chain, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = chain.signedArea() >= 0.0;
        if (bl2 ^ bl) {
            this.mergeOrientedRing(chain);
        } else {
            this.mergeOrientedRing(chain.otherEnd());
        }
    }

    void mergeOrientedRing(final Chain chain) {
        int n;
        ++this.ringId;
        if (chain.size() < 3) {
            return;
        }
        final int n2 = chain.size();
        int n3 = 0;
        JPoint2DD jPoint2DD = chain.get(n3);
        int n4 = n2 - 1;
        JPoint2DD jPoint2DD2 = chain.get(n4);
        int n5 = PSSegment.compare(jPoint2DD, jPoint2DD2);
        int n6 = 0;
        while (n5 * n6 != -1 && n3 + 1 < n2) {
            if (n5 != 0) {
                n6 = n5;
            }
            jPoint2DD2 = jPoint2DD;
            n4 = n3++;
            jPoint2DD = chain.get(n3);
            if (jPoint2DD instanceof Chain.CenterPoint) {
                jPoint2DD = chain.get(++n3);
            }
            n5 = PSSegment.compare(jPoint2DD, jPoint2DD2);
        }
        int n7 = n4;
        if (n5 == 0) {
            return;
        }
        PSSegment pSSegment = null;
        PSSegment pSSegment2 = null;
        int n8 = n7;
        n6 = n5;
        int n9 = n7;
        JPoint2DD jPoint2DD3 = chain.get(n3);
        for (n3 = 0; n3 < n2 + 1; ++n3) {
            n = (n9 + 1) % n2;
            JPoint2DD jPoint2DD4 = chain.get(n);
            if (jPoint2DD4 instanceof Chain.CenterPoint) {
                n = (n + 1) % n2;
                jPoint2DD4 = chain.get(n);
                ++n3;
            }
            if ((n5 = PSSegment.compare(jPoint2DD4, jPoint2DD3)) * n6 == -1) {
                final int n10 = n6;
                final int n11 = n10 > 0 ? n8 : n9;
                final int n12 = n10 > 0 ? n9 : n8;
                PSSegment pSSegment3 = new PSSegment(this.ringId, -n10, new PSSegment.MonotoneUpdater(){
                    int m_cur;
                    {
                        this.m_cur = n11;
                    }

                    @Override
                    public boolean nextSegment(PSSegment pSSegment) {
                        if (this.m_cur == n12) {
                            return false;
                        }
                        int n = (this.m_cur + n10 + n2) % n2;
                        JPoint2DD jPoint2DD = chain.get(n);
                        Chain.CenterPoint centerPoint = null;
                        if (jPoint2DD instanceof Chain.CenterPoint) {
                            centerPoint = (Chain.CenterPoint)jPoint2DD;
                            n = (n + n10 + n2) % n2;
                            jPoint2DD = chain.get(n);
                        }
                        if (centerPoint == null) {
                            pSSegment.setLinearValues(chain.get(this.m_cur), jPoint2DD);
                        } else {
                            pSSegment.setArcValues(chain.get(this.m_cur), jPoint2DD, centerPoint, centerPoint.radius, centerPoint.CUW);
                        }
                        this.m_cur = n;
                        return true;
                    }
                });
                if (pSSegment == null) {
                    pSSegment = pSSegment3;
                    pSSegment2 = pSSegment3;
                } else if (n10 > 0) {
                    this.events.add(new Event(chain.get(n11), EventType.START, pSSegment, pSSegment3, null));
                } else {
                    this.events.add(new Event(chain.get(n12), EventType.END, pSSegment, pSSegment3, null));
                }
                pSSegment = pSSegment3;
                n6 = n5;
                n8 = n9;
            }
            n9 = n;
            jPoint2DD3 = jPoint2DD4;
        }
        if (pSSegment != null) {
            int n13 = n = n6 > 0 ? n9 : n8;
            if (n6 > 0) {
                this.events.add(new Event(pSSegment.left, EventType.START, pSSegment, pSSegment2, null));
            } else {
                this.events.add(new Event(chain.get(n), EventType.END, pSSegment, pSSegment2, null));
            }
        }
    }

    BufGeom sweep() {
        Event event = null;
        this.result = new BufGeom();
        Event event2 = this.events.poll();
        while (event2 != null) {
            ++this.eventCount;
            if (this.logDebug) {
                // empty if block
            }
            event = event2;
            System.out.flush();
            switch (event2.type) {
                case START: {
                    Chain[] chainArray;
                    this.slice.add(event2.a);
                    this.slice.add(event2.b);
                    PSSegment pSSegment = event2.a;
                    PSSegment pSSegment2 = event2.b;
                    if (this.slice.compareIndex(pSSegment.node, pSSegment2.node) > 0) {
                        pSSegment = event2.b;
                        pSSegment2 = event2.a;
                    }
                    int n = 0;
                    int n2 = 0;
                    int n3 = 0;
                    PSSegment pSSegment3 = pSSegment;
                    int n4 = 0;
                    while (pSSegment3.next() != pSSegment2) {
                        PSSegment pSSegment4 = pSSegment3.next();
                        ++n4;
                        n += pSSegment.compareTo(pSSegment4);
                        if ((n += pSSegment2.compareTo(pSSegment4)) > n2) {
                            n2 = n;
                            n3 = n4;
                        }
                        pSSegment3 = pSSegment4;
                    }
                    while (n3 > 0) {
                        --n3;
                        pSSegment.swap(pSSegment.next());
                    }
                    while (pSSegment.next() != pSSegment2) {
                        pSSegment2.prev().swap(pSSegment2);
                    }
                    int n5 = pSSegment2.next() != null ? pSSegment2.next().insidedness : 0;
                    pSSegment2.insidedness = n5 + pSSegment2.downDiff;
                    pSSegment.insidedness = n5;
                    if (n5 == 0 && pSSegment2.insidedness == 1 || n5 == 1 && pSSegment2.insidedness == 0) {
                        chainArray = Chain.create();
                        pSSegment2.c = chainArray[0];
                        pSSegment.c = chainArray[1];
                        pSSegment.c.add(pSSegment.left);
                    }
                    this.events.add(new Event(pSSegment.farRight, EventType.TRANSITION, pSSegment, null, null));
                    this.events.add(new Event(pSSegment2.farRight, EventType.TRANSITION, pSSegment2, null, null));
                    this.intersectAndOrder(pSSegment, pSSegment2);
                    break;
                }
                case END: {
                    if (event2.a.downDiff + event2.b.downDiff != 0) {
                        logger.fatal("Invalid downDiff pairing at END");
                        throw new NullPointerException();
                    }
                    if (!event2.a.left.equals(event2.a.farRight)) {
                        this.sweepTo(event2.a, event2.a.farRight);
                    }
                    if (!event2.b.left.equals(event2.b.farRight)) {
                        this.sweepTo(event2.b, event2.b.farRight);
                    }
                    PSSegment pSSegment = event2.a;
                    PSSegment pSSegment2 = event2.b;
                    if (this.slice.compareIndex(pSSegment.node, pSSegment2.node) > 0) {
                        pSSegment = event2.b;
                        pSSegment2 = event2.a;
                    }
                    while (pSSegment.next() != pSSegment2) {
                        pSSegment.swap(pSSegment.next());
                        this.didLiveSwap(pSSegment.prev(), pSSegment);
                    }
                    this.mergeChains(pSSegment, pSSegment2);
                    Chain[] chainArray = pSSegment.prev();
                    this.slice.remove(pSSegment.node);
                    this.slice.remove(pSSegment2.node);
                    pSSegment.node = null;
                    pSSegment2.node = null;
                    if (chainArray == null) break;
                    this.intersectAndOrder((PSSegment)chainArray, (PSSegment)chainArray);
                    break;
                }
                case TRANSITION: {
                    this.sweepTo(event2.a, event2.a.right);
                    if (event2.restoreRight == null) {
                        if (event2.a.updater.nextSegment(event2.a)) {
                            this.events.add(new Event(event2.a.farRight, EventType.TRANSITION, event2.a, null, null));
                        }
                    } else {
                        event2.a.right = event2.restoreRight;
                    }
                    this.intersectAndOrder(event2.a, event2.a);
                    break;
                }
                case INTERSECTANDORDER: {
                    PSSegment pSSegment = event2.a;
                    PSSegment pSSegment2 = event2.b;
                    if (this.slice.compareIndex(pSSegment.node, pSSegment2.node) > 0) {
                        pSSegment = event2.b;
                        pSSegment2 = event2.a;
                    }
                    this.intersectAndOrder(pSSegment, pSSegment2);
                    break;
                }
                default: {
                    throw new NullPointerException();
                }
            }
            event2 = this.events.poll();
        }
        return this.result;
    }

    private void sweepTo(PSSegment pSSegment, JPoint2DD jPoint2DD) {
        boolean bl = true;
        if (pSSegment.c == null) {
            bl = false;
        }
        pSSegment.left = jPoint2DD;
        if (bl) {
            if (pSSegment.type == PSSegment.SegType.ARC) {
                this.addSaneArc(pSSegment.c, pSSegment.left, pSSegment.center, pSSegment.radius, pSSegment.CUW);
            } else if (PSSegment.compare(pSSegment.c.get(0), pSSegment.left) < 0) {
                pSSegment.c.add(pSSegment.left);
            }
        }
    }

    void addSaneArc(Chain chain, JPoint2DD jPoint2DD, JPoint2DD jPoint2DD2, double d, boolean bl) {
        JPoint2DD jPoint2DD3 = chain.get(0);
        if (jPoint2DD.x <= jPoint2DD3.x) {
            return;
        }
        this.addSaneArcUnordered(chain, jPoint2DD, jPoint2DD2, d, bl);
    }

    private void addSaneArcUnordered(Chain chain, JPoint2DD jPoint2DD, JPoint2DD jPoint2DD2, double d, boolean bl) {
        JPoint2DD jPoint2DD3 = chain.get(0);
        double d2 = d * d;
        double d3 = 0.1 * d2;
        double d4 = Buffer.distance2(jPoint2DD3, jPoint2DD2) - d2;
        double d5 = Buffer.distance2(jPoint2DD, jPoint2DD2) - d2;
        if (Math.abs(d4) < d3 && Math.abs(d5) < d3 && (bl && jPoint2DD3.y <= jPoint2DD2.y && jPoint2DD.y <= jPoint2DD2.y || !bl && jPoint2DD3.y >= jPoint2DD2.y && jPoint2DD.y >= jPoint2DD2.y)) {
            chain.add(new Chain.CenterPoint(jPoint2DD2, d, bl));
            chain.add(jPoint2DD);
            return;
        }
        int n = (int)(Buffer.distance(jPoint2DD3, jPoint2DD) / (2.0 * d) * 24.0);
        if (n < 2 || (double)n >= 24.0) {
            chain.add(jPoint2DD);
            return;
        }
        double d6 = Math.atan2(jPoint2DD3.y - jPoint2DD2.y, jPoint2DD3.x - jPoint2DD2.x);
        double d7 = Math.atan2(jPoint2DD.y - jPoint2DD2.y, jPoint2DD.x - jPoint2DD2.x);
        double d8 = d7 - d6;
        if (d8 > Math.PI) {
            d8 -= Math.PI * 2;
        }
        if (d8 < -Math.PI) {
            d8 += Math.PI * 2;
        }
        double d9 = Buffer.distance(jPoint2DD3, jPoint2DD2);
        double d10 = Buffer.distance(jPoint2DD, jPoint2DD2);
        for (double d11 = 1.0; d11 < (double)n; d11 += 1.0) {
            double d12 = d11 / (double)n;
            double d13 = d6 + d8 * d12;
            double d14 = d12 * d10 + (1.0 - d12) * d9;
            JPoint2DD jPoint2DD4 = new JPoint2DD(jPoint2DD2.x + Math.cos(d13) * d14, jPoint2DD2.y + Math.sin(d13) * d14);
            chain.add(jPoint2DD4);
        }
        chain.add(jPoint2DD);
    }

    private void intersectAndOrder(PSSegment pSSegment, PSSegment pSSegment2) {
        boolean bl = false;
        IntComp intComp = new IntComp();
        do {
            PSSegment pSSegment3;
            boolean bl2 = false;
            PSSegment pSSegment4 = pSSegment.prev();
            if (pSSegment4 != null && !bl) {
                ++this.pairCount;
                this.adjacentComputeIntersection(intComp, pSSegment4, pSSegment);
                if (intComp.diff > 0) {
                    if (PSSegment.compare(pSSegment4.left, pSSegment.right) > 0) {
                        this.events.add(new Event(pSSegment4.left, EventType.INTERSECTANDORDER, pSSegment4, pSSegment2, pSSegment.right));
                        return;
                    }
                    if (PSSegment.compare(pSSegment.left, pSSegment4.right) > 0) {
                        this.events.add(new Event(pSSegment.left, EventType.INTERSECTANDORDER, pSSegment4, pSSegment2, pSSegment4.right));
                        return;
                    }
                    pSSegment4.swap(pSSegment);
                    if (pSSegment2 == pSSegment) {
                        pSSegment2 = pSSegment4;
                    }
                    this.didLiveSwap(pSSegment, pSSegment4);
                    bl2 = true;
                } else if (intComp.changed) {
                    pSSegment = pSSegment4;
                    bl2 = true;
                }
            }
            if (!bl2 && (pSSegment3 = pSSegment.next()) != null) {
                ++this.pairCount;
                this.adjacentComputeIntersection(intComp, pSSegment, pSSegment3);
                if (intComp.diff > 0) {
                    if (PSSegment.compare(pSSegment3.left, pSSegment.right) > 0) {
                        this.events.add(new Event(pSSegment3.left, EventType.INTERSECTANDORDER, pSSegment, pSSegment2, pSSegment.right));
                        return;
                    }
                    if (PSSegment.compare(pSSegment.left, pSSegment3.right) > 0) {
                        this.events.add(new Event(pSSegment.left, EventType.INTERSECTANDORDER, pSSegment, pSSegment2, pSSegment3.right));
                        return;
                    }
                    pSSegment.swap(pSSegment3);
                    if (pSSegment2 == pSSegment3) {
                        pSSegment2 = pSSegment;
                    }
                    this.didLiveSwap(pSSegment3, pSSegment);
                    pSSegment = pSSegment3;
                    bl2 = true;
                } else if (intComp.changed) {
                    bl2 = true;
                    if (pSSegment == pSSegment2) {
                        pSSegment2 = pSSegment3;
                    }
                }
            }
            if (bl2) {
                bl = false;
                continue;
            }
            pSSegment = pSSegment.next();
            bl = true;
        } while (pSSegment != null && pSSegment2.next() != pSSegment);
    }

    private void didLiveSwap(PSSegment pSSegment, PSSegment pSSegment2) {
        Serializable serializable;
        Chain[] chainArray;
        JPoint2DD jPoint2DD = null;
        if (pSSegment.left.equals(pSSegment2.left) || pSSegment.left.equals(pSSegment2.right)) {
            jPoint2DD = pSSegment.left;
        } else if (pSSegment.right.equals(pSSegment2.left)) {
            jPoint2DD = pSSegment.right;
        }
        if (jPoint2DD != null) {
            if (pSSegment.c != null && PSSegment.compare(jPoint2DD, pSSegment.left) > 0) {
                this.sweepTo(pSSegment, jPoint2DD);
            }
            if (pSSegment2.c != null && PSSegment.compare(jPoint2DD, pSSegment2.left) > 0) {
                this.sweepTo(pSSegment2, jPoint2DD);
            }
        } else if (pSSegment.c != null) {
            this.sweepTo(pSSegment, this.bestJumpingOffPoint(pSSegment, pSSegment2.left));
            pSSegment.c.addDistinct(this.bestJumpingOffPoint(pSSegment2, pSSegment.c.get(0)));
        } else if (pSSegment2.c != null) {
            this.sweepTo(pSSegment2, this.bestJumpingOffPoint(pSSegment2, pSSegment.left));
            pSSegment2.c.addDistinct(this.bestJumpingOffPoint(pSSegment, pSSegment2.c.get(0)));
        }
        int n = pSSegment.insidedness;
        int n2 = pSSegment2.insidedness;
        int n3 = n -= pSSegment.downDiff;
        pSSegment2.insidedness = n += pSSegment2.downDiff;
        pSSegment.insidedness = n2;
        if (pSSegment2.c != null && pSSegment.c != null) {
            this.mergeChains(pSSegment, pSSegment2);
        } else {
            chainArray = pSSegment2.c;
            pSSegment2.c = pSSegment.c;
            pSSegment.c = chainArray;
            serializable = pSSegment2.holes;
            pSSegment2.holes = pSSegment.holes;
            pSSegment.holes = serializable;
        }
        if (n == 1 && n3 == 0 && n2 == 0 || n == 0 && n3 == 1 && n2 == 1) {
            if (pSSegment2.c != null || pSSegment.c != null) {
                logger.warn("Unexpected chain at pair create");
            }
            chainArray = Chain.create();
            pSSegment2.c = chainArray[0];
            pSSegment.c = chainArray[1];
            if (jPoint2DD != null) {
                pSSegment2.c.add(jPoint2DD);
            } else {
                serializable = this.bestJumpingOffPoint(pSSegment, pSSegment2.left);
                JPoint2DD jPoint2DD2 = this.bestJumpingOffPoint(pSSegment2, pSSegment.left);
                pSSegment.c.add(new JPoint2DD((((JPoint2DD)serializable).x + jPoint2DD2.x) / 2.0, (((JPoint2DD)serializable).y + jPoint2DD2.y) / 2.0));
            }
        }
    }

    JPoint2DD bestJumpingOffPoint(PSSegment pSSegment, JPoint2DD jPoint2DD) {
        if (PSSegment.compare(pSSegment.left, jPoint2DD) >= 0) {
            return pSSegment.left;
        }
        JPoint2DD jPoint2DD2 = pSSegment.type == PSSegment.SegType.ARC ? this.closestOnCircle(pSSegment, jPoint2DD) : this.closestOnLinear(pSSegment, jPoint2DD);
        if (PSSegment.compare(jPoint2DD2, pSSegment.left) <= 0) {
            return pSSegment.left;
        }
        if (PSSegment.compare(jPoint2DD2, jPoint2DD) <= 0) {
            return jPoint2DD2;
        }
        return new JPoint2DD(jPoint2DD.x, pSSegment.yAt(jPoint2DD.x, 0.0));
    }

    private JPoint2DD closestOnCircle(PSSegment pSSegment, JPoint2DD jPoint2DD) {
        double d = jPoint2DD.x - pSSegment.center.x;
        double d2 = jPoint2DD.y - pSSegment.center.y;
        double d3 = Math.sqrt(d * d + d2 * d2);
        if (d3 == 0.0) {
            return pSSegment.left;
        }
        if (Math.abs(d3 - pSSegment.radius) <= this.machineTol && pSSegment.validateYside(jPoint2DD.y)) {
            return jPoint2DD;
        }
        double d4 = pSSegment.center.x + d / d3 * pSSegment.radius;
        double d5 = pSSegment.center.y + d2 / d3 * pSSegment.radius;
        if (pSSegment.validateYside(d5)) {
            return new JPoint2DD(d4, d5);
        }
        if (Buffer.distance2(pSSegment.left, jPoint2DD) < Buffer.distance2(pSSegment.right, jPoint2DD)) {
            return pSSegment.left;
        }
        return pSSegment.right;
    }

    JPoint2DD closestOnLinear(PSSegment pSSegment, JPoint2DD jPoint2DD) {
        double d = jPoint2DD.x - pSSegment.farLeft.x;
        double d2 = pSSegment.farRight.x - pSSegment.farLeft.x;
        double d3 = jPoint2DD.y - pSSegment.farLeft.y;
        double d4 = pSSegment.farRight.y - pSSegment.farLeft.y;
        double d5 = (d * d2 + d3 * d4) / (d2 * d2 + d4 * d4);
        if (d5 != d5) {
            return pSSegment.left;
        }
        JPoint2DD jPoint2DD2 = new JPoint2DD(pSSegment.farLeft.x + d5 * d2, pSSegment.farLeft.y + d5 * d4);
        if (PSSegment.compare(jPoint2DD2, pSSegment.left) < 0) {
            return pSSegment.left;
        }
        if (PSSegment.compare(jPoint2DD2, pSSegment.right) > 0) {
            return pSSegment.right;
        }
        return jPoint2DD2;
    }

    static final double distance2(JPoint2DD jPoint2DD, JPoint2DD jPoint2DD2) {
        return (jPoint2DD.x - jPoint2DD2.x) * (jPoint2DD.x - jPoint2DD2.x) + (jPoint2DD.y - jPoint2DD2.y) * (jPoint2DD.y - jPoint2DD2.y);
    }

    static final double distance(JPoint2DD jPoint2DD, JPoint2DD jPoint2DD2) {
        return Math.hypot(jPoint2DD.x - jPoint2DD2.x, jPoint2DD.y - jPoint2DD2.y);
    }

    private final double magnitude(JPoint2DD ... jPoint2DDArray) {
        double d = 0.0;
        for (int i = 0; i < jPoint2DDArray.length; ++i) {
            d = Math.max(d, Math.abs(jPoint2DDArray[i].x));
            d = Math.max(d, Math.abs(jPoint2DDArray[i].y));
        }
        return d;
    }

    private void mergeChains(PSSegment pSSegment, PSSegment pSSegment2) {
        if (pSSegment.c == null || pSSegment2.c == null) {
            PSSegment pSSegment3 = pSSegment2.next();
            if (pSSegment3 != null) {
                pSSegment3.holes = Chain.merge(pSSegment3.holes, pSSegment2.holes);
                pSSegment2.holes = null;
                pSSegment3.holes = Chain.merge(pSSegment3.holes, pSSegment.holes);
                pSSegment.holes = null;
            }
        } else if (pSSegment.c.sameChain(pSSegment2.c)) {
            if (pSSegment2.next() == null || pSSegment2.next().insidedness == 0) {
                pSSegment2.c.addMetaData(pSSegment2.holes);
                pSSegment2.holes = null;
                pSSegment2.c.addMetaData(pSSegment.holes);
                pSSegment.holes = null;
                pSSegment2.c.addDistinct(pSSegment2.c.get(pSSegment2.c.size() - 1));
                this.result.addPoly(pSSegment2.c);
            } else {
                PSSegment pSSegment4 = pSSegment2.next();
                pSSegment4.holes = Chain.merge(pSSegment4.holes, pSSegment2.c.getMetaData());
                pSSegment2.c.clearMetaData();
                pSSegment4.holes = Chain.merge(pSSegment4.holes, pSSegment2.holes);
                pSSegment2.holes = null;
                pSSegment4.holes = Chain.merge(pSSegment4.holes, pSSegment.holes);
                pSSegment.holes = null;
                if (pSSegment4.holes == null) {
                    pSSegment4.holes = new ArrayList();
                }
                pSSegment2.c.addDistinct(pSSegment2.c.get(pSSegment2.c.size() - 1));
                pSSegment4.holes.add(pSSegment2.c);
            }
            pSSegment.c = null;
            pSSegment2.c = null;
        } else {
            Chain chain = pSSegment.c.merge(pSSegment2.c, true);
            pSSegment.c = null;
            pSSegment2.c = null;
            chain.addMetaData(pSSegment.holes);
            pSSegment.holes = null;
            chain.addMetaData(pSSegment2.holes);
            pSSegment2.holes = null;
        }
    }

    private final void debugCheckClosed(Chain chain) {
        if (!chain.get(0).equals(chain.get(chain.size() - 1))) {
            this.debugLog("NumericError", "Unclosed poly", Double.toString(Buffer.distance(chain.get(0), chain.get(chain.size() - 1))), this.debugWKT(chain.get(0)));
        }
    }

    private void adjacentComputeIntersection(IntComp intComp, PSSegment pSSegment, PSSegment pSSegment2) {
        intComp.initialize();
        if (pSSegment.type == PSSegment.SegType.LINEAR) {
            if (pSSegment2.type == PSSegment.SegType.LINEAR) {
                this.lineLineIntersect(intComp, pSSegment, pSSegment2);
                intComp.diff = pSSegment.compareTo(pSSegment2, null);
            } else {
                this.lineArcIntersect(intComp, pSSegment, pSSegment2);
            }
        } else if (pSSegment2.type == PSSegment.SegType.LINEAR) {
            this.lineArcIntersect(intComp, pSSegment2, pSSegment);
            intComp.diff = -intComp.diff;
        } else {
            this.arcArcIntersect(intComp, pSSegment, pSSegment2);
            if (intComp.diff == 0) {
                intComp.diff = pSSegment.compareTo(pSSegment2, null);
            }
        }
    }

    private boolean adjacentProcessIntersection(PSSegment pSSegment, PSSegment pSSegment2, JPoint2DD jPoint2DD) {
        boolean bl = false;
        if (PSSegment.compare(jPoint2DD, pSSegment.left) > 0 && PSSegment.compare(jPoint2DD, pSSegment.right) < 0 && this.machTol(jPoint2DD, pSSegment.left) && this.machTol(jPoint2DD, pSSegment.right)) {
            this.events.add(new Event(jPoint2DD, EventType.TRANSITION, pSSegment, null, pSSegment.right));
            pSSegment.right = jPoint2DD;
            bl = true;
        }
        if (PSSegment.compare(jPoint2DD, pSSegment2.left) > 0 && PSSegment.compare(jPoint2DD, pSSegment2.right) < 0 && this.machTol(jPoint2DD, pSSegment2.left) && this.machTol(jPoint2DD, pSSegment2.right)) {
            this.events.add(new Event(jPoint2DD, EventType.TRANSITION, pSSegment2, null, pSSegment2.right));
            pSSegment2.right = jPoint2DD;
            bl = true;
        }
        return bl;
    }

    private boolean machTol(JPoint2DD jPoint2DD, JPoint2DD jPoint2DD2) {
        return (jPoint2DD.x - jPoint2DD2.x) * (jPoint2DD.x - jPoint2DD2.x) + (jPoint2DD.y - jPoint2DD2.y) * (jPoint2DD.y - jPoint2DD2.y) >= this.machineTol2;
    }

    private final void lineLineIntersect(IntComp intComp, PSSegment pSSegment, PSSegment pSSegment2) {
        double d = Math.min(pSSegment.left.y, pSSegment.right.y);
        double d2 = Math.max(pSSegment.left.y, pSSegment.right.y);
        double d3 = Math.min(pSSegment2.left.y, pSSegment2.right.y);
        double d4 = Math.max(pSSegment2.left.y, pSSegment2.right.y);
        if (d > d4 + this.machineTol) {
            return;
        }
        if (d3 > d2 + this.machineTol) {
            return;
        }
        if (pSSegment.left.equals(pSSegment2.left) || pSSegment.right.equals(pSSegment2.right) || pSSegment.left.equals(pSSegment2.right) || pSSegment.right.equals(pSSegment2.left)) {
            return;
        }
        double d5 = pSSegment.farRight.y - pSSegment.farLeft.y;
        double d6 = pSSegment2.farRight.x - pSSegment2.farLeft.x;
        double d7 = pSSegment2.farRight.y - pSSegment2.farLeft.y;
        double d8 = pSSegment.farRight.x - pSSegment.farLeft.x;
        double d9 = d5 * d6 - d7 * d8;
        if (d9 == 0.0) {
            if (Buffer.onLine0(pSSegment2.left, pSSegment.farLeft, pSSegment.farRight) && PSSegment.compare(pSSegment2.left, pSSegment.left) > 0 && PSSegment.compare(pSSegment2.left, pSSegment.right) < 0) {
                intComp.changed = this.adjacentProcessIntersection(pSSegment, pSSegment2, pSSegment2.left);
                return;
            }
            if (Buffer.onLine0(pSSegment.left, pSSegment2.farLeft, pSSegment2.farRight) && PSSegment.compare(pSSegment.left, pSSegment2.left) > 0 && PSSegment.compare(pSSegment.left, pSSegment2.right) < 0) {
                intComp.changed = this.adjacentProcessIntersection(pSSegment, pSSegment2, pSSegment.left);
                return;
            }
            if (Buffer.onLine0(pSSegment2.right, pSSegment.farLeft, pSSegment.farRight) && PSSegment.compare(pSSegment2.right, pSSegment.left) > 0 && PSSegment.compare(pSSegment2.right, pSSegment.right) < 0) {
                intComp.changed = this.adjacentProcessIntersection(pSSegment, pSSegment2, pSSegment2.right);
                return;
            }
            if (Buffer.onLine0(pSSegment.right, pSSegment2.farLeft, pSSegment2.farRight) && PSSegment.compare(pSSegment.right, pSSegment2.left) > 0 && PSSegment.compare(pSSegment.right, pSSegment2.right) < 0) {
                intComp.changed = this.adjacentProcessIntersection(pSSegment, pSSegment2, pSSegment.right);
                return;
            }
            return;
        }
        double d10 = (pSSegment.farLeft.x * (pSSegment2.farRight.y - pSSegment2.farLeft.y) + pSSegment2.farLeft.x * (pSSegment.farLeft.y - pSSegment2.farRight.y) + pSSegment2.farRight.x * (pSSegment2.farLeft.y - pSSegment.farLeft.y)) / d9;
        double d11 = -(pSSegment.farLeft.x * (pSSegment2.farLeft.y - pSSegment.farRight.y) + pSSegment.farRight.x * (pSSegment.farLeft.y - pSSegment2.farLeft.y) + pSSegment2.farLeft.x * (pSSegment.farRight.y - pSSegment.farLeft.y)) / d9;
        JPoint2DD jPoint2DD = null;
        if (d10 >= 0.0 && d10 <= 1.0 && d11 >= 0.0 && d11 <= 1.0) {
            jPoint2DD = new JPoint2DD(pSSegment.farLeft.x + d10 * (pSSegment.farRight.x - pSSegment.farLeft.x), pSSegment.farLeft.y + d10 * (pSSegment.farRight.y - pSSegment.farLeft.y));
            intComp.changed = this.adjacentProcessIntersection(pSSegment, pSSegment2, jPoint2DD);
            if (!intComp.changed) {
                jPoint2DD = new JPoint2DD(pSSegment2.farLeft.x + d11 * (pSSegment2.farRight.x - pSSegment2.farLeft.x), pSSegment2.farLeft.y + d11 * (pSSegment2.farRight.y - pSSegment2.farLeft.y));
                intComp.changed = this.adjacentProcessIntersection(pSSegment, pSSegment2, jPoint2DD);
            }
        }
    }

    private final void lineArcIntersect(IntComp intComp, PSSegment pSSegment, PSSegment pSSegment2) {
        double d;
        double d2;
        JPoint2DD jPoint2DD;
        double d3;
        double d4 = Math.min(pSSegment.left.y, pSSegment.right.y);
        double d5 = Math.max(pSSegment.left.y, pSSegment.right.y);
        double d6 = Math.min(pSSegment2.left.y, pSSegment2.right.y);
        if (pSSegment2.CUW && pSSegment2.left.x < pSSegment2.center.x && pSSegment2.right.x > pSSegment2.center.x) {
            d6 = Math.min(d6, pSSegment2.center.y - pSSegment2.radius);
        }
        double d7 = Math.max(pSSegment2.left.y, pSSegment2.right.y);
        if (!pSSegment2.CUW && pSSegment2.left.x < pSSegment2.center.x && pSSegment2.right.x > pSSegment2.center.x) {
            d7 = Math.max(d7, pSSegment2.center.y + pSSegment2.radius);
        }
        if (d4 > d7) {
            intComp.diff = 1;
            return;
        }
        if (d6 > d5) {
            intComp.diff = -1;
            return;
        }
        double d8 = Math.max(pSSegment.left.x, pSSegment2.left.x);
        double d9 = Math.min(pSSegment.right.x, pSSegment2.right.x);
        double d10 = pSSegment.farRight.x - pSSegment.farLeft.x;
        double d11 = pSSegment.farRight.y - pSSegment.farLeft.y;
        double d12 = d11 < 0.0 ? -1.0 : 1.0;
        double d13 = d10 * d10 + d11 * d11;
        double d14 = (pSSegment.farLeft.x - pSSegment2.center.x) * (pSSegment.farRight.y - pSSegment2.center.y) - (pSSegment.farRight.x - pSSegment2.center.x) * (pSSegment.farLeft.y - pSSegment2.center.y);
        double d15 = pSSegment2.radius * pSSegment2.radius * d13 - d14 * d14;
        if (d15 < 0.0) {
            double d16 = (d8 + d9) / 2.0;
            intComp.diff = Double.compare(pSSegment.yAt(d16, 0.5), pSSegment2.yAt(d16, 0.5));
            return;
        }
        double d17 = Math.sqrt(d15);
        double d18 = (d14 * d11 + d12 * d10 * d17) / d13 + pSSegment2.center.x;
        double d19 = (d14 * d11 - d12 * d10 * d17) / d13 + pSSegment2.center.x;
        double d20 = (-d14 * d10 + Math.abs(d11) * d17) / d13 + pSSegment2.center.y;
        double d21 = (-d14 * d10 - Math.abs(d11) * d17) / d13 + pSSegment2.center.y;
        if (d18 > d19) {
            d3 = d18;
            d18 = d19;
            d19 = d3;
            d3 = d20;
            d20 = d21;
            d21 = d3;
        }
        d3 = Math.max(pSSegment.farLeft.x, pSSegment2.farLeft.x);
        double d22 = Math.min(pSSegment.farRight.x, pSSegment2.farRight.x);
        double d23 = d9;
        double d24 = d9;
        double d25 = d9;
        if (d3 <= d18 && d18 <= d22 && pSSegment2.validateYside(d20) && d4 <= d20 && d20 <= d5) {
            jPoint2DD = new JPoint2DD(d18, d20);
            if (PSSegment.compare(jPoint2DD, pSSegment.farLeft) >= 0 && PSSegment.compare(jPoint2DD, pSSegment.farRight) <= 0 && PSSegment.compare(jPoint2DD, pSSegment2.farLeft) >= 0 && PSSegment.compare(jPoint2DD, pSSegment2.farRight) <= 0 && this.adjacentProcessIntersection(pSSegment, pSSegment2, jPoint2DD)) {
                intComp.changed = true;
                d9 = Math.min(pSSegment.right.x, pSSegment2.right.x);
                d23 = Math.min(d23, d9);
                d24 = Math.min(d24, d9);
                d25 = Math.min(d25, d9);
            }
            if (d8 <= d18 && d18 <= d9) {
                d23 = d9;
                d24 = d18;
                d25 = d18;
            }
        }
        if (d3 <= d19 && d19 <= d22 && pSSegment2.validateYside(d21) && d4 <= d21 && d21 <= d5) {
            jPoint2DD = new JPoint2DD(d19, d21);
            if (PSSegment.compare(jPoint2DD, pSSegment.farLeft) >= 0 && PSSegment.compare(jPoint2DD, pSSegment.farRight) <= 0 && PSSegment.compare(jPoint2DD, pSSegment2.farLeft) >= 0 && PSSegment.compare(jPoint2DD, pSSegment2.farRight) <= 0 && this.adjacentProcessIntersection(pSSegment, pSSegment2, jPoint2DD)) {
                intComp.changed = true;
                d9 = Math.min(pSSegment.right.x, pSSegment2.right.x);
                d23 = Math.min(d23, d9);
                d24 = Math.min(d24, d9);
                d25 = Math.min(d25, d9);
            }
            if (d8 <= d19 && d19 <= d9) {
                if (d25 - d19 > d23 - d24) {
                    d23 = d25;
                    d24 = d19;
                }
                d25 = d19;
            }
        }
        if (d25 - d8 > d23 - d24) {
            d23 = d25;
            d24 = d8;
        }
        if ((d2 = ((d = (d24 + d23) / 2.0) - d8) / (d9 - d8)) != d2) {
            d2 = 0.5;
        }
        intComp.diff = Double.compare(pSSegment.yAt(d, d2), pSSegment2.yAt(d, d2));
    }

    void arcArcIntersect(IntComp intComp, PSSegment pSSegment, PSSegment pSSegment2) {
        JPoint2DD jPoint2DD;
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        intComp.initialize();
        int n = 1;
        if (PSSegment.compare(pSSegment2.center, pSSegment.center) < 0) {
            PSSegment pSSegment3 = pSSegment;
            pSSegment = pSSegment2;
            pSSegment2 = pSSegment3;
            n = -1;
        }
        if ((d7 = Math.sqrt(d6 = Buffer.distance2(pSSegment.center, pSSegment2.center))) > pSSegment.radius + pSSegment2.radius) {
            return;
        }
        if (d7 == 0.0) {
            if (Math.abs(pSSegment.radius - pSSegment2.radius) > this.machineTol) {
                return;
            }
            if (pSSegment2.validateYside(pSSegment.right.y) && PSSegment.compare(pSSegment2.left, pSSegment.right) < 0 && PSSegment.compare(pSSegment.right, pSSegment2.right) < 0) {
                intComp.changed |= this.adjacentProcessIntersection(pSSegment, pSSegment2, pSSegment.right);
            }
            if (pSSegment.validateYside(pSSegment2.right.y) && PSSegment.compare(pSSegment.left, pSSegment2.right) < 0 && PSSegment.compare(pSSegment2.right, pSSegment.right) < 0) {
                intComp.changed |= this.adjacentProcessIntersection(pSSegment, pSSegment2, pSSegment2.right);
            }
            if (pSSegment2.validateYside(pSSegment.left.y) && PSSegment.compare(pSSegment2.left, pSSegment.left) < 0 && PSSegment.compare(pSSegment.left, pSSegment2.right) < 0) {
                intComp.changed |= this.adjacentProcessIntersection(pSSegment, pSSegment2, pSSegment.left);
            }
            if (pSSegment.validateYside(pSSegment2.left.y) && PSSegment.compare(pSSegment.left, pSSegment2.left) < 0 && PSSegment.compare(pSSegment2.left, pSSegment.right) < 0) {
                intComp.changed |= this.adjacentProcessIntersection(pSSegment, pSSegment2, pSSegment2.left);
            }
            return;
        }
        double d8 = (pSSegment2.center.x - pSSegment.center.x) / d7;
        double d9 = (pSSegment2.center.y - pSSegment.center.y) / d7;
        if (pSSegment.radius == pSSegment2.radius) {
            d5 = d7 / 2.0;
            d4 = (pSSegment.center.x + pSSegment2.center.x) / 2.0;
            d3 = (pSSegment.center.y + pSSegment2.center.y) / 2.0;
        } else {
            d5 = (d6 + pSSegment.radius * pSSegment.radius - pSSegment2.radius * pSSegment2.radius) / (2.0 * d7);
            d4 = pSSegment.center.x + d5 * d8;
            d3 = pSSegment.center.y + d5 * d9;
        }
        if (d5 > pSSegment.radius) {
            return;
        }
        double d10 = Math.sqrt(pSSegment.radius * pSSegment.radius - d5 * d5);
        if (d9 > 0.0) {
            d2 = d9;
            d = -d8;
        } else {
            d2 = -d9;
            d = d8;
        }
        double d11 = d4 + d10 * d2;
        double d12 = d3 + d10 * d;
        double d13 = d4 - d10 * d2;
        double d14 = d3 - d10 * d;
        double d15 = Math.max(pSSegment.left.x, pSSegment2.left.x);
        double d16 = Math.min(pSSegment.right.x, pSSegment2.right.x);
        double d17 = Math.max(pSSegment.farLeft.x, pSSegment2.farLeft.x);
        double d18 = Math.min(pSSegment.farRight.x, pSSegment2.farRight.x);
        double d19 = d16;
        double d20 = d16;
        double d21 = d16;
        if (d17 < d11 && d11 < d18 && pSSegment.validateYside(d12) && pSSegment2.validateYside(d12)) {
            jPoint2DD = new JPoint2DD(d11, d12);
            if (this.adjacentProcessIntersection(pSSegment, pSSegment2, jPoint2DD)) {
                intComp.changed = true;
                d16 = Math.min(pSSegment.right.x, pSSegment2.right.x);
                d19 = Math.min(d19, d16);
                d20 = Math.min(d20, d16);
                d21 = Math.min(d21, d16);
            }
            if (d15 <= d11 && d11 <= d16) {
                d19 = d16;
                d20 = d11;
                d21 = d11;
            }
        }
        if (d17 < d13 && d13 < d18 && pSSegment.validateYside(d14) && pSSegment2.validateYside(d14)) {
            jPoint2DD = new JPoint2DD(d13, d14);
            if (this.adjacentProcessIntersection(pSSegment, pSSegment2, jPoint2DD)) {
                intComp.changed = true;
                d16 = Math.min(pSSegment.right.x, pSSegment2.right.x);
                d19 = Math.min(d19, d16);
                d20 = Math.min(d20, d16);
                d21 = Math.min(d21, d16);
            }
            if (d15 <= d13 && d13 <= d16) {
                if (d21 - d13 > d19 - d20) {
                    d19 = d21;
                    d20 = d13;
                }
                d21 = d13;
            }
        }
        if (d21 - d15 > d19 - d20) {
            d19 = d21;
            d20 = d15;
        }
        double d22 = (d20 + d19) / 2.0;
        intComp.diff = n * Double.compare(pSSegment.yAt(d22, 0.5), pSSegment2.yAt(d22, 0.5));
    }

    public static boolean onLine0(JPoint2DD jPoint2DD, JPoint2DD jPoint2DD2, JPoint2DD jPoint2DD3) {
        double d;
        if (jPoint2DD.equals(jPoint2DD2) || jPoint2DD.equals(jPoint2DD3)) {
            return false;
        }
        double d2 = 1.0E-14 * Math.sqrt((jPoint2DD3.x - jPoint2DD2.x) * (jPoint2DD3.x - jPoint2DD2.x) + (jPoint2DD3.y - jPoint2DD2.y) * (jPoint2DD3.y - jPoint2DD2.y));
        if (Math.abs(jPoint2DD3.x - jPoint2DD2.x) < d2) {
            if (Math.abs(jPoint2DD.x - jPoint2DD2.x) > d2) {
                return false;
            }
            d = jPoint2DD.y;
        } else {
            d = jPoint2DD2.y + (jPoint2DD.x - jPoint2DD2.x) * (jPoint2DD3.y - jPoint2DD2.y) / (jPoint2DD3.x - jPoint2DD2.x);
            if (Math.abs(d - jPoint2DD.y) > d2) {
                return false;
            }
            if (Math.abs(jPoint2DD3.y - jPoint2DD2.y) < d2) {
                return jPoint2DD.x > jPoint2DD2.x && jPoint2DD.x < jPoint2DD3.x || jPoint2DD.x > jPoint2DD3.x && jPoint2DD.x < jPoint2DD2.x;
            }
        }
        return d > jPoint2DD2.y && d < jPoint2DD3.y || d > jPoint2DD3.y && d < jPoint2DD2.y;
    }

    private static final void validateSeg(PSSegment pSSegment) {
        if (pSSegment.type == PSSegment.SegType.ARC) {
            Buffer.validateArc(pSSegment);
        } else if (pSSegment.type == PSSegment.SegType.LINEAR) {
            Buffer.validateLine(pSSegment);
        } else {
            throw new IllegalArgumentException("validateSeg invalid type " + pSSegment);
        }
    }

    private static final void validateLine(PSSegment pSSegment) {
        if (pSSegment.type != PSSegment.SegType.LINEAR) {
            throw new IllegalArgumentException("validateLine wrong type " + pSSegment);
        }
        if (PSSegment.compare(pSSegment.farLeft, pSSegment.left) > 0 || PSSegment.compare(pSSegment.left, pSSegment.right) > 0 || PSSegment.compare(pSSegment.right, pSSegment.farRight) > 0) {
            throw new IllegalArgumentException("validateLine lefts and rights misordered " + pSSegment);
        }
    }

    private static final void validateArc(PSSegment pSSegment) {
        if (pSSegment.type != PSSegment.SegType.ARC) {
            throw new IllegalArgumentException("validateArc wrong type " + pSSegment);
        }
        if (PSSegment.compare(pSSegment.farLeft, pSSegment.left) > 0 || PSSegment.compare(pSSegment.left, pSSegment.right) > 0 || PSSegment.compare(pSSegment.right, pSSegment.farRight) > 0) {
            throw new NullPointerException("validateArc lefts and rights misordered " + pSSegment);
        }
        if (pSSegment.CUW) {
            if (pSSegment.farLeft.y > pSSegment.center.y || pSSegment.farRight.y > pSSegment.center.y) {
                throw new IllegalArgumentException("validateArc CCW, center inconsistent " + pSSegment);
            }
            if (pSSegment.left.y > pSSegment.center.y || pSSegment.right.y > pSSegment.center.y) {
                throw new IllegalArgumentException("validateArc CCW, center inconsistent " + pSSegment);
            }
        } else {
            if (pSSegment.farLeft.y < pSSegment.center.y || pSSegment.farRight.y < pSSegment.center.y) {
                throw new IllegalArgumentException("validateArc CCW, center inconsistent " + pSSegment);
            }
            if (pSSegment.left.y < pSSegment.center.y || pSSegment.right.y < pSSegment.center.y) {
                throw new IllegalArgumentException("validateArc CCW, center inconsistent " + pSSegment);
            }
        }
        if (pSSegment.radius <= 0.0) {
            throw new IllegalArgumentException("Invalid radius " + pSSegment.radius);
        }
    }

    void sausagize(BufGeom bufGeom) {
        if (bufGeom.chains == null) {
            this.sausagize(bufGeom.getRepPt());
        } else {
            for (Chain chain : bufGeom.chains) {
                if (bufGeom.linear) {
                    this.sausagizeLinear(chain, false);
                    continue;
                }
                this.sausagizeLinear(chain, true);
                this.mergeRing(chain, true);
                ArrayList<Chain> arrayList = chain.getMetaData();
                if (arrayList == null) continue;
                for (Chain chain2 : arrayList) {
                    this.sausagizeLinear(chain2, true);
                    this.mergeRing(chain2, false);
                }
            }
        }
    }

    void merge(BufGeom bufGeom) {
        if (bufGeom.chains == null || bufGeom.linear) {
            throw new IllegalArgumentException();
        }
        for (Chain chain : bufGeom.chains) {
            this.mergeRing(chain, true);
            ArrayList<Chain> arrayList = chain.getMetaData();
            if (arrayList == null) continue;
            for (Chain chain2 : arrayList) {
                this.mergeRing(chain2, false);
            }
        }
    }

    public void add(BufGeom bufGeom) {
        bufGeom.toBuffer(this.width);
        this.sorter.add(bufGeom);
    }

    public BufGeom process() {
        int n = 0;
        long l = System.currentTimeMillis();
        this.machineTol = 1.0E-12 * this.sorter.getMaxMagnitude();
        this.machineTol2 = this.machineTol * this.machineTol;
        Iterator<BufGeom> iterator = new ChainSplitter(this.sorter.iterator());
        this.sorter = new SpatialSort();
        if (!iterator.hasNext()) {
            return new BufGeom();
        }
        iterator = this.grouper((BufGeom)iterator.next(), iterator, ++n);
        while (true) {
            BufGeom bufGeom = iterator.next();
            if (!iterator.hasNext()) {
                return bufGeom;
            }
            iterator = this.grouper(bufGeom, iterator, ++n);
        }
    }

    private Iterator<BufGeom> grouper(final BufGeom bufGeom, final Iterator<BufGeom> iterator, final int n) {
        return new Iterator<BufGeom>(){
            ArrayList<BufGeom> inBatch = new ArrayList();
            {
                if (bufGeom != null) {
                    this.inBatch.add(bufGeom);
                }
            }

            @Override
            public boolean hasNext() {
                return this.inBatch.size() > 0 || iterator.hasNext();
            }

            @Override
            public BufGeom next() {
                int n6;
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                int n2 = 0;
                int n3 = this.inBatch.size();
                BufGeom bufGeom5 = null;
                while (iterator.hasNext()) {
                    bufGeom5 = (BufGeom)iterator.next();
                    n6 = this.inBatch.size();
                    for (n2 = Math.max(0, n2 - 100); n2 < n6; ++n2) {
                        if (!bufGeom5.merOverlap(this.inBatch.get(n2))) continue;
                        n6 = n2;
                        n2 = Math.max(0, n2 - 100 - 1);
                    }
                    if ((n3 += this.inBatch.size() - n6) <= 250 || this.inBatch.size() < 2) {
                        this.inBatch.add(bufGeom5);
                        bufGeom5 = null;
                        continue;
                    }
                    if (iterator.hasNext()) break;
                    this.inBatch.add(bufGeom5);
                    bufGeom5 = null;
                    break;
                }
                n6 = Buffer.this.eventCount;
                if (Buffer.this.events.size() != 0 || Buffer.this.slice.first() != null) {
                    throw new NullPointerException();
                }
                if (this.inBatch.size() == 1 && !this.inBatch.get((int)0).toBuffer) {
                    BufGeom bufGeom2 = this.inBatch.get(0);
                    this.inBatch.clear();
                    n2 = 0;
                    n3 = 0;
                    return bufGeom2;
                }
                double d = Double.POSITIVE_INFINITY;
                double d2 = Double.POSITIVE_INFINITY;
                double d3 = Double.NEGATIVE_INFINITY;
                double d4 = Double.NEGATIVE_INFINITY;
                int n4 = 0;
                int n5 = 0;
                for (BufGeom bufGeom3 : this.inBatch) {
                    if (bufGeom3.toBuffer) {
                        Buffer.this.sausagize(bufGeom3);
                        ++n4;
                        continue;
                    }
                    Buffer.this.merge(bufGeom3);
                    ++n5;
                }
                this.inBatch.clear();
                n2 = 0;
                n3 = 0;
                if (bufGeom5 != null) {
                    this.inBatch.add(bufGeom5);
                    ++n3;
                }
                BufGeom bufGeom4 = Buffer.this.sweep();
                return bufGeom4;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void dumpEvents() {
        for (Event event : this.events) {
            logger.finest(event.toString());
        }
    }

    private void dumpSlice() {
        Object object;
        if (!Buffer.DEBUG_DUMPRANGE(this.eventCount)) {
            return;
        }
        double d = Double.NEGATIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        SkipListData skipListData = this.slice.first();
        while (skipListData != null && skipListData.forward[0] != null) {
            if (skipListData.forward[0].back != skipListData) {
                logger.fatal("***ERRROR*** Bad linking");
                throw new NullPointerException();
            }
            skipListData = skipListData.forward[0];
        }
        PSSegment pSSegment = null;
        int n = 0;
        while (skipListData != null) {
            ++n;
            object = skipListData.payload;
            Buffer.validateSeg((PSSegment)object);
            if (pSSegment != null && ((PSSegment)object).compareTo(pSSegment, null) > 0) {
                this.adjacentComputeIntersection(new IntComp(), (PSSegment)object, pSSegment);
                ((PSSegment)object).compareTo(pSSegment, null);
                IntComp intComp = new IntComp();
                this.adjacentComputeIntersection(intComp, (PSSegment)object, pSSegment);
                if (intComp.changed) {
                    throw new NullPointerException();
                }
                if (intComp.diff > 0) {
                    logger.warn("Out of order: " + pSSegment);
                    logger.warn("          vs: " + object);
                    this.debugLog("Misordered", Integer.toString(n), "prev", Buffer.debugWKT(pSSegment));
                    this.debugLog("Misordered", Integer.toString(n), "seg", Buffer.debugWKT((PSSegment)object) + " compareTo: " + ((PSSegment)object).compareTo(pSSegment, null));
                    this.adjacentComputeIntersection(intComp, (PSSegment)object, pSSegment);
                    ((PSSegment)object).compareTo(pSSegment, null);
                }
            }
            pSSegment = object;
            d = Math.max(d, ((PSSegment)object).left.x);
            d2 = Math.min(d2, ((PSSegment)object).right.x);
            if (((PSSegment)object).c != null && ((PSSegment)object).c.size() > 0 && (((PSSegment)object).insidedness > 0 && ((PSSegment)object).downDiff < 0 || ((PSSegment)object).insidedness > 1)) {
                logger.warn("Chain on non-boundary");
            }
            this.debugLog("dumpSlice", Integer.toString(n), ((PSSegment)object).toString(), Buffer.debugWKT((PSSegment)object));
            if (skipListData.payload.node != skipListData) {
                logger.fatal("**ERROR** p != node:  " + skipListData + " != " + skipListData.payload.node);
                throw new NullPointerException();
            }
            skipListData = skipListData.back;
        }
        if (d2 < d) {
            // empty if block
        }
        object = this.events.peek() == null ? "*** NO EVENTS ***" : this.events.peek().toString();
        logger.finest("------ slice ----- next: " + (String)object);
    }

    static String debugWKT(PSSegment pSSegment) {
        if (pSSegment.type == PSSegment.SegType.ARC) {
            return Buffer.debugWKT(pSSegment.left, new Chain.CenterPoint(pSSegment.center, pSSegment.radius, pSSegment.CUW), pSSegment.right);
        }
        StringBuffer stringBuffer = new StringBuffer("LINESTRING(" + pSSegment.left.x + " " + pSSegment.left.y);
        stringBuffer.append(", " + pSSegment.right.x + " " + pSSegment.right.y);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    static String debugWKT(JPoint2DD jPoint2DD, Chain.CenterPoint centerPoint, JPoint2DD jPoint2DD2) {
        StringBuffer stringBuffer = new StringBuffer("LINESTRING(" + jPoint2DD.x + " " + jPoint2DD.y);
        stringBuffer.append(" " + Buffer.debugArcExpansion(jPoint2DD, jPoint2DD2, centerPoint, centerPoint.radius, centerPoint.CUW) + ")");
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    static String debugArcExpansion(JPoint2DD jPoint2DD, JPoint2DD jPoint2DD2, JPoint2DD jPoint2DD3, double d, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 60;
        double d2 = Math.PI;
        double d3 = -Math.PI / (double)(n + 2);
        if (bl) {
            d3 = -d3;
        }
        if (PSSegment.compare(jPoint2DD, jPoint2DD2) > 0) {
            d2 = 0.0;
            d3 = -d3;
        }
        while (n > 0) {
            double d4;
            JPoint2DD jPoint2DD4;
            --n;
            double d5 = jPoint2DD3.x + Math.cos(d2 += d3) * d;
            if (PSSegment.compare(jPoint2DD4 = new JPoint2DD(d5, d4 = jPoint2DD3.y + Math.sin(d2) * d), jPoint2DD) * PSSegment.compare(jPoint2DD4, jPoint2DD2) >= 0) continue;
            stringBuffer.append(", " + jPoint2DD4.x + " " + jPoint2DD4.y);
        }
        stringBuffer.append(", " + jPoint2DD2.x + " " + jPoint2DD2.y);
        return stringBuffer.toString();
    }

    private String debugWKT(JPoint2DD jPoint2DD) {
        return "POINT(" + jPoint2DD.x + " " + jPoint2DD.y + ")";
    }

    private void debugLog(String string, String string2, String string3, String string4) {
        geomLog.warn(this.eventCount + ", \"" + string + "\", \"" + string2 + "\", \"" + string3 + "\", \"" + string4 + "\"");
    }

    static {
        maxMERdiff = Double.NEGATIVE_INFINITY;
    }

    private class ChainSplitter
    implements Iterator<BufGeom> {
        Iterator<BufGeom> inItr;
        BufGeom returnNext;
        BufGeom cur;
        int curChain = 0;
        int curHole = -1;
        int curUsed = 0;

        private ChainSplitter(Iterator<BufGeom> iterator) {
            this.inItr = iterator;
            this.returnNext = this.prefetchNext();
        }

        @Override
        public boolean hasNext() {
            return this.returnNext != null;
        }

        @Override
        public BufGeom next() {
            BufGeom bufGeom = this.returnNext;
            this.returnNext = this.prefetchNext();
            return bufGeom;
        }

        private BufGeom prefetchNext() {
            Object object = null;
            while (object == null) {
                int n;
                Object object2;
                if (this.cur == null) {
                    if (!this.inItr.hasNext()) {
                        return null;
                    }
                    object2 = this.inItr.next();
                    if (!((BufGeom)object2).toBuffer) {
                        object = object2;
                        continue;
                    }
                    if (((BufGeom)object2).chains == null) {
                        object = object2;
                        continue;
                    }
                    this.cur = object2;
                    this.curChain = 0;
                    this.curHole = -1;
                    this.curUsed = 0;
                    continue;
                }
                Object object3 = object2 = this.cur.chains.get(this.curChain);
                ArrayList<Chain> arrayList = ((Chain)object2).getMetaData();
                int n2 = n = arrayList == null ? 0 : arrayList.size();
                if (this.curHole >= 0) {
                    object3 = arrayList.get(this.curHole);
                }
                if (this.curUsed < ((Chain)object3).size() - 1) {
                    JPoint2DD jPoint2DD = ((Chain)object3).get(this.curUsed);
                    ++this.curUsed;
                    JPoint2DD jPoint2DD2 = ((Chain)object3).get(this.curUsed);
                    if (jPoint2DD2 instanceof Chain.CenterPoint) {
                        Chain.CenterPoint centerPoint = (Chain.CenterPoint)jPoint2DD2;
                        ++this.curUsed;
                        jPoint2DD2 = ((Chain)object3).get(this.curUsed);
                        object = new BufGeom(jPoint2DD, centerPoint, jPoint2DD2);
                    } else {
                        object = new BufGeom(jPoint2DD, jPoint2DD2);
                    }
                    ((BufGeom)object).toBuffer(Buffer.this.width);
                    continue;
                }
                this.curUsed = 0;
                ++this.curHole;
                if (this.curHole < n) continue;
                this.curHole = -1;
                ++this.curChain;
                if (this.curChain < this.cur.chains.size()) continue;
                if (this.cur.chains != null && this.cur.toBuffer && !this.cur.linear) {
                    this.cur.toBuffer = false;
                    object = this.cur;
                }
                this.curChain = 0;
                this.cur = null;
            }
            return object;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class IntComp {
        boolean changed;
        int diff;

        IntComp() {
        }

        void initialize() {
            this.changed = false;
            this.diff = 0;
        }

        public String toString() {
            return this.changed + ":" + this.diff;
        }
    }

    private static class Event
    implements Comparable<Event> {
        JPoint2DD time;
        EventType type;
        PSSegment a;
        PSSegment b;
        JPoint2DD restoreRight;

        Event(JPoint2DD jPoint2DD, EventType eventType, PSSegment pSSegment, PSSegment pSSegment2, JPoint2DD jPoint2DD2) {
            this.time = jPoint2DD;
            this.type = eventType;
            this.a = pSSegment;
            this.b = pSSegment2;
            this.restoreRight = jPoint2DD2;
        }

        @Override
        public int compareTo(Event event) {
            int n = PSSegment.compare(this.time, event.time);
            if (n != 0) {
                return n;
            }
            return this.type.ordinal() - event.type.ordinal();
        }

        public String toString() {
            return this.time + " " + (Object)((Object)this.type) + " " + this.a + " :: " + this.b + " " + this.restoreRight;
        }
    }

    static enum EventType {
        START,
        TRANSITION,
        INTERSECTANDORDER,
        END;

    }
}

