/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.bookmarks;

import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.bookmarks.Bookmark;
import oracle.ide.bookmarks.BookmarkConstants;
import oracle.ide.bookmarks.BookmarkEvent;
import oracle.ide.bookmarks.BookmarkIcons;
import oracle.ide.bookmarks.BookmarkListener;
import oracle.ide.bookmarks.BookmarkManager;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.bookmarks.BookmarkDescriptionUpdater;
import oracle.ide.ceditor.bookmarks.Bookmarks;
import oracle.ide.ceditor.bookmarks.CodeEditorBookmark;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.javatools.editor.gutter.GutterColumn;
import oracle.javatools.editor.gutter.GutterColumnListener;
import oracle.javatools.editor.gutter.GutterMark;

final class BookmarkTracker {
    private static GutterColumnL gutterColumnL = new GutterColumnL();

    private BookmarkTracker() {
    }

    static void initialize() {
        BookmarkManager.getBookmarkManager().addBookmarkListener((BookmarkListener)new BookmarkL());
        EditorManager.getEditorManager().addEditorListener(new EditorListener(){

            public void editorOpened(Editor editor) {
                if (!(editor instanceof CodeEditor)) {
                    return;
                }
                URL editorURL = editor.getContext().getNode().getURL();
                for (Bookmark bookmark : BookmarkManager.getBookmarkManager().getAllBookmarks()) {
                    CodeEditorBookmark codeEditorBookmark;
                    if (!(bookmark instanceof CodeEditorBookmark) || (codeEditorBookmark = (CodeEditorBookmark)bookmark) == null || codeEditorBookmark.getURL() == null || !codeEditorBookmark.getURL().equals(editorURL)) continue;
                    BookmarkTracker.addBookmark(codeEditorBookmark, (CodeEditor)editor);
                }
            }

            public void editorActivated(Editor editor) {
            }

            public void editorDeactivated(Editor editor) {
            }

            public void editorClosed(Editor editor) {
            }
        });
    }

    private static void bookmarkAdded(CodeEditorBookmark bookmark) {
        for (CodeEditor editor : BookmarkTracker.getOpenEditors(bookmark)) {
            BookmarkTracker.addBookmark(bookmark, editor);
        }
    }

    private static void addBookmark(CodeEditorBookmark bookmark, CodeEditor editor) {
        int number = BookmarkManager.getBookmarkManager().getBookmarkNumber((Bookmark)bookmark);
        GutterColumn col = BookmarkTracker.getGutterColumn(editor, true);
        GutterMark mark = col.addGutterMark(bookmark.getLine(), BookmarkIcons.getIcon((int)number), BookmarkConstants.BOOKMARK_STYLE, 2000, 5);
        if (mark == null) {
            return;
        }
        mark.setUserData((Object)bookmark);
        BookmarkDescriptionUpdater.updateDescription(editor.getFocusedEditorPane().getDocument(), bookmark);
    }

    private static void bookmarkRemoved(CodeEditorBookmark bookmark) {
        for (CodeEditor editor : BookmarkTracker.getOpenEditors(bookmark)) {
            GutterColumn col = BookmarkTracker.getGutterColumn(editor, false);
            if (col == null) continue;
            for (GutterMark mark : col.lookupGutterMarks(bookmark.getLine())) {
                col.removeGutterMark(mark);
            }
        }
    }

    private static void bookmarkUpdated(CodeEditorBookmark bookmark) {
        for (CodeEditor editor : BookmarkTracker.getOpenEditors(bookmark)) {
            GutterColumn col = BookmarkTracker.getGutterColumn(editor, false);
            if (col == null) continue;
            int number = BookmarkManager.getBookmarkManager().getBookmarkNumber((Bookmark)bookmark);
            Icon icon = BookmarkIcons.getIcon((int)number);
            for (GutterMark mark : col.lookupGutterMarks(bookmark.getLine())) {
                mark.setIcon(icon);
            }
        }
    }

    private static List<CodeEditor> getOpenEditors(CodeEditorBookmark bookmark) {
        ArrayList<CodeEditor> editors = new ArrayList<CodeEditor>();
        for (Editor editor : EditorManager.getEditorManager().getAllEditors()) {
            if (!(editor instanceof CodeEditor) || !editor.getContext().getNode().getURL().equals(bookmark.getURL())) continue;
            editors.add((CodeEditor)editor);
        }
        return editors;
    }

    private static GutterColumn getGutterColumn(CodeEditor editor, boolean create) {
        GutterColumn gutterColumn = editor.getGutter().lookupGutterColumn("bookmark-category");
        if (gutterColumn == null && create) {
            gutterColumn = editor.getGutter().createGutterColumn("bookmark-category", (GutterColumnListener)gutterColumnL);
        }
        return gutterColumn;
    }

    private static class BookmarkL
    implements BookmarkListener {
        private BookmarkL() {
        }

        public void bookmarksChanged(BookmarkEvent bookmarkEvent) {
            Bookmark bookmark = bookmarkEvent.getBookmark();
            if (!(bookmark instanceof CodeEditorBookmark)) {
                return;
            }
            CodeEditorBookmark codeEditorBookmark = (CodeEditorBookmark)bookmark;
            switch (bookmarkEvent.getType()) {
                case ADDITION: {
                    BookmarkTracker.bookmarkAdded(codeEditorBookmark);
                    break;
                }
                case REMOVAL: {
                    BookmarkTracker.bookmarkRemoved(codeEditorBookmark);
                    break;
                }
                case UPDATE: {
                    BookmarkTracker.bookmarkUpdated(codeEditorBookmark);
                }
            }
        }
    }

    private static class GutterColumnL
    implements GutterColumnListener {
        private GutterColumnL() {
        }

        public void markMoved(GutterMark gutterMark, int oldLine, int newLine) {
            if (gutterMark.getUserData() instanceof CodeEditorBookmark) {
                ((CodeEditorBookmark)((Object)gutterMark.getUserData())).setLine(newLine);
            }
        }

        public void markRemoved(GutterMark gutterMark, int deletedLine) {
            if (gutterMark.getUserData() instanceof CodeEditorBookmark) {
                BookmarkManager.getBookmarkManager().removeBookmark((Bookmark)((CodeEditorBookmark)((Object)gutterMark.getUserData())));
            }
        }

        public void markClicked(GutterMark gutterMark, int clickedLine, MouseEvent event) {
            Bookmark bookmark = (Bookmark)gutterMark.getUserData();
            BookmarkManager.getBookmarkManager().removeBookmark(bookmark);
        }

        public String getMarkToolTip(GutterMark mark, MouseEvent event) {
            Bookmark bookmark = (Bookmark)mark.getUserData();
            String tip = Bookmarks.format("TOOLTIP_FORMAT", bookmark.getDescription());
            return tip;
        }
    }
}

