/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.sftp;

import com.jcraft.jsch.ConfigRepository;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.sftp.IdentityInfo;
import org.apache.commons.vfs2.provider.sftp.IdentityProvider;
import org.apache.commons.vfs2.provider.sftp.IdentityRepositoryFactory;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystem;

public final class SftpFileSystemConfigBuilder
extends FileSystemConfigBuilder {
    private static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 0;
    private static final int DEFAULT_SESSION_TIMEOUT_MILLIS = 0;
    private static final String _PREFIX = SftpFileSystemConfigBuilder.class.getName();
    private static final SftpFileSystemConfigBuilder BUILDER = new SftpFileSystemConfigBuilder();
    private static final String COMPRESSION = _PREFIX + "COMPRESSION";
    private static final String CONNECT_TIMEOUT_MILLIS = _PREFIX + ".CONNECT_TIMEOUT_MILLIS";
    private static final String ENCODING = _PREFIX + ".ENCODING";
    private static final String HOST_KEY_CHECK_ASK = "ask";
    private static final String HOST_KEY_CHECK_NO = "no";
    private static final String HOST_KEY_CHECK_YES = "yes";
    private static final String IDENTITIES = _PREFIX + ".IDENTITIES";
    private static final String IDENTITY_REPOSITORY_FACTORY = _PREFIX + "IDENTITY_REPOSITORY_FACTORY";
    private static final String CONFIG_REPOSITORY = _PREFIX + "CONFIG_REPOSITORY";
    private static final String KEY_EXCHANGE_ALGORITHM = _PREFIX + ".KEY_EXCHANGE_ALGORITHM";
    private static final String LOAD_OPENSSH_CONFIG = _PREFIX + "LOAD_OPENSSH_CONFIG";
    private static final String KNOWN_HOSTS = _PREFIX + ".KNOWN_HOSTS";
    private static final String PREFERRED_AUTHENTICATIONS = _PREFIX + ".PREFERRED_AUTHENTICATIONS";
    private static final String PROXY_COMMAND = _PREFIX + ".PROXY_COMMAND";
    private static final String PROXY_HOST = _PREFIX + ".PROXY_HOST";
    private static final String PROXY_OPTIONS = _PREFIX + ".PROXY_OPTIONS";
    private static final String PROXY_PASSWORD = _PREFIX + ".PROXY_PASSWORD";
    private static final String PROXY_PORT = _PREFIX + ".PROXY_PORT";
    public static final ProxyType PROXY_HTTP = new ProxyType("http");
    public static final ProxyType PROXY_SOCKS5 = new ProxyType("socks");
    public static final ProxyType PROXY_STREAM = new ProxyType("stream");
    private static final String PROXY_TYPE = _PREFIX + ".PROXY_TYPE";
    private static final String PROXY_USER = _PREFIX + ".PROXY_USER";
    private static final String SESSION_TIMEOUT_MILLIS = _PREFIX + ".TIMEOUT";
    private static final String STRICT_HOST_KEY_CHECKING = _PREFIX + ".STRICT_HOST_KEY_CHECKING";
    private static final String USER_DIR_IS_ROOT = _PREFIX + ".USER_DIR_IS_ROOT";

    public static SftpFileSystemConfigBuilder getInstance() {
        return BUILDER;
    }

    private SftpFileSystemConfigBuilder() {
        super("sftp.");
    }

    public String getCompression(FileSystemOptions opts) {
        return this.getString(opts, COMPRESSION);
    }

    @Override
    protected Class<? extends FileSystem> getConfigClass() {
        return SftpFileSystem.class;
    }

    public Integer getConnectTimeoutMillis(FileSystemOptions opts) {
        return this.getInteger(opts, CONNECT_TIMEOUT_MILLIS, 0);
    }

    public String getFileNameEncoding(FileSystemOptions opts) {
        return this.getString(opts, ENCODING);
    }

    @Deprecated
    public File[] getIdentities(FileSystemOptions opts) {
        IdentityInfo[] info = this.getIdentityInfo(opts);
        if (info != null) {
            File[] files = new File[info.length];
            for (int i = 0; i < files.length; ++i) {
                files[i] = info[i].getPrivateKey();
            }
            return files;
        }
        return null;
    }

    public IdentityInfo[] getIdentityInfo(FileSystemOptions opts) {
        IdentityProvider[] infos = this.getIdentityProvider(opts);
        if (infos != null) {
            ArrayList<IdentityInfo> list = new ArrayList<IdentityInfo>(infos.length);
            for (IdentityProvider identityProvider : infos) {
                if (!(identityProvider instanceof IdentityInfo)) continue;
                list.add((IdentityInfo)identityProvider);
            }
            return list.toArray(new IdentityInfo[list.size()]);
        }
        return null;
    }

    public IdentityProvider[] getIdentityProvider(FileSystemOptions opts) {
        return (IdentityProvider[])this.getParam(opts, IDENTITIES);
    }

    public IdentityRepositoryFactory getIdentityRepositoryFactory(FileSystemOptions opts) {
        return (IdentityRepositoryFactory)this.getParam(opts, IDENTITY_REPOSITORY_FACTORY);
    }

    public ConfigRepository getConfigRepository(FileSystemOptions opts) {
        return (ConfigRepository)this.getParam(opts, CONFIG_REPOSITORY);
    }

    public boolean isLoadOpenSSHConfig(FileSystemOptions opts) {
        return this.getBoolean(opts, LOAD_OPENSSH_CONFIG, Boolean.FALSE);
    }

    public File getKnownHosts(FileSystemOptions opts) {
        return (File)this.getParam(opts, KNOWN_HOSTS);
    }

    public String getPreferredAuthentications(FileSystemOptions opts) {
        return this.getString(opts, PREFERRED_AUTHENTICATIONS);
    }

    public String getProxyCommand(FileSystemOptions opts) {
        return this.getString(opts, PROXY_COMMAND, "nc -q 0 %s %d");
    }

    public String getProxyHost(FileSystemOptions opts) {
        return this.getString(opts, PROXY_HOST);
    }

    public FileSystemOptions getProxyOptions(FileSystemOptions opts) {
        return (FileSystemOptions)this.getParam(opts, PROXY_OPTIONS);
    }

    public String getProxyPassword(FileSystemOptions opts) {
        return this.getString(opts, PROXY_PASSWORD);
    }

    public int getProxyPort(FileSystemOptions opts) {
        return this.getInteger(opts, PROXY_PORT, 0);
    }

    public ProxyType getProxyType(FileSystemOptions opts) {
        return (ProxyType)this.getParam(opts, PROXY_TYPE);
    }

    public String getProxyUser(FileSystemOptions opts) {
        return this.getString(opts, PROXY_USER);
    }

    public Integer getSessionTimeoutMillis(FileSystemOptions opts) {
        return this.getInteger(opts, SESSION_TIMEOUT_MILLIS, 0);
    }

    public String getStrictHostKeyChecking(FileSystemOptions opts) {
        return this.getString(opts, STRICT_HOST_KEY_CHECKING, HOST_KEY_CHECK_NO);
    }

    public String getKeyExchangeAlgorithm(FileSystemOptions opts) {
        return this.getString(opts, KEY_EXCHANGE_ALGORITHM);
    }

    @Deprecated
    public Integer getTimeout(FileSystemOptions opts) {
        return this.getInteger(opts, SESSION_TIMEOUT_MILLIS);
    }

    public Boolean getUserDirIsRoot(FileSystemOptions opts) {
        return this.getBoolean(opts, USER_DIR_IS_ROOT, Boolean.TRUE);
    }

    public UserInfo getUserInfo(FileSystemOptions opts) {
        return (UserInfo)this.getParam(opts, UserInfo.class.getName());
    }

    public void setCompression(FileSystemOptions opts, String compression) throws FileSystemException {
        this.setParam(opts, COMPRESSION, compression);
    }

    public void setConnectTimeoutMillis(FileSystemOptions opts, Integer timeout) {
        this.setParam(opts, CONNECT_TIMEOUT_MILLIS, timeout);
    }

    public void setFileNameEncoding(FileSystemOptions opts, String fileNameEncoding) {
        this.setParam(opts, ENCODING, fileNameEncoding);
    }

    @Deprecated
    public void setIdentities(FileSystemOptions opts, File ... identityFiles) throws FileSystemException {
        IdentityProvider[] info = null;
        if (identityFiles != null) {
            info = new IdentityProvider[identityFiles.length];
            for (int i = 0; i < identityFiles.length; ++i) {
                info[i] = new IdentityInfo(identityFiles[i]);
            }
        }
        this.setParam(opts, IDENTITIES, info);
    }

    @Deprecated
    public void setIdentityInfo(FileSystemOptions opts, IdentityInfo ... identites) throws FileSystemException {
        this.setParam(opts, IDENTITIES, identites);
    }

    public void setIdentityProvider(FileSystemOptions opts, IdentityProvider ... identites) throws FileSystemException {
        this.setParam(opts, IDENTITIES, identites);
    }

    public void setIdentityRepositoryFactory(FileSystemOptions opts, IdentityRepositoryFactory factory) throws FileSystemException {
        this.setParam(opts, IDENTITY_REPOSITORY_FACTORY, factory);
    }

    public void setConfigRepository(FileSystemOptions opts, ConfigRepository configRepository) throws FileSystemException {
        this.setParam(opts, CONFIG_REPOSITORY, configRepository);
    }

    public void setKnownHosts(FileSystemOptions opts, File knownHosts) throws FileSystemException {
        this.setParam(opts, KNOWN_HOSTS, knownHosts);
    }

    public void setPreferredAuthentications(FileSystemOptions opts, String preferredAuthentications) {
        this.setParam(opts, PREFERRED_AUTHENTICATIONS, preferredAuthentications);
    }

    public void setProxyCommand(FileSystemOptions opts, String proxyCommand) {
        this.setParam(opts, PROXY_COMMAND, proxyCommand);
    }

    public void setProxyHost(FileSystemOptions opts, String proxyHost) {
        this.setParam(opts, PROXY_HOST, proxyHost);
    }

    public void setProxyOptions(FileSystemOptions opts, FileSystemOptions proxyOptions) {
        this.setParam(opts, PROXY_OPTIONS, proxyOptions);
    }

    public void setProxyPassword(FileSystemOptions opts, String proxyPassword) {
        this.setParam(opts, PROXY_PASSWORD, proxyPassword);
    }

    public void setProxyPort(FileSystemOptions opts, int proxyPort) {
        this.setParam(opts, PROXY_PORT, proxyPort);
    }

    public void setProxyType(FileSystemOptions opts, ProxyType proxyType) {
        this.setParam(opts, PROXY_TYPE, proxyType);
    }

    public void setProxyUser(FileSystemOptions opts, String proxyUser) {
        this.setParam(opts, PROXY_USER, proxyUser);
    }

    public void setSessionTimeoutMillis(FileSystemOptions opts, Integer timeout) {
        this.setParam(opts, SESSION_TIMEOUT_MILLIS, timeout);
    }

    public void setKeyExchangeAlgorithm(FileSystemOptions opts, String keyExchangeAlgoritm) {
        this.setParam(opts, KEY_EXCHANGE_ALGORITHM, keyExchangeAlgoritm);
    }

    public void setStrictHostKeyChecking(FileSystemOptions opts, String hostKeyChecking) throws FileSystemException {
        if (hostKeyChecking == null || !hostKeyChecking.equals(HOST_KEY_CHECK_ASK) && !hostKeyChecking.equals(HOST_KEY_CHECK_NO) && !hostKeyChecking.equals(HOST_KEY_CHECK_YES)) {
            throw new FileSystemException("vfs.provider.sftp/StrictHostKeyChecking-arg.error", (Object)hostKeyChecking);
        }
        this.setParam(opts, STRICT_HOST_KEY_CHECKING, hostKeyChecking);
    }

    @Deprecated
    public void setTimeout(FileSystemOptions opts, Integer timeout) {
        this.setParam(opts, SESSION_TIMEOUT_MILLIS, timeout);
    }

    public void setUserDirIsRoot(FileSystemOptions opts, boolean userDirIsRoot) {
        this.setParam(opts, USER_DIR_IS_ROOT, userDirIsRoot ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setUserInfo(FileSystemOptions opts, UserInfo info) {
        this.setParam(opts, UserInfo.class.getName(), info);
    }

    public void setLoadOpenSSHConfig(FileSystemOptions opts, boolean loadOpenSSHConfig) {
        this.setParam(opts, LOAD_OPENSSH_CONFIG, loadOpenSSHConfig ? Boolean.TRUE : Boolean.FALSE);
    }

    public static final class ProxyType
    implements Serializable,
    Comparable<ProxyType> {
        private static final long serialVersionUID = 20101208L;
        private final String proxyType;

        private ProxyType(String proxyType) {
            this.proxyType = proxyType;
        }

        @Override
        public int compareTo(ProxyType pType) {
            return this.proxyType.compareTo(pType.proxyType);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ProxyType pType = (ProxyType)obj;
            return !(this.proxyType != null ? !this.proxyType.equals(pType.proxyType) : pType.proxyType != null);
        }

        public int hashCode() {
            return this.proxyType.hashCode();
        }
    }
}

