/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgql.lang.spatial;

import java.io.Serializable;

public class Point3D
implements Serializable {
    private final double x;
    private final double y;
    private final double z;
    private final double m;

    public Point3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.m = Double.NaN;
    }

    public Point3D(double x, double y, double z, double m) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.m = m;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Point3D)) {
            return false;
        }
        Point3D point = (Point3D)o;
        if (Double.compare(point.getX(), this.x) != 0) {
            return false;
        }
        if (Double.compare(point.getY(), this.y) != 0) {
            return false;
        }
        if (Double.compare(point.getZ(), this.z) != 0) {
            return false;
        }
        return Double.compare(point.getM(), this.m) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.getX());
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.getY());
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.getZ());
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.getM());
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getM() {
        return this.m;
    }
}

