/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.saveactions;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import net.miginfocom.swing.MigLayout;
import oracle.ide.Ide;
import oracle.ide.ceditor.saveactions.AddActionsDialog;
import oracle.ide.ceditor.saveactions.Bundle;
import oracle.ide.ceditor.saveactions.SaveActionsOptions;
import oracle.ide.controller.IdeAction;
import oracle.ide.nulls.NullIcon;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.ceditor.saveactions.SaveActionDescription;
import oracle.javatools.ui.builders.BuiltList;
import oracle.javatools.ui.builders.ListBuilder;
import oracle.javatools.util.StringUtil;

public class SaveActionsOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private List<SaveActionDescription> beforeSaveActions;
    private List<SaveActionDescription> afterSaveActions;
    private BuiltList<SaveActionDescription> beforeSaveBuildList;
    private BuiltList<SaveActionDescription> afterSaveBuildList;

    public SaveActionsOptionsPanel() {
        this.setHelpID("f1_idedidesetsaveactions_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    private static SaveActionsOptions getSaveOptions(TraversableContext tc) {
        return SaveActionsOptions.getInstance(tc.getPropertyStorage());
    }

    public void onEntry(TraversableContext tc) {
        this.loadSettingsFrom(SaveActionsOptionsPanel.getSaveOptions(tc));
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        this.saveSettingsTo(SaveActionsOptionsPanel.getSaveOptions(tc));
    }

    public void apply(ApplyEvent event) {
        TraversableContext tc = (TraversableContext)event.getSource();
        SaveActionsOptions options = SaveActionsOptionsPanel.getSaveOptions(tc);
        SaveActionsOptionsPanel.applyOptions(options);
    }

    public void cancel(ApplyEvent e) {
    }

    public static void applyOptions(SaveActionsOptions options) {
    }

    void loadSettingsFrom(SaveActionsOptions options) {
        this.beforeSaveActions.clear();
        this.afterSaveActions.clear();
        List<SaveActionDescription> allActions = options.getExecutableSaveActions();
        for (SaveActionDescription action : allActions) {
            if (action.getExecuteBeforeSave()) {
                this.beforeSaveActions.add(action);
                continue;
            }
            this.afterSaveActions.add(action);
        }
    }

    void saveSettingsTo(SaveActionsOptions options) throws TraversalException {
        ArrayList<SaveActionDescription> allActions = new ArrayList<SaveActionDescription>();
        allActions.addAll(this.beforeSaveActions);
        allActions.addAll(this.afterSaveActions);
        options.setExecutableSaveActions(allActions);
    }

    private void initializeComponent() {
        this.setLayout((LayoutManager)new MigLayout("ins 0, fill, flowy"));
        JTextArea label = new JTextArea(Bundle.get("SAVE_ACTIONS_DESCRIPTION"));
        label.setEditable(false);
        label.setLineWrap(true);
        label.setWrapStyleWord(true);
        label.setBorder(null);
        this.add(label, "growx, width 10:700, north, gapbottom 16");
        ListBuilder beforeSaveBuilder = new ListBuilder();
        beforeSaveBuilder.setLabel(Bundle.get("SAVE_ACTIONS_OPTIONS_TEXT"));
        beforeSaveBuilder.setEmptyTextLarge(Bundle.get("SAVE_ACTIONS_EMPTY_LIST"));
        beforeSaveBuilder.setRenderer((ListCellRenderer)new ActionRenderer());
        beforeSaveBuilder.setReorderable(true);
        beforeSaveBuilder.setRollover(true);
        beforeSaveBuilder.setActionsDefault(ListBuilder.DefaultAction.ADD, e -> {
            List<SaveActionDescription> otherBeforeSaveActions = SaveActionsOptions.getMissingActions(this.beforeSaveActions, true);
            AddActionsDialog addDialog = new AddActionsDialog(this.beforeSaveActions, otherBeforeSaveActions);
            if (addDialog.runDialog()) {
                this.beforeSaveActions.addAll(addDialog.getSelectedActions());
            }
        });
        beforeSaveBuilder.setActionsDefault(ListBuilder.DefaultAction.REMOVE, e -> this.beforeSaveActions.removeAll(this.beforeSaveBuildList.getSelectedValues()));
        this.beforeSaveBuildList = beforeSaveBuilder.build();
        this.beforeSaveActions = this.beforeSaveBuildList.getListModel();
        this.add(this.beforeSaveBuildList.getGUI(), "grow");
        ListBuilder afterSaveBuilder = new ListBuilder();
        afterSaveBuilder.setLabel(Bundle.get("AFTER_SAVE_ACTIONS_OPTIONS_TEXT"));
        afterSaveBuilder.setEmptyTextLarge(Bundle.get("AFTER_SAVE_ACTIONS_EMPTY_LIST"));
        afterSaveBuilder.setRenderer((ListCellRenderer)new ActionRenderer());
        afterSaveBuilder.setRollover(true);
        afterSaveBuilder.setActionsDefault(ListBuilder.DefaultAction.ADD, e -> {
            List<SaveActionDescription> otherAfterSaveActions = SaveActionsOptions.getMissingActions(this.afterSaveActions, false);
            AddActionsDialog addDialog = new AddActionsDialog(this.afterSaveActions, otherAfterSaveActions);
            if (addDialog.runDialog()) {
                this.afterSaveActions.addAll(addDialog.getSelectedActions());
            }
        });
        afterSaveBuilder.setActionsDefault(ListBuilder.DefaultAction.REMOVE, e -> this.afterSaveActions.removeAll(this.afterSaveBuildList.getSelectedValues()));
        this.afterSaveBuildList = afterSaveBuilder.build();
        this.afterSaveActions = this.afterSaveBuildList.getListModel();
        this.add(this.afterSaveBuildList.getGUI(), "grow");
    }

    static class ActionRenderer
    extends DefaultListCellRenderer {
        private static Icon NULL_ICON = new NullIcon();

        ActionRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel c = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof SaveActionDescription) {
                SaveActionDescription action = (SaveActionDescription)value;
                Integer id = Ide.findCmdID((String)action.getId());
                IdeAction ideAction = null;
                if (id != null) {
                    ideAction = IdeAction.find((int)id);
                }
                Icon icon = ideAction == null ? NULL_ICON : (Icon)ideAction.getValue("SmallIcon");
                c.setIcon(icon);
                String text = ideAction == null ? action.getId() : StringUtil.textWithoutMnemonic((Action)ideAction);
                c.setText(text);
            }
            return c;
        }
    }
}

