/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.controls.WaitCursor;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.cache.StatusCache;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdeveloper.vcs.util.VCSCommandUtils;
import oracle.jdeveloper.vcs.util.VCSIgnoreFilters;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdevimpl.vcs.generic.util.PatternURLFilter;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.op.SVNOperationCommit;
import oracle.jdevimpl.vcs.svn.prefs.SVNEnvironmentPrefs;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public final class SVNOperationCommitWC
extends SVNOperationCommit {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.commit-workingcopy";

    public SVNOperationCommitWC() {
        super(COMMAND_ID);
    }

    @Override
    protected void invokeCommit(VCSProfile profile, CommandState state, Map options, IndeterminateProgressMonitor progress) throws Exception {
        URL workingCopyRoot = this.getOperands(profile)[0].getURL();
        if (workingCopyRoot == null) {
            return;
        }
        this.autoAddNewFiles(profile, workingCopyRoot);
        super.invokeCommit(profile, state, options, progress);
    }

    @Override
    protected Locatable[] getOperands(VCSProfile profile) throws Exception {
        Locatable[] items = super.getOperands(profile);
        if (this.getContext().getView() instanceof ChangeListWindow && (items == null || items.length == 0)) {
            items = VCSModelUtils.getValidLocatables((Object[])((ChangeListWindow)this.getContext().getView()).getChangeList().getElements(), null);
        }
        for (int i = 0; i < items.length; ++i) {
            URL workingCopyRoot = SVNUtil.resolveWorkingCopy(items[i].getURL());
            if (workingCopyRoot == null) continue;
            return VCSModelUtils.findOrCreateNodes((URL[])new URL[]{workingCopyRoot});
        }
        return new Locatable[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean saveDirtyNodes(Locatable[] contextLocatables) throws Exception {
        Collection toSave;
        URLFilter filter = this.getProfile().getURLFilter("oracle.jdeveloper.vcs.filters.url.DEFAULT");
        final WaitCursor wc = new WaitCursor((Component)Ide.getMainWindow());
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                wc.show(1000);
            }
        });
        try {
            toSave = VCSCommandUtils.getDirtyNodesFrom((URLFilter)filter, (Locatable[])contextLocatables);
        }
        catch (Throwable throwable) {
            EventQueue.invokeLater(new Runnable(){
                final /* synthetic */ WaitCursor val$wc;
                {
                    this.val$wc = waitCursor;
                }

                @Override
                public void run() {
                    this.val$wc.hide();
                }
            });
            throw throwable;
        }
        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
        return VCSCommandUtils.saveDirtyNodes((Locatable[])toSave.toArray(new Locatable[toSave.size()]));
    }

    @Override
    protected String getOperation() {
        return Resource.get("OP_COMMIT_WC");
    }

    @Override
    protected Collection<URL> getStructureChangeDirectories(Locatable[] locatables) {
        ArrayList<URL> dirUrls = new ArrayList<URL>();
        ArrayList<URL> structureURLs = new ArrayList<URL>();
        for (final Locatable locatable : locatables) {
            Collection<URL> dUrls = SVNURLInfoCache.getInstance().getUrls(new URLFilter(){

                public boolean accept(URL url) {
                    return URLFileSystem.isDirectoryPath((URL)url) && URLFileSystem.isBaseURLFor((URL)locatable.getURL(), (URL)url);
                }
            });
            dirUrls.addAll(dUrls);
        }
        for (URL url : dirUrls) {
            try {
                if (SVNStatusType.STATUS_DELETED != SVNURLInfoCache.getInstance().getTextStatus(url)) continue;
                structureURLs.add(url);
            }
            catch (SVNException sVNException) {
            }
            catch (IOException iOException) {}
        }
        return structureURLs;
    }

    @Override
    protected boolean requiresModifiedRegularFile() {
        return false;
    }

    protected void autoAddNewFiles(VCSProfile profile, URL workingCopyRoot) throws Exception {
        boolean autoAdd = SVNEnvironmentPrefs.getInstance((PropertyStorage)Preferences.getPreferences()).getAutoAddFiles();
        if (!autoAdd) {
            return;
        }
        LinkedHashSet directories = new LinkedHashSet();
        LinkedHashSet files = new LinkedHashSet();
        this.findNewFilesDirs(profile, workingCopyRoot, directories, files);
        this.silentlyAddNewFiles(directories, files);
    }

    protected void findNewFilesDirs(VCSProfile profile, URL directory, HashSet directories, HashSet files) throws Exception {
        VCSStatusFilter unaddedFilter = profile.getStatusFilter("oracle.jdeveloper.subversion.filter.status.UNADDED");
        VCSStatusFilter ignoredFilter = profile.getStatusFilter("oracle.jdeveloper.subversion.filter.status.IGNORED");
        StatusCache cache = profile.getPolicyStatusCache();
        PatternURLFilter patternFilter = new PatternURLFilter(VCSIgnoreFilters.getAllIgnoreFilters());
        URL[] children = URLFileSystem.list((URL)directory, (URLFilter)patternFilter);
        for (int i = 0; i < children.length; ++i) {
            if (unaddedFilter.accept((VCSStatus)cache.get(children[i])) && !ignoredFilter.accept((VCSStatus)cache.get(children[i]))) {
                if (URLFileSystem.isDirectoryPath((URL)children[i])) {
                    directories.add(children[i]);
                    this.findNewFilesDirs(profile, children[i], directories, files);
                    continue;
                }
                files.add(children[i]);
                continue;
            }
            if (!URLFileSystem.isDirectoryPath((URL)children[i])) continue;
            this.findNewFilesDirs(profile, children[i], directories, files);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void silentlyAddNewFiles(Set directories, Set files) {
        try {
            ISVNClientAdapter svnClient = SVNUtil.getIDEClientAdapter();
            SVNOperationLogger.getInstance().beginOperation(svnClient, null);
            for (URL directory : directories) {
                svnClient.addDirectory(new File(URLFileSystem.getPlatformPathName((URL)directory)), false);
            }
            for (URL file : files) {
                svnClient.addFile(new File(URLFileSystem.getPlatformPathName((URL)file)));
            }
        }
        catch (SVNClientException ex) {
            SVNProfile.getQualifiedLogger(((Object)((Object)this)).getClass().getName()).warning(ex.getMessage());
        }
        finally {
            SVNOperationLogger.getInstance().endOperation();
        }
    }
}

