/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.nav.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import oracle.jdevimpl.vcs.svn.SVNExceptionWrapper;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNAuthInfo;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.res.Resource;
import oracle.jdevimpl.vcs.svn.util.ProtocolMatcher;
import oracle.jdevimpl.vcs.svn.util.SVNLogHandler;
import oracle.jdevimpl.vcs.svn.util.SVNRepositoryInfoValidator;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class ConnectionPanel
extends JPanel {
    private JLabel _urlLabel;
    private JTextField _urlField;
    private JLabel _nameLabel;
    private JTextField _nameField;
    private JLabel _userNameLabel;
    private JTextField _userNameField;
    private JLabel _passwordLabel;
    private JPasswordField _passwordField;
    private JButton _testButton;
    private JCheckBox _rememberPwdCheckbox;
    private JLabel _statusLabel;
    private JTextArea _statusArea;
    private JScrollPane _scrollPane;
    private final Collection _listeners = new ArrayList(5);
    private final ProtocolMatcher _protocolMatcher = new ProtocolMatcher();
    private boolean _hasTestArea = true;

    public ConnectionPanel(boolean hasTestArea) {
        super(new GridBagLayout());
        this._hasTestArea = hasTestArea;
        this.createComponents();
        this.layoutComponents();
        this.initComponentListeners();
    }

    public ConnectionPanel() {
        super(new GridBagLayout());
        this.createComponents();
        this.layoutComponents();
        this.initComponentListeners();
    }

    public void addListener(Listener listener) {
        this._listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this._listeners.remove(listener);
    }

    public void setRepositoryInfo(SVNRepositoryInfo reposInfo) {
        boolean goodUrl = true;
        if (reposInfo == null) {
            goodUrl = false;
            this.setRepositoryName("");
            this.setUserName("");
            this._passwordField.setText("");
            this._rememberPwdCheckbox.setSelected(false);
            this._testButton.setEnabled(false);
            this._statusArea.setText("");
        } else {
            String url = reposInfo.getURL().toString();
            String alias = reposInfo.getAlias();
            this.setURL(url);
            this.setRepositoryName(alias == null || alias.equals("") ? url : alias);
            SVNAuthInfo authInfo = reposInfo.getAuthInfo();
            if (authInfo != null) {
                this.setUserName(authInfo.getUserName());
                char[] c = authInfo.getPassword();
                String s = new String(c);
                this._passwordField.setText(s);
                s = null;
            }
            this._testButton.setEnabled(true);
            this._statusArea.setText("");
        }
        this.fireContainsUrl(goodUrl);
    }

    public void setURL(String urlString) {
        this._urlField.setText(urlString);
        this.updateBasedOnProtocol();
    }

    public String getUrl() {
        return this._urlField.getText().trim();
    }

    public void setRepositoryName(String name) {
        this._nameField.setText(name);
    }

    public String getRepositoryName() {
        if (this._nameField.getText() == null || this._nameField.getText().trim().equals("")) {
            return this.getUrl();
        }
        return this._nameField.getText().trim();
    }

    public void setUserName(String username) {
        this._userNameField.setText(username);
    }

    public String getUserName() {
        return this._userNameField.getText().trim();
    }

    public SVNRepositoryInfo createRepositoryInfo() throws MalformedURLException {
        String username = this._userNameField.getText();
        SVNAuthInfo authInfo = username != null ? new SVNAuthInfo(username, this._passwordField.getPassword()) : null;
        return new SVNRepositoryInfo(new SVNUrl(this.getUrl()), this.getRepositoryName(), authInfo);
    }

    private void createComponents() {
        this._urlLabel = new JLabel();
        this._urlField = new JTextField();
        ResourceUtils.resLabel((JLabel)this._urlLabel, (Component)this._urlField, (String)Resource.get("NAV_CONNECTION_WIZARD_URL"));
        this._nameLabel = new JLabel();
        this._nameField = new JTextField();
        ResourceUtils.resLabel((JLabel)this._nameLabel, (Component)this._nameField, (String)Resource.get("NAV_CONNECTION_WIZARD_NAME"));
        this._userNameLabel = new JLabel();
        this._userNameField = new JTextField();
        ResourceUtils.resLabel((JLabel)this._userNameLabel, (Component)this._userNameField, (String)Resource.get("NAV_CONNECTION_WIZARD_USER"));
        this._passwordLabel = new JLabel();
        this._passwordField = new JPasswordField();
        ResourceUtils.resLabel((JLabel)this._passwordLabel, (Component)this._passwordField, (String)Resource.get("NAV_CONNECTION_WIZARD_PASSWORD"));
        this._testButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this._testButton, (String)Resource.get("NAV_CONNECTION_WIZARD_TEST"));
        this._rememberPwdCheckbox = new JCheckBox();
        this._rememberPwdCheckbox.setSelected(false);
        ResourceUtils.resButton((AbstractButton)this._rememberPwdCheckbox, (String)Resource.get("NAV_CONNECTION_WIZARD_REMEMBER"));
        this._statusLabel = new JLabel();
        this._statusArea = new JTextArea();
        this._statusArea.setEditable(false);
        this._statusArea.setLineWrap(true);
        this._statusArea.setWrapStyleWord(true);
        this._statusArea.setRows(4);
        this._scrollPane = new JScrollPane(this._statusArea);
        ResourceUtils.resLabel((JLabel)this._statusLabel, (Component)this._statusArea, (String)Resource.get("NAV_CONNECTION_WIZARD_STATUS"));
    }

    private void layoutComponents() {
        Insets lblIns = new Insets(2, 5, 3, 5);
        Insets fldIns = new Insets(0, 5, 5, 5);
        Insets tstIns = new Insets(5, 5, 5, 5);
        this.add((Component)this._urlLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, lblIns, 0, 0));
        this.add((Component)this._urlField, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, fldIns, 0, 0));
        this.add((Component)this._nameLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, lblIns, 0, 0));
        this.add((Component)this._nameField, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 2, fldIns, 0, 0));
        this.add((Component)this._userNameLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, lblIns, 0, 0));
        this.add((Component)this._userNameField, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 17, 2, fldIns, 0, 0));
        this.add((Component)this._passwordLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, lblIns, 0, 0));
        this.add((Component)this._passwordField, new GridBagConstraints(0, 7, 2, 1, 1.0, 0.0, 17, 2, fldIns, 0, 0));
        if (this._hasTestArea) {
            this.add((Component)this._testButton, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, tstIns, 0, 0));
            this.add((Component)this._statusLabel, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 0, tstIns, 0, 0));
            this.add((Component)this._scrollPane, new GridBagConstraints(0, 10, 2, 3, 1.0, 1.0, 17, 1, fldIns, 350, 0));
        }
    }

    private void initComponentListeners() {
        LocationDocumentListener ldl = new LocationDocumentListener();
        this._urlField.getDocument().addDocumentListener(ldl);
        this._nameField.getDocument().addDocumentListener(ldl);
        this._userNameField.getDocument().addDocumentListener(ldl);
        this._passwordField.getDocument().addDocumentListener(ldl);
        this._testButton.addActionListener(new ConnectionTester());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireContainsUrl(boolean containsUrl) {
        Collection collection = this._listeners;
        synchronized (collection) {
            Iterator it = this._listeners.iterator();
            while (it.hasNext()) {
                ((Listener)it.next()).setContainsURL(containsUrl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTestHasBegun() {
        Collection collection = this._listeners;
        synchronized (collection) {
            Iterator it = this._listeners.iterator();
            while (it.hasNext()) {
                ((Listener)it.next()).testHasBegun();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTestHasFinished() {
        Collection collection = this._listeners;
        synchronized (collection) {
            Iterator it = this._listeners.iterator();
            while (it.hasNext()) {
                ((Listener)it.next()).testHasFinished();
            }
        }
    }

    public void cleanupInteraction() {
        SVNClientInteraction.getInstance().endInteraction();
    }

    private void updateBasedOnProtocol() {
        this._protocolMatcher.setSource(this.getUrl());
        boolean goodProtocol = this._protocolMatcher.containsProtocol();
        this._testButton.setEnabled(goodProtocol);
        this.fireContainsUrl(goodProtocol);
    }

    private final class LocationDocumentListener
    implements DocumentListener {
        private LocationDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ConnectionPanel.this.updateBasedOnProtocol();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ConnectionPanel.this.updateBasedOnProtocol();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ConnectionPanel.this.updateBasedOnProtocol();
        }
    }

    private final class ConnectionTester
    implements ActionListener {
        private ConnectionTester() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                SVNRepositoryInfo reposInfo = ConnectionPanel.this.createRepositoryInfo();
                ConnectionPanel.this._statusArea.setText("");
                ConnectionPanel.this._statusArea.append(Resource.format("NAV_CONNECTION_WIZARD_TEST_TESTING", reposInfo.getURL()));
                ConnectionPanel.this._statusArea.append("\n");
                SVNRepositoryInfoValidator validator = new SVNRepositoryInfoValidator(reposInfo, SVNUtil.getWCClient(reposInfo), new TextAreaNotificationHandler());
                ConnectionTesterThread t = new ConnectionTesterThread(validator);
                ConnectionPanel.this._testButton.setEnabled(false);
                t.start();
                ConnectionPanel.this.fireTestHasBegun();
            }
            catch (MalformedURLException mfue) {
                SVNProfile.getQualifiedLogger(this.getClass().getName()).warning(mfue.getMessage());
                MessageDialog.error((Component)ConnectionPanel.this, (Object)Resource.format("NAV_CONNECTION_WIZARD_TEST_BAD_URL", ConnectionPanel.this.getUrl()), (String)Resource.get("NAV_CONNECTION_WIZARD_TEST_ERROR"), null);
                ConnectionPanel.this.fireContainsUrl(false);
                return;
            }
        }
    }

    public static interface Listener {
        public void setContainsURL(boolean var1);

        public void testHasBegun();

        public void testHasFinished();
    }

    private final class TextAreaNotificationHandler
    implements SVNLogHandler {
        private TextAreaNotificationHandler() {
        }

        @Override
        public void writeMessage(String msg) {
            this.appendLater(msg);
        }

        private void appendLater(final String message) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConnectionPanel.this._statusArea.append(SVNExceptionWrapper.wrapAuthMsg(message));
                    ConnectionPanel.this._statusArea.append("\n");
                }
            });
        }
    }

    private final class ConnectionTesterThread
    extends Thread {
        private final SVNRepositoryInfoValidator _validator;

        private ConnectionTesterThread(SVNRepositoryInfoValidator validator) {
            this._validator = validator;
        }

        @Override
        public void run() {
            final boolean[] success = new boolean[1];
            final boolean[] timeout = new boolean[1];
            try {
                success[0] = this._validator.validate();
            }
            catch (SVNRepositoryInfoValidator.TimeoutException te) {
                timeout[0] = true;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConnectionPanel.this._statusArea.append(success[0] ? Resource.get("NAV_CONNECTION_WIZARD_TEST_SUCCESS") : Resource.get("NAV_CONNECTION_WIZARD_TEST_FAILED"));
                    ConnectionPanel.this._statusArea.append("\n");
                    if (timeout[0]) {
                        ConnectionPanel.this._statusArea.append(Resource.get("CONNECTION_TEST_TIMEOUT"));
                        ConnectionPanel.this._statusArea.append("\n");
                    }
                    if (!success[0]) {
                        ConnectionPanel.this._statusArea.append(Resource.get("CONNECTION_TEST_ERROR"));
                        ConnectionPanel.this._statusArea.append("\n");
                    }
                    ConnectionPanel.this._testButton.setEnabled(true);
                    ConnectionPanel.this.fireTestHasFinished();
                }
            });
        }
    }
}

