/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.memwatch;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import oracle.ide.Addin;
import oracle.ideimpl.memwatch.LowMemoryHandler;

public final class LowMemoryDetector
implements Addin {
    private static final long K = 0x100000L;
    private static final long HEAP_MEM_WARN_ON_MAX_DELTA = 0x3200000L;
    static final boolean DEBUG = System.getProperty("LowMemoryDetector.DEBUG") != null;

    @Override
    public void initialize() {
        NotificationEmitter notificationEmitter = (NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean());
        notificationEmitter.addNotificationListener(new NotificationListenerImpl(), null, null);
        LowMemoryDetector.setHeapMemoryPoolMXBeanUsageThreshold(true);
    }

    private static void setHeapMemoryPoolMXBeanUsageThreshold(boolean activate) {
        long halfWarningSize = 0x1900000L;
        for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            long usageThreshhold;
            if (DEBUG) {
                System.out.println("Looking at memoryPoolMXBean of type " + memoryPoolMXBean.getType());
            }
            if (memoryPoolMXBean.getType() != MemoryType.HEAP) continue;
            if (DEBUG) {
                System.out.println("memoryPoolMXBean.getName() = " + memoryPoolMXBean.getName());
                System.out.println("memoryPoolMXBean.isUsageThresholdSupported() = " + memoryPoolMXBean.isUsageThresholdSupported());
                System.out.println("memoryPoolMXBean.isCollectionUsageThresholdSupported() = " + memoryPoolMXBean.isCollectionUsageThresholdSupported());
                System.out.println("memoryPoolMXBean.getUsage().getMax() = " + memoryPoolMXBean.getUsage().getMax());
            }
            if (DEBUG) {
                System.out.println("memoryPoolMXBean.isCollectionUsageThresholdSupported() = " + memoryPoolMXBean.isCollectionUsageThresholdSupported());
            }
            if (!memoryPoolMXBean.isCollectionUsageThresholdSupported()) continue;
            if (!activate) {
                if (DEBUG) {
                    System.out.println("Not activating, setting usageThreshold to 0");
                }
                usageThreshhold = 0L;
            } else {
                long max = memoryPoolMXBean.getUsage().getMax();
                if (max > 0x3200000L) {
                    if (DEBUG) {
                        System.out.println("Setting usageThreshold to " + (max - 0x1900000L));
                    }
                    usageThreshhold = max - 0x1900000L;
                } else {
                    if (!DEBUG) continue;
                    System.out.println("Not setting usageThreshold, max (" + max + ") <= 52428800");
                    continue;
                }
            }
            memoryPoolMXBean.setCollectionUsageThreshold(usageThreshhold);
        }
    }

    private final class NotificationListenerImpl
    implements NotificationListener {
        private NotificationListenerImpl() {
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            if (DEBUG) {
                for (int i = 0; i < 5; ++i) {
                    System.out.println("***************************************************");
                }
                System.out.println("NotificationListenerImpl.handleNotification called, " + notification.getType());
            }
            if (notification.getType().equals("java.management.memory.collection.threshold.exceeded")) {
                MemoryNotificationInfo memoryNotificationInfo = MemoryNotificationInfo.from((CompositeData)notification.getUserData());
                if (DEBUG) {
                    System.out.println("  notification.getType().equals(MemoryNotificationInfo.MEMORY_COLLECTION_THRESHOLD_EXCEEDED)");
                    System.out.println("  memoryNotificationInfo.getPoolName() = " + memoryNotificationInfo.getPoolName());
                }
                MemoryUsage memoryUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
                if (DEBUG) {
                    System.out.println("  memoryUsage.getMax() = " + memoryUsage.getMax());
                    System.out.println("  memoryUsage.getUsed() = " + memoryUsage.getUsed());
                    System.out.println("  memoryUsage.getMax() - memoryUsage.getUsed() = " + (memoryUsage.getMax() - memoryUsage.getUsed()) / 0x100000L);
                }
                if (memoryUsage.getMax() - memoryUsage.getUsed() <= 0x3200000L) {
                    if (DEBUG) {
                        System.out.println("Calling LowMemoryHandler");
                    }
                    LowMemoryDetector.setHeapMemoryPoolMXBeanUsageThreshold(false);
                    LowMemoryHandler.handleLowMemory(0, memoryUsage.getUsed() / 0x100000L, memoryUsage.getMax() / 0x100000L);
                } else if (DEBUG) {
                    System.out.println("LowMemoryHandler not called, memoryUsage.getMax() (" + memoryUsage.getMax() + ") - memoryUsage.getUsed() (" + memoryUsage.getUsed() + ") > HEAP_MEM_WARN_ON_MAX_DELTA (52428800)");
                }
            }
        }
    }
}

