/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controller;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionHook;
import javax.ide.util.MetaClass;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.controller.ContextAwareLabelUpdater;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.TriggerController;
import oracle.ide.extension.feature.Feature;
import oracle.ide.extension.feature.FeatureRegistry;
import oracle.ide.extension.rules.RuleEngine;
import oracle.ideimpl.controller.MetaClassController;
import oracle.ideimpl.extension.IDEExtension;
import oracle.ideimpl.extension.LayerRegistrationHook;
import org.openide.util.Lookup;

public class ControllersHook
extends ExtensionHook
implements LayerRegistrationHook {
    public static final ElementName ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "controllers");
    private static final String ACTION_TO_CONTROLLERS_MAP_KEY = ControllersHook.class.getName() + ".action-map";
    private final ControllerElementVisitor _controllerVisitor = new ControllerElementVisitor();
    private final Map<String, Set<Controller>> _actionToControllersMap = new HashMap<String, Set<Controller>>();
    private static boolean _loadingStandardHooks;
    private static final boolean DEBUG_RULES_BASED_CONTROLLERS;
    private static final Logger LOG;
    private LayerRegistrationHook.LogSupport logSupport;
    private IDEExtension extension;

    @Override
    public Class<? extends Annotation> getAnnotationClass() {
        return Controllers.class;
    }

    @Override
    public void register(Lookup lookup) {
        this.logSupport = (LayerRegistrationHook.LogSupport)lookup.lookup(LayerRegistrationHook.LogSupport.class);
        RuleEngine engine = RuleEngine.getInstance();
        Controllers cntrls = (Controllers)lookup.lookup(Controllers.class);
        this.extension = (IDEExtension)((Object)lookup.lookup(IDEExtension.class));
        for (Controllers.Controller c : cntrls.controllers()) {
            Controllers.UpdateRule ur;
            String ruleId;
            boolean valid;
            String clazz = c.className();
            if (clazz == null || (clazz = clazz.trim()).length() == 0) {
                LOG.log(Level.SEVERE, "Missing required attribute [class].");
                break;
            }
            ClassLoader classLoader = ExtensionRegistry.getExtensionRegistry().getClassLoader(this.extension.getID());
            if (classLoader == null) {
                LOG.log(Level.SEVERE, "Failed to find classloader for extension " + this.extension.getID() + "; controller registration failed");
                break;
            }
            MetaClass mc = new MetaClass(ExtensionRegistry.getExtensionRegistry().getClassLoader(this.extension.getID()), clazz);
            Controllers.UpdateRule[] updateRuleArray = c.updateRules();
            int n = updateRuleArray.length;
            for (int i = 0; i < n && (valid = engine.validateRuleReference(ruleId = (ur = updateRuleArray[i]).rule(), null, LOG)); ++i) {
                this.registerActions(ur.actions(), this.extension.getID(), ruleId, mc);
            }
        }
    }

    private void registerActions(Controllers.Action[] actions, String extensionId, String ruleId, MetaClass mc) {
        RuleBasedController sharedController = new RuleBasedController(mc, extensionId, _loadingStandardHooks, ruleId);
        for (Controllers.Action a : actions) {
            ContextAwareLabelUpdater labelUpdater;
            if (!this._actionToControllersMap.containsKey(a.id())) {
                this._actionToControllersMap.put(a.id(), new LinkedHashSet());
            }
            if ((labelUpdater = this.getLabelUpdater(a, extensionId)) == null) {
                this._actionToControllersMap.get(a.id()).add(sharedController);
            } else {
                RuleBasedController separateController = new RuleBasedController(mc, extensionId, _loadingStandardHooks, ruleId);
                separateController.setLabelUpdater(labelUpdater);
                this._actionToControllersMap.get(a.id()).add(separateController);
            }
            IdeAction action = IdeAction.find(a.id());
            if (action == null) continue;
            this.attachControllersToAction(action);
        }
    }

    private ContextAwareLabelUpdater getLabelUpdater(Controllers.Action action, String extensionId) {
        String labelVal = this.sanitizeLabel(action);
        String labelParam = this.sanitizeLabelParam(action);
        if (labelVal != null) {
            String labelFmt = null;
            if (labelParam != null) {
                try {
                    String format = labelVal.replace("{0}", "%s");
                    labelFmt = String.format(format, labelParam);
                    if (labelVal.equals(labelFmt)) {
                        LOG.log(Level.WARNING, extensionId + ": When using [label-param], the value for [label] must be a formatted string, like: 'Perform action on {0}'. '" + labelVal + "' is not valid.");
                    }
                }
                catch (Exception e) {
                    labelFmt = labelVal;
                    LOG.log(Level.SEVERE, extensionId + ": When using [label-param], the value for [label] must be a formatted string, like: 'Perform action on {0}'. '" + labelVal + "' is not valid.");
                }
            } else {
                labelFmt = labelVal;
                if (ContextAwareLabelUpdater.containsMacro(labelFmt)) {
                    LOG.log(Level.WARNING, "The value supplied for [label] contains macros, but no label-param value was supplied.");
                }
            }
            ContextAwareLabelUpdater labelUpdater = new ContextAwareLabelUpdater();
            labelUpdater.setEnabledFormat(labelFmt);
            labelUpdater.setDisabledFormat(labelFmt);
            return labelUpdater;
        }
        if (labelParam != null) {
            LOG.log(Level.WARNING, "The [label-param] cannot be used without [label].");
        }
        return null;
    }

    public String sanitizeLabel(Controllers.Action a) {
        String label = a.label().trim();
        if (!label.isEmpty()) {
            return label;
        }
        return null;
    }

    public String sanitizeLabelParam(Controllers.Action a) {
        String macroKey = a.macroKey().trim();
        if (macroKey.isEmpty()) {
            macroKey = null;
        }
        if (macroKey != null) {
            if (!ContextAwareLabelUpdater.containsMacro(macroKey)) {
                LOG.log(Level.SEVERE, "Unsupported macro: " + macroKey + ".");
                return null;
            }
            return String.format("${%s}", macroKey);
        }
        String labelparam = a.labelParam().trim();
        if (!labelparam.isEmpty()) {
            return labelparam;
        }
        return null;
    }

    public void start(ElementStartContext context) {
        _loadingStandardHooks = this.isLoadingStandardHooks((ElementContext)context);
        context.registerChildVisitor(ControllerElementVisitor.ELEMENT, (ElementVisitor)this._controllerVisitor);
        context.getScopeData().put(ACTION_TO_CONTROLLERS_MAP_KEY, this._actionToControllersMap);
    }

    private boolean isLoadingStandardHooks(ElementContext context) {
        IDEExtension.State state = ((IDEExtension)this.getExtension(context)).getState();
        return IDEExtension.State.HOOKS_LOADING == state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(ElementEndContext context) {
        HashSet<String> actionIds;
        super.end(context);
        ControllersHook controllersHook = this;
        synchronized (controllersHook) {
            actionIds = new HashSet<String>(this._actionToControllersMap.keySet());
        }
        for (String actionId : actionIds) {
            IdeAction action = IdeAction.find(actionId);
            if (action == null) continue;
            this.attachControllersToAction(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachControllersToAction(IdeAction action) {
        Set<Controller> set;
        String command = Ide.findCmdName(action.getCommandId());
        ControllersHook controllersHook = this;
        synchronized (controllersHook) {
            if (!this.hasUnmappedControllers() || !this._actionToControllersMap.containsKey(command)) {
                return;
            }
            set = this._actionToControllersMap.remove(command);
        }
        for (Controller c : set) {
            action.addController(c);
        }
    }

    private boolean hasUnmappedControllers() {
        return !this._actionToControllersMap.isEmpty();
    }

    static {
        DEBUG_RULES_BASED_CONTROLLERS = Boolean.getBoolean("ide.RuleBasedControllers.debug");
        LOG = Logger.getLogger(Controllers.class.getName());
    }

    private static class ControllerElementVisitor
    extends ElementVisitor {
        public static final ElementName ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "controller");
        protected static final String CLASS_ATTR = "class";
        protected static final String CLASS_KEY = ControllerElementVisitor.class.getName() + ".class";
        private final UpdateRulesElementVisitor _updateRulesVisitor = new UpdateRulesElementVisitor();

        private ControllerElementVisitor() {
        }

        public void start(ElementStartContext context) {
            context.getScopeData().remove(CLASS_KEY);
            String clazz = context.getAttributeValue(CLASS_ATTR);
            if (clazz == null || (clazz = clazz.trim()).length() == 0) {
                this.log((ElementContext)context, Level.SEVERE, "Missing required attribute [class].");
                return;
            }
            MetaClass mc = new MetaClass(this.getMetaClassLoader((ElementContext)context), clazz);
            context.getScopeData().put(CLASS_KEY, mc);
            context.registerChildVisitor(UpdateRulesElementVisitor.ELEMENT, (ElementVisitor)this._updateRulesVisitor);
        }
    }

    public static @interface Controllers {
        @LayerRegistrationHook.Tag(value={"controller"})
        public Controller[] controllers() default {};

        public static @interface Action {
            @LayerRegistrationHook.Attr(value="id")
            public String id();

            @LayerRegistrationHook.Tag(value={"label"})
            public String label() default "";

            @LayerRegistrationHook.Tag(value={"label-param"})
            public String labelParam() default "";

            @LayerRegistrationHook.Attr(value="macroKey", tag={"label-param"})
            public String macroKey() default "";
        }

        public static @interface UpdateRule {
            @LayerRegistrationHook.Attr(value="rule")
            public String rule();

            @LayerRegistrationHook.Tag(value={"action"})
            public Action[] actions() default {};
        }

        public static @interface Controller {
            @LayerRegistrationHook.Attr(value="class")
            public String className();

            @LayerRegistrationHook.Tag(value={"update-rules", "update-rule"})
            public UpdateRule[] updateRules() default {};
        }
    }

    private static final class RuleBasedController
    extends MetaClassController {
        private String _ruleId;
        private ContextAwareLabelUpdater _labelUpdater;

        public RuleBasedController(MetaClass metaClass, String owningExtId, boolean okToCallContollerUpdate, String ruleId) {
            super(metaClass, owningExtId, okToCallContollerUpdate);
            this._ruleId = ruleId;
        }

        @Override
        public boolean handleEventWhenExtensionNotInitialized(IdeAction action, Context context) {
            boolean canHandle = RuleEngine.getInstance().evaluateRule(this._ruleId, context);
            if (canHandle && !super.handleEventWhenExtensionNotInitialized(action, context)) {
                ExtensionRegistry.getExtensionRegistry().getLogger().severe(this.failureMessage(action));
                canHandle = false;
            }
            return canHandle;
        }

        private String failureMessage(IdeAction action) {
            StringBuilder b = new StringBuilder();
            b.append("Cannot handle action '");
            b.append(action.getValue("Name"));
            b.append("' (id=");
            b.append(action.getCommandId());
            b.append("). The rule evaluation succeeded, but the controller (");
            b.append(this.getMetaClass().getClassName());
            b.append(") returned false from its update method.\n");
            b.append("If the rule returns true, the controller is expected to also return true from its update method.");
            return b.toString();
        }

        @Override
        public boolean update(IdeAction action, Context context) {
            if (DEBUG_RULES_BASED_CONTROLLERS) {
                boolean memberIdeCore;
                ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
                FeatureRegistry featureRegistry = extensionRegistry.getFeatureRegistry();
                Feature feature = featureRegistry.getFeatureForExtension(this.getOwningExtId());
                boolean bl = memberIdeCore = feature != null && "ide-core".equals(feature.getId());
                if (!memberIdeCore && RuleEngine.getInstance().evaluateRule(this._ruleId, context)) {
                    String newline = "\n   ";
                    StringBuilder b = new StringBuilder();
                    b.append("\nDebugging controller for action: ").append(action.getValue("Name"));
                    b.append("\n   ").append("rule '").append(this._ruleId).append("' result = true");
                    boolean updateSuccess = this.getDelegate().update(action, context);
                    b.append("\n   ").append("Controller.update(..) result = ").append(updateSuccess).append(" for '").append(this.getDelegate()).append("'");
                    if (updateSuccess) {
                        if (!action.isEnabled() && !(this.getDelegate() instanceof TriggerController)) {
                            b.append(", but action is disabled and controller does not implement TriggerController.");
                            b.append("\n   ").append("The mismatch between rule and the action's enabled state could indicate a bug. ");
                            b.append("Try running without the command-line flag and invoking the action to verify.");
                            System.out.println(b.toString());
                        }
                    } else {
                        b.append("\n   ").append("The mismatch between rule and the value returned from Controller.update could indicate a bug. ");
                        b.append("Try running without the command-line flag and invoking the action to verify.");
                        System.out.println(b.toString());
                    }
                }
            }
            return super.update(action, context);
        }

        @Override
        public boolean updateWhenExtensionNotInitialized(IdeAction action, Context context) {
            boolean result = RuleEngine.getInstance().evaluateRule(this._ruleId, context);
            action.setEnabled(result);
            if (this._labelUpdater != null) {
                String newLabel;
                String origLabel = (String)action.getValue("oracle.id.IdeAction.NAME");
                if (origLabel == null) {
                    origLabel = (String)action.getValue("Name");
                    action.putValue("oracle.id.IdeAction.NAME", origLabel);
                }
                if ((newLabel = this._labelUpdater.labelWhenEnabled(context, action, origLabel)) != null) {
                    action.putValue("Name", StringUtils.stripMnemonic((String)newLabel));
                }
            }
            return result;
        }

        void setLabelUpdater(ContextAwareLabelUpdater labelUpdater) {
            this._labelUpdater = labelUpdater;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            if (obj instanceof RuleBasedController) {
                RuleBasedController other = (RuleBasedController)obj;
                return this._ruleId.equals(other._ruleId);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this._ruleId.hashCode();
        }

        @Override
        public String toString() {
            return super.toString() + "[" + this._ruleId.toString() + "]";
        }
    }

    private static final class ActionInfo {
        private final String _actionId;
        private String _label = null;
        private String _labelParam = null;
        private ContextAwareLabelUpdater _labelUpdater = null;

        public ActionInfo(String actionId) {
            this._actionId = actionId;
        }

        public String getActionId() {
            return this._actionId;
        }

        public String getLabel() {
            return this._label;
        }

        public void setLabel(String _label) {
            this._label = _label;
        }

        public String getLabelParam() {
            return this._labelParam;
        }

        public void setLabelParam(String _labelParam) {
            this._labelParam = _labelParam;
        }

        public ContextAwareLabelUpdater getLabelUpdater() {
            return this._labelUpdater;
        }

        public void setLabelUpdater(ContextAwareLabelUpdater _labelUpdater) {
            this._labelUpdater = _labelUpdater;
        }
    }

    public static final class LabelParamElementVisitor
    extends ElementVisitor {
        private String _macroKey;
        public static final ElementName LABEL_PARAM_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "label-param");

        public void start(ElementStartContext context) {
            this._macroKey = context.getAttributeValue("macroKey");
            if (this._macroKey != null) {
                this._macroKey = this._macroKey.trim();
                if (this._macroKey.isEmpty()) {
                    this._macroKey = null;
                    this.log((ElementContext)context, Level.WARNING, "If the macroKey attribute is used, the value should not be empty");
                }
            }
        }

        public void end(ElementEndContext context) {
            if (this._macroKey != null) {
                if (!ContextAwareLabelUpdater.containsMacro(this._macroKey)) {
                    this.log((ElementContext)context, Level.SEVERE, "Unsupported macro: " + this._macroKey + ".");
                    return;
                }
                ActionInfo actionInfo = (ActionInfo)context.getScopeData().get("action-info-key");
                String macro = String.format("${%s}", this._macroKey);
                actionInfo.setLabelParam(macro);
            } else {
                String labelparam = context.getText();
                if (labelparam != null && (labelparam = labelparam.trim()).isEmpty()) {
                    labelparam = null;
                }
                if (labelparam != null) {
                    ActionInfo actionInfo = (ActionInfo)context.getScopeData().get("action-info-key");
                    actionInfo.setLabelParam(labelparam);
                } else {
                    this.log((ElementContext)context, Level.SEVERE, "If the label-param element is used, the text content cannot be empty");
                }
            }
        }
    }

    public static final class LabelElementVisitor
    extends ElementVisitor {
        public static final ElementName LABEL_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "label");

        public void end(ElementEndContext context) {
            String label = context.getText();
            if (label != null && (label = label.trim()).isEmpty()) {
                label = null;
            }
            if (label != null) {
                ActionInfo actionInfo = (ActionInfo)context.getScopeData().get("action-info-key");
                actionInfo.setLabel(label);
            } else {
                this.log((ElementContext)context, Level.SEVERE, "If the label element is used, the text content cannot be empty");
            }
        }
    }

    private static class ActionElementVisitor
    extends ElementVisitor {
        public static final ElementName ACTION_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "action");
        public static final String ACTION_INFO_KEY = "action-info-key";
        private static final String _ID_ATTR_NAME = "id";
        private final LabelElementVisitor _labelElementVisitor = new LabelElementVisitor();
        private final LabelParamElementVisitor _labelParamElementVisitor = new LabelParamElementVisitor();

        private ActionElementVisitor() {
        }

        public void start(ElementStartContext context) {
            String id = this.getAttributeHelper(context, _ID_ATTR_NAME, true, true);
            if (id != null) {
                context.getScopeData().put(ACTION_INFO_KEY, new ActionInfo(id));
                context.registerChildVisitor(LabelElementVisitor.LABEL_ELEMENT, (ElementVisitor)this._labelElementVisitor);
                context.registerChildVisitor(LabelParamElementVisitor.LABEL_PARAM_ELEMENT, (ElementVisitor)this._labelParamElementVisitor);
            }
        }

        public void end(ElementEndContext context) {
            ActionInfo actionInfo = (ActionInfo)context.getScopeData().get(ACTION_INFO_KEY);
            if (actionInfo != null) {
                this.maybeCreateLabelUpdater((ElementContext)context, actionInfo);
                LinkedHashMap actionMap = (LinkedHashMap)context.getScopeData().get("key-action-info-map");
                actionMap.put(actionInfo.getActionId(), actionInfo);
            }
        }

        private void maybeCreateLabelUpdater(ElementContext context, ActionInfo actionInfo) {
            String labelVal = actionInfo.getLabel();
            String labelParam = actionInfo.getLabelParam();
            if (labelVal != null) {
                String labelFmt = null;
                if (labelParam != null) {
                    try {
                        String format = labelVal.replace("{0}", "%s");
                        labelFmt = String.format(format, labelParam);
                        if (labelVal.equals(labelFmt)) {
                            Extension ext = context.getExtension();
                            this.log(context, Level.SEVERE, (ext == null ? "Unknown extension" : ext.getID()) + "When using [label-param], the value for [label] must be a formatted string.");
                        }
                    }
                    catch (Exception e) {
                        labelFmt = labelVal;
                        Extension ext = context.getExtension();
                        this.log(context, Level.SEVERE, (ext == null ? "Unknown extension" : ext.getID()) + "When using [label-param], the value for [label] must be a formatted string.");
                    }
                } else {
                    labelFmt = labelVal;
                    if (ContextAwareLabelUpdater.containsMacro(labelFmt)) {
                        this.log(context, Level.WARNING, "The value supplied for [label] contains macros, but no label-param value was supplied.");
                    }
                }
                ContextAwareLabelUpdater labelUpdater = new ContextAwareLabelUpdater();
                labelUpdater.setEnabledFormat(labelFmt);
                labelUpdater.setDisabledFormat(labelFmt);
                actionInfo.setLabelUpdater(labelUpdater);
            } else if (labelParam != null) {
                this.log(context, Level.WARNING, "The [label-param] cannot be used without [label].");
            }
        }
    }

    private static class UpdateRuleElementVisitor
    extends ElementVisitor {
        public static final ElementName UPDATE_RULE_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "update-rule");
        public static final String ACTION_INFO_MAP_KEY = "key-action-info-map";
        private static final String _RULE_ATTR = "rule";
        private static final String _RULE_ID_KEY = "key-rule-id";
        private final ActionElementVisitor _actionVisitor = new ActionElementVisitor();

        private UpdateRuleElementVisitor() {
        }

        public void start(ElementStartContext context) {
            RuleEngine engine;
            boolean valid;
            String ruleId = this.getAttributeHelper(context, _RULE_ATTR, true, true);
            if (ruleId != null && (valid = (engine = RuleEngine.getInstance()).validateRuleReference(ruleId, (ElementContext)context))) {
                context.getScopeData().put(_RULE_ID_KEY, ruleId);
                LinkedHashMap actionMap = new LinkedHashMap();
                context.getScopeData().put(ACTION_INFO_MAP_KEY, actionMap);
                context.registerChildVisitor(ActionElementVisitor.ACTION_ELEMENT, (ElementVisitor)this._actionVisitor);
            }
        }

        public void end(ElementEndContext context) {
            LinkedHashMap actionMap = (LinkedHashMap)context.getScopeData().get(ACTION_INFO_MAP_KEY);
            if (actionMap == null) {
                return;
            }
            if (actionMap.isEmpty()) {
                this.log((ElementContext)context, Level.SEVERE, "update-rule requires one or more [action] child elements");
                return;
            }
            String ruleId = (String)context.getScopeData().get(_RULE_ID_KEY);
            MetaClass mc = (MetaClass)context.getScopeData().get(ControllerElementVisitor.CLASS_KEY);
            String extensionId = context.getExtension().getID();
            Map actionToControllersMap = (Map)context.getScopeData().get(ACTION_TO_CONTROLLERS_MAP_KEY);
            RuleBasedController sharedController = new RuleBasedController(mc, extensionId, _loadingStandardHooks, ruleId);
            for (ActionInfo actionInfo : actionMap.values()) {
                if (!actionToControllersMap.containsKey(actionInfo.getActionId())) {
                    actionToControllersMap.put(actionInfo.getActionId(), new LinkedHashSet());
                }
                if (actionInfo.getLabelUpdater() == null) {
                    ((Set)actionToControllersMap.get(actionInfo.getActionId())).add(sharedController);
                    continue;
                }
                RuleBasedController separateController = new RuleBasedController(mc, extensionId, _loadingStandardHooks, ruleId);
                separateController.setLabelUpdater(actionInfo.getLabelUpdater());
                ((Set)actionToControllersMap.get(actionInfo.getActionId())).add(separateController);
            }
        }
    }

    private static class UpdateRulesElementVisitor
    extends ElementVisitor {
        public static final ElementName ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "update-rules");
        private final UpdateRuleElementVisitor _updateRuleVisitor = new UpdateRuleElementVisitor();

        private UpdateRulesElementVisitor() {
        }

        public void start(ElementStartContext context) {
            super.start(context);
            context.registerChildVisitor(UpdateRuleElementVisitor.UPDATE_RULE_ELEMENT, (ElementVisitor)this._updateRuleVisitor);
        }
    }
}

