/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util.dnd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.ide.util.dnd.DragHelper;
import oracle.ide.util.dnd.DropHelper;

public class DragDropManager {
    private HashMap<Class, RegInfo> registry = new HashMap();
    private static DragDropManager instance;
    private static final Comparator<DropHelper> COMPARATOR;

    private DragDropManager() {
    }

    public static DragDropManager getInstance() {
        if (instance == null) {
            instance = new DragDropManager();
        }
        return instance;
    }

    public void registerDragHelperForInstance(DragHelper helper, Class supportedClass) {
        this.registerDragHelper(helper, supportedClass, false);
    }

    public void registerDragHelperForType(DragHelper helper, Class supportedClass) {
        this.registerDragHelper(helper, supportedClass, true);
    }

    public void unRegisterDragHelperForInstance(DragHelper helper, Class dragClass) {
        this.unRegisterDragHelper(helper, dragClass, false);
    }

    public void unRegisterDragHelperForType(DragHelper helper, Class cls) {
        this.unRegisterDragHelper(helper, cls, true);
    }

    public Iterator getDragHelpers(Class registeredClass) {
        HashSet<DragHelper> helpers = new HashSet<DragHelper>();
        if (this.registry.keySet().contains(registeredClass)) {
            RegInfo info = this.registry.get(registeredClass);
            helpers.addAll(info.getDragHelpers(true));
        }
        for (Class cls : this.registry.keySet()) {
            if (!cls.isAssignableFrom(registeredClass)) continue;
            RegInfo info = this.registry.get(cls);
            for (DragHelper dh : info.getDragHelpers(false)) {
                helpers.add(dh);
            }
        }
        return helpers.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerDragHelper(DragHelper helper, Class cls, boolean isExactMatch) {
        if (helper == null) {
            throw new IllegalArgumentException("The DropHelper cannot be null.");
        }
        if (cls == null) {
            throw new IllegalArgumentException("The supplied class cannot be null.");
        }
        HashMap<Class, RegInfo> hashMap = this.registry;
        synchronized (hashMap) {
            if (!this.registry.containsKey(cls)) {
                RegInfo info = new RegInfo(cls.getName());
                info.addDragHelper(helper, isExactMatch);
                this.registry.put(cls, info);
            } else {
                RegInfo info = this.registry.get(cls);
                info.addDragHelper(helper, isExactMatch);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unRegisterDragHelper(DragHelper helper, Class cls, boolean isExactMatch) {
        if (helper == null || cls == null) {
            return;
        }
        HashMap<Class, RegInfo> hashMap = this.registry;
        synchronized (hashMap) {
            if (this.registry.containsKey(cls)) {
                RegInfo info = this.registry.get(cls);
                info.removeDragHelper(helper, isExactMatch);
                if (info.shouldCleanUp()) {
                    info = null;
                    this.registry.remove(cls);
                }
            }
        }
    }

    public void registerDropHelperForInstance(DropHelper helper, Class supportedClass) {
        this.registerDropHelper(helper, supportedClass, false);
    }

    public void registerDropHelperForType(DropHelper helper, Class supportedClass) {
        this.registerDropHelper(helper, supportedClass, true);
    }

    public void unRegisterDropHelperForInstance(DropHelper helper, Class registeredClass) {
        this.unRegisterDropHelper(helper, registeredClass, false);
    }

    public void unRegisterDropHelperForType(DropHelper helper, Class registeredClass) {
        this.unRegisterDropHelper(helper, registeredClass, true);
    }

    public Iterator getDropHelpers(Class registeredClass) {
        ArrayList<DropHelper> helpers = new ArrayList<DropHelper>();
        if (this.registry.keySet().contains(registeredClass)) {
            RegInfo info = this.registry.get(registeredClass);
            helpers.addAll(info.getDropHelpers(true));
        }
        for (Class cls : this.registry.keySet()) {
            if (!cls.isAssignableFrom(registeredClass)) continue;
            RegInfo info = this.registry.get(cls);
            for (DropHelper dh : info.getDropHelpers(false)) {
                if (helpers.contains(dh)) continue;
                helpers.add(dh);
            }
        }
        if (helpers.size() > 1) {
            Collections.sort(helpers, COMPARATOR);
        }
        return helpers.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerDropHelper(DropHelper helper, Class cls, boolean isExactMatch) {
        if (helper == null) {
            throw new IllegalArgumentException("The DropHelper cannot be null.");
        }
        if (cls == null) {
            throw new IllegalArgumentException("The supplied class cannot be null.");
        }
        HashMap<Class, RegInfo> hashMap = this.registry;
        synchronized (hashMap) {
            if (!this.registry.containsKey(cls)) {
                RegInfo info = new RegInfo(cls.getName());
                info.addDropHelper(helper, isExactMatch);
                this.registry.put(cls, info);
            } else {
                RegInfo info = this.registry.get(cls);
                info.addDropHelper(helper, isExactMatch);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unRegisterDropHelper(DropHelper helper, Class cls, boolean isExactMatch) {
        if (helper == null || cls == null) {
            return;
        }
        HashMap<Class, RegInfo> hashMap = this.registry;
        synchronized (hashMap) {
            if (this.registry.containsKey(cls)) {
                RegInfo info = this.registry.get(cls);
                info.removeDropHelper(helper, isExactMatch);
                if (info.shouldCleanUp()) {
                    info = null;
                    this.registry.remove(cls);
                }
            }
        }
    }

    static {
        COMPARATOR = new DropHelperComparator();
    }

    private class RegInfo {
        HelperData matchInstance;
        HelperData matchExactType;
        private final String _className;

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof RegInfo)) {
                return false;
            }
            RegInfo other = (RegInfo)object;
            return this._className != null ? this._className.equals(other._className) : other._className == null;
        }

        public int hashCode() {
            int PRIME = 37;
            int result = 1;
            result = 37 * result + (this._className == null ? 0 : this._className.hashCode());
            return result;
        }

        public RegInfo(String className) {
            this._className = className;
            this.matchInstance = new HelperData();
            this.matchExactType = new HelperData();
        }

        public boolean shouldCleanUp() {
            return this.matchInstance.getDragHelpers().isEmpty() && this.matchInstance.getDropHelpers().isEmpty() && this.matchExactType.getDragHelpers().isEmpty() && this.matchExactType.getDropHelpers().isEmpty();
        }

        public void addDragHelper(DragHelper helper, boolean strictTyping) {
            if (strictTyping) {
                this.matchExactType.addDragHelper(helper);
            } else {
                this.matchInstance.addDragHelper(helper);
            }
        }

        public Set<DragHelper> getDragHelpers(boolean exactMatch) {
            if (exactMatch) {
                return this.matchExactType.getDragHelpers();
            }
            return this.matchInstance.getDragHelpers();
        }

        public void removeDragHelper(DragHelper helper, boolean exactMatch) {
            if (exactMatch) {
                this.matchExactType.removeDragHelper(helper);
            } else {
                this.matchInstance.removeDragHelper(helper);
            }
        }

        public void addDropHelper(DropHelper helper, boolean strictTyping) {
            if (strictTyping) {
                this.matchExactType.addDropHelper(helper);
            } else {
                this.matchInstance.addDropHelper(helper);
            }
        }

        public Set<DropHelper> getDropHelpers(boolean exactMatch) {
            if (exactMatch) {
                return this.matchExactType.getDropHelpers();
            }
            return this.matchInstance.getDropHelpers();
        }

        public void removeDropHelper(DropHelper helper, boolean exactMatch) {
            if (exactMatch) {
                this.matchExactType.removeDropHelper(helper);
            } else {
                this.matchInstance.removeDropHelper(helper);
            }
        }
    }

    private static class DropHelperComparator
    implements Comparator<DropHelper> {
        private DropHelperComparator() {
        }

        @Override
        public int compare(DropHelper dh1, DropHelper dh2) {
            return Float.compare(dh2.getWeight(), dh1.getWeight());
        }
    }

    private final class HelperData {
        Set<DragHelper> drag = new HashSet<DragHelper>(2);
        Set<DropHelper> drop = new HashSet<DropHelper>(2);

        public Set<DragHelper> getDragHelpers() {
            return this.drag;
        }

        public void addDragHelper(DragHelper helper) {
            this.drag.add(helper);
        }

        public void removeDragHelper(DragHelper helper) {
            this.drag.remove(helper);
        }

        public Set<DropHelper> getDropHelpers() {
            return this.drop;
        }

        public void addDropHelper(DropHelper helper) {
            this.drop.add(helper);
        }

        public void removeDropHelper(DropHelper helper) {
            this.drop.remove(helper);
        }
    }
}

