/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.refactoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.ide.extension.ElementName;
import javax.ide.extension.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.refactoring.ActionHandlerInfo;
import oracle.javatools.data.HashStructure;

final class ActionHandlersInfo {
    private static final ActionHandlersInfo INSTANCE = new ActionHandlersInfo();
    private static final ElementName ACTIONHANDLER_HOOK_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "actionhandler-hook");
    private final List<ActionHandlerInfo> actionHandlers = new CopyOnWriteArrayList<ActionHandlerInfo>();
    private static final String ACTIONHANDLER = "actionhandler";
    private HashStructureHookListener listener;
    private ActionHandlersAddedListener actionHandlersAddedListener;

    private ActionHandlersInfo() {
    }

    static ActionHandlersInfo getInstance() {
        return INSTANCE;
    }

    List<ActionHandlerInfo> getActionHandlers() {
        this.initializeIfNeeded();
        return Collections.unmodifiableList(this.actionHandlers);
    }

    private List<ActionHandlerInfo> getActionHandlers(HashStructure hash) {
        List data = hash.getAsList(ACTIONHANDLER);
        if (data == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ActionHandlerInfo> actionHandlers = new ArrayList<ActionHandlerInfo>(data.size());
        for (HashStructure h : data) {
            actionHandlers.add(new ActionHandlerInfo(h));
        }
        return Collections.unmodifiableList(actionHandlers);
    }

    private synchronized void initializeIfNeeded() {
        ExtensionRegistry registry;
        HashStructureHook hook;
        if (this.listener == null && (hook = (HashStructureHook)(registry = ExtensionRegistry.getExtensionRegistry()).getHook(ACTIONHANDLER_HOOK_NAME)) != null) {
            this.listener = new HashStructureHookListener(){

                @Override
                public void listenerAttached(HashStructureHookEvent e) {
                    this.processActionHandlers(e.getCombinedHashStructure());
                }

                @Override
                public void elementVisited(HashStructureHookEvent e) {
                    this.processActionHandlers(e.getNewElementHashStructure());
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void processActionHandlers(HashStructure hash) {
                    List<ActionHandlerInfo> newActionHandlers = ActionHandlersInfo.this.getActionHandlers(hash);
                    List<ActionHandlerInfo> list = ActionHandlersInfo.this.actionHandlers;
                    synchronized (list) {
                        if (ActionHandlersInfo.this.actionHandlersAddedListener != null) {
                            ActionHandlersInfo.this.actionHandlersAddedListener.addedActionHandlers(newActionHandlers);
                        } else {
                            ActionHandlersInfo.this.actionHandlers.addAll(newActionHandlers);
                        }
                    }
                }
            };
            hook.addHashStructureHookListener(this.listener);
        }
    }

    void setActionHandlersAddedListener(ActionHandlersAddedListener actionHandlersAddedListener) {
        this.actionHandlersAddedListener = actionHandlersAddedListener;
    }

    static interface ActionHandlersAddedListener {
        public void addedActionHandlers(List<ActionHandlerInfo> var1);
    }
}

