/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.print;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ide.util.MetaClass;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.TextNode;
import oracle.ide.print.DocumentPrintFactory;
import oracle.ide.print.PageableFactory;
import oracle.ide.print.PrintHook;
import oracle.ide.util.ClassUtils;
import oracle.javatools.data.HashStructure;

public class PrintHelperDefinitions {
    private static List<PageableInfo> _textNodePageableFactories = new ArrayList<PageableInfo>();
    private static List<MetaClass> _componentPageableFactories = new ArrayList<MetaClass>();
    private static Map<MetaClass, String> _viewSourceMap = new HashMap<MetaClass, String>();
    private static Map<String, MetaClass> _documentPrintFactoryMap = new HashMap<String, MetaClass>();
    private static PrintHelperDefinitions INSTANCE;

    private PrintHelperDefinitions() {
        HashStructureHook hook = (HashStructureHook)ExtensionRegistry.getExtensionRegistry().getHook(PrintHook.NAME);
        if (hook != null) {
            hook.addHashStructureHookListener(new HashStructureHookListener(){

                @Override
                public void elementVisited(HashStructureHookEvent e) {
                    this.handleData(e.getNewElementHashStructure());
                }

                @Override
                public void listenerAttached(HashStructureHookEvent e) {
                    this.handleData(e.getCombinedHashStructure());
                }

                private void handleData(HashStructure hashStructure) {
                    PrintHelperDefinitions.this.handleTextNodePageableFactories(hashStructure);
                    PrintHelperDefinitions.this.handleComponentPageableFactories(hashStructure);
                    PrintHelperDefinitions.this.handleDocumentPrintFactoryMap(hashStructure);
                    PrintHelperDefinitions.this.handleViewSourceMap(hashStructure);
                }
            });
        }
    }

    public static synchronized PrintHelperDefinitions getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PrintHelperDefinitions();
        }
        return INSTANCE;
    }

    public PageableFactory getPageableFactoryForObject(Object object) {
        MetaClass metaClass = null;
        if (object instanceof Component) {
            metaClass = _componentPageableFactories.size() > 0 ? _componentPageableFactories.get(0) : null;
        } else if (object instanceof TextNode) {
            metaClass = this.getBestPageableFit(object);
        }
        if (metaClass != null) {
            try {
                PageableFactory pageableFactory = (PageableFactory)metaClass.newInstance();
                return pageableFactory;
            }
            catch (Exception ex) {
                FeedbackManager.reportException(ex);
            }
        }
        return null;
    }

    private MetaClass getBestPageableFit(Object obj) {
        PageableInfo[] infos = new PageableInfo[_textNodePageableFactories.size()];
        infos = _textNodePageableFactories.toArray(infos);
        Arrays.sort(infos, new PageableComparator());
        for (PageableInfo pInfo : infos) {
            if (!ClassUtils.isInstanceOf(obj.getClass(), (String)pInfo.getNodeClassString())) continue;
            return pInfo.getMetaClass();
        }
        return null;
    }

    public DocumentPrintFactory getDocumentPrintFactoryForView(Class viewClass) {
        MetaClass metaclass;
        DocumentPrintFactory retval = null;
        Set<MetaClass> keyset = _viewSourceMap.keySet();
        String documentPrintFactoryId = null;
        int depth = Integer.MAX_VALUE;
        for (MetaClass metaclass2 : keyset) {
            try {
                int newDepth = ClassUtils.instanceOfDepth((Class)viewClass, (String)metaclass2.getClassName());
                if (newDepth == -1 || newDepth >= depth) continue;
                documentPrintFactoryId = _viewSourceMap.get(metaclass2);
                depth = newDepth;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (documentPrintFactoryId != null && (metaclass = _documentPrintFactoryMap.get(documentPrintFactoryId)) != null) {
            try {
                retval = (DocumentPrintFactory)metaclass.newInstance();
            }
            catch (Exception ex) {
                FeedbackManager.reportException(ex);
            }
        }
        return retval;
    }

    private void handleTextNodePageableFactories(HashStructure hashStructure) {
        List hashList = hashStructure.getAsList("textNodePageableFactory");
        if (hashList == null || hashList.size() == 0) {
            return;
        }
        for (HashStructure h : hashList) {
            LazyClassAdapter adapter = LazyClassAdapter.getInstance(h);
            MetaClass metaClass = adapter.getMetaClass("#text");
            String nodeClassString = h.getString("node-class");
            float weight = h.getFloat("weight", 10.0f);
            _textNodePageableFactories.add(new PageableInfo(metaClass, nodeClassString, weight));
        }
    }

    private void handleComponentPageableFactories(HashStructure hashStructure) {
        List hashList = hashStructure.getAsList("componentPageableFactory");
        if (hashList == null || hashList.size() == 0) {
            return;
        }
        for (HashStructure h : hashList) {
            LazyClassAdapter adapter = LazyClassAdapter.getInstance(h);
            MetaClass metaClass = adapter.getMetaClass("#text");
            _componentPageableFactories.add(metaClass);
        }
    }

    private void handleDocumentPrintFactoryMap(HashStructure hash) {
        List list = hash.getAsList("documentPrintFactory");
        if (list != null) {
            for (HashStructure h : list) {
                LazyClassAdapter adapter = LazyClassAdapter.getInstance(h);
                String id = h.getString("id");
                MetaClass metaClass = adapter.getMetaClass("class");
                _documentPrintFactoryMap.put(id, metaClass);
            }
        }
    }

    private void handleViewSourceMap(HashStructure hash) {
        List list = hash.getAsList("printHelper");
        if (list != null) {
            for (HashStructure h : list) {
                LazyClassAdapter adapter = LazyClassAdapter.getInstance(h);
                String id = h.getString("documentPrintFactoryId");
                MetaClass metaClass = adapter.getMetaClass("view-class");
                _viewSourceMap.put(metaClass, id);
            }
        }
    }

    private static final class PageableInfo {
        private MetaClass _metaClass;
        private String _nodeClassString;
        private float _weight;

        public PageableInfo(MetaClass metaclass, String nodeClassString, float weight) {
            this._metaClass = metaclass;
            this._nodeClassString = nodeClassString;
            this._weight = weight;
        }

        public MetaClass getMetaClass() {
            return this._metaClass;
        }

        public String getNodeClassString() {
            return this._nodeClassString;
        }

        public float getWeight() {
            return this._weight;
        }
    }

    private static final class PageableComparator
    implements Comparator {
        private PageableComparator() {
        }

        public int compare(Object o1, Object o2) {
            float w2;
            float w1 = ((PageableInfo)o1).getWeight();
            if (w1 == (w2 = ((PageableInfo)o2).getWeight())) {
                return 0;
            }
            if (w1 > w2) {
                return 1;
            }
            return -1;
        }
    }
}

