/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.resource.NetArb;
import oracle.ide.util.IdeUtil;
import oracle.javatools.icons.OracleIcons;

public class PackageClassChooser
extends DefaultTraversablePanel {
    public static final int PACKAGES_ONLY = 0;
    public static final int CLASSES_ONLY = 1;
    public static final int PACKAGES_AND_CLASSES = 2;
    public static final int APPROVE_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    public static final int ERROR_OPTION = 2;
    private boolean _multiSelect;
    private final int _scope;
    private final URLPath _path;
    private final URLNode _root = new URLNode("", true);
    private final DefaultTreeModel _dtm = new DefaultTreeModel(this._root);
    private final JScrollPane _spPkgs = new JScrollPane();
    private final JTree _pkgTree = new JTree(this._dtm);
    private transient JEWTDialog _dialog;

    public PackageClassChooser(int scope, URLPath path) {
        this._scope = scope;
        this._path = path;
        this._root.buildChildren();
        this._dtm.nodeStructureChanged(this._root);
        this._pkgTree.setRootVisible(false);
        this._pkgTree.setShowsRootHandles(true);
        this._pkgTree.setCellRenderer(new TCR());
        UI ui = new UI();
        this._pkgTree.addTreeSelectionListener(ui);
        this._pkgTree.addTreeWillExpandListener(ui);
        this._spPkgs.getViewport().add((Component)this._pkgTree, null);
        this._pkgTree.setSelectionRow(0);
        this.setLayout(new BorderLayout());
        this.add(this._spPkgs, "Center");
    }

    public String getSelection() {
        URLNode node;
        TreePath tp = this._pkgTree.getSelectionPath();
        if (tp != null && (node = (URLNode)tp.getLastPathComponent()) != null) {
            return node.getRelPath();
        }
        return null;
    }

    public void setSelection(String packageOrClass) {
        if (packageOrClass != null) {
            this.setSelection(new String[]{packageOrClass});
        }
    }

    private void setSelection(String[] selection) {
        if (selection == null || selection.length == 0) {
            return;
        }
        ArrayList<TreePath> list = new ArrayList<TreePath>();
        for (int i = 0; i < selection.length; ++i) {
            String tok;
            URLNode child;
            String packageOrClass = selection[i];
            StringTokenizer st = new StringTokenizer(packageOrClass, ".");
            URLNode curNode = this._root;
            while (st.hasMoreTokens() && (child = curNode.findChild(tok = st.nextToken())) != null) {
                curNode = child;
            }
            TreePath tp = new TreePath(curNode.getPath());
            list.add(tp);
        }
        TreePath[] tps = new TreePath[list.size()];
        list.toArray(tps);
        this._pkgTree.setSelectionPaths(tps);
        IdeUtil.centerTreeSelection(this._pkgTree);
    }

    public void setMultiSelect(boolean isMultiSelect) {
        if (isMultiSelect != this._multiSelect) {
            this._multiSelect = isMultiSelect;
        }
    }

    public int showDialog(Component parent) {
        return this.showDialog(parent, this._multiSelect, null);
    }

    public JTree getTree() {
        return this._pkgTree;
    }

    public String[] getSelections() {
        TreePath[] tps = this._pkgTree.getSelectionPaths();
        int n = tps.length;
        ArrayList<String> relPaths = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            URLNode node = (URLNode)tps[i].getLastPathComponent();
            if (node == null) continue;
            relPaths.add(node.getRelPath());
        }
        return relPaths.toArray(new String[relPaths.size()]);
    }

    private String getTitle(boolean multiSelect) {
        if (this._scope == 0) {
            return multiSelect ? NetArb.getString((int)32) : NetArb.getString((int)33);
        }
        return multiSelect ? NetArb.getString((int)34) : NetArb.getString((int)35);
    }

    private int showDialog(Component parent, boolean multiSelect, String[] selection) {
        String title = this.getTitle(multiSelect);
        try {
            TreeSelectionModel tsm = this._pkgTree.getSelectionModel();
            tsm.setSelectionMode(multiSelect ? 4 : 1);
            this.setSelection(selection);
            Frame frame = IdeUtil.findFrame(parent);
            this._dialog = new JEWTDialog(frame, title, 7);
            this._dialog.setContent((Component)((Object)this));
            this._dialog.setResizable(true);
            this._dialog.setInitialFocus((Component)this._pkgTree);
            this.updateOKButton();
            boolean result = WizardLauncher.runDialog((JDialog)this._dialog);
            this._dialog = null;
            return result ? 0 : 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 2;
        }
    }

    private void updateOKButton() {
        if (this._dialog != null) {
            URLNode node;
            TreePath tp = this._pkgTree.getSelectionPath();
            if (tp != null && (node = (URLNode)tp.getLastPathComponent()) != null) {
                this._dialog.setOKButtonEnabled(this._scope == 2 || this._scope == 0 && node.isPackage() || this._scope == 1 && !node.isPackage());
                return;
            }
            this._dialog.setOKButtonEnabled(false);
        }
    }

    private class URLNode
    extends DefaultMutableTreeNode {
        private final String _relPath;
        private final boolean _isPackage;
        private String _name;
        private boolean _isExpanded;

        URLNode(String relPath, boolean isPackage) {
            this._relPath = relPath;
            this._isPackage = isPackage;
        }

        @Override
        public String toString() {
            if (this._name == null) {
                int lastSlash = this._relPath.lastIndexOf("/");
                this._name = lastSlash >= 0 ? this._relPath.substring(lastSlash + 1) : this._relPath;
            }
            return this._name;
        }

        @Override
        public boolean isLeaf() {
            return !this._isPackage;
        }

        boolean isPackage() {
            return this._isPackage;
        }

        Icon getIcon() {
            return this._isPackage ? OracleIcons.getIcon((String)"package.png") : OracleIcons.getIcon((String)"class.png");
        }

        boolean isExpanded() {
            return this._isExpanded;
        }

        String getRelPath() {
            return this._relPath.replace('/', '.');
        }

        URLNode findChild(String name) {
            if (name == null) {
                return null;
            }
            if (!this._isExpanded) {
                this.buildChildren();
            }
            Enumeration<TreeNode> e = this.children();
            while (e.hasMoreElements()) {
                URLNode child = (URLNode)e.nextElement();
                if (!name.equals(child.toString())) continue;
                return child;
            }
            return null;
        }

        void buildChildren() {
            List childDirs = PackageClassChooser.this._path.getDirectories(this._relPath);
            Iterator dirsIter = childDirs.iterator();
            while (dirsIter.hasNext()) {
                String dir = dirsIter.next().toString();
                URLNode dirNode = new URLNode(dir, true);
                this.add(dirNode);
            }
            if (PackageClassChooser.this._scope == 1 || PackageClassChooser.this._scope == 2) {
                List childFiles = PackageClassChooser.this._path.getFiles(this._relPath);
                for (URL file : childFiles) {
                    if (!URLFileSystem.hasSuffix((URL)file, (String)".class")) continue;
                    String fileStr = PackageClassChooser.this._path.toRelativePath(file);
                    fileStr = fileStr.substring(0, fileStr.length() - 6);
                    URLNode fileNode = new URLNode(fileStr, false);
                    this.add(fileNode);
                }
            }
            PackageClassChooser.this._dtm.nodeStructureChanged(this);
            this._isExpanded = true;
        }
    }

    private static class TCR
    extends DefaultTreeCellRenderer {
        private TCR() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            URLNode node = (URLNode)value;
            label.setIcon(node.getIcon());
            return label;
        }
    }

    private class UI
    implements TreeSelectionListener,
    TreeWillExpandListener {
        private UI() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            PackageClassChooser.this.updateOKButton();
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent e) {
            TreePath tp = e.getPath();
            URLNode node = (URLNode)tp.getLastPathComponent();
            if (node != null && !node.isExpanded()) {
                node.buildChildren();
            }
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent e) {
        }
    }
}

