/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.log;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import javax.swing.SwingUtilities;
import oracle.ide.log.LogPage;
import oracle.ide.log.LogPrintStream;
import oracle.ide.log.LogPrintWriter;
import oracle.ide.log.MessagePage;

public final class LogPipe {
    private final BufferedReader _bufferedReader;
    private final LogPage _logPage;

    public static PrintWriter getPrintWriter(LogPage logPage) {
        return new LogPrintWriter(logPage);
    }

    public static PrintStream getPrintStream(LogPage logPage) {
        return new LogPrintStream(logPage);
    }

    LogPipe(LogPage logPage, BufferedReader bufferedReader) {
        this._logPage = logPage;
        this._bufferedReader = bufferedReader;
        new Pump().start();
    }

    private class Pump
    extends Thread {
        Pump() {
            super("LogPipe:" + LogPipe.this._logPage.getTabName());
        }

        @Override
        public void run() {
            try {
                while (true) {
                    String line;
                    if ((line = LogPipe.this._bufferedReader.readLine()) == null) {
                        return;
                    }
                    final String mesg = line + "\n";
                    if (LogPipe.this._logPage instanceof MessagePage) {
                        LogPipe.this._logPage.log(mesg);
                        continue;
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LogPipe.this._logPage.log(mesg);
                        }
                    });
                }
            }
            catch (IOException iOException) {
                return;
            }
        }
    }
}

