/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.docking;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.ide.extension.ElementName;
import javax.ide.extension.ExtensionHook;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.BaseDockableFactory;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockableWindow;
import oracle.ide.docking.Drawer;
import oracle.ide.docking.DrawerConfig;
import oracle.ide.docking.DrawerEvent;
import oracle.ide.docking.DrawerLayoutUtil;
import oracle.ide.docking.DrawerListener;
import oracle.ide.docking.DrawerUI;
import oracle.ide.docking.DrawerWindowConfig;
import oracle.ide.docking.DrawerWindowModel;
import oracle.ide.docking.DrawerWindowUI;
import oracle.ide.docking.LazyDrawerUpdateProvider;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.BitField;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.PropertyAccess;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ide.view.View;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.DockableFactoryHook;
import oracle.ideimpl.docking.ProxyDockable;
import oracle.javatools.data.HashStructure;

public class DrawerWindow
extends DockableWindow {
    private static final String DRAWER_PROPERTY = "DrawerModel.Entry";
    private static final String VIEW_PROPERTY = "Layout";
    private static final String PANEL_PROPERTY = "PanelLayout";
    private static final String USER_PROPERTY = "user";
    private static final String HIDE_HANDLE_IF_ONLY_ONE_DRAWER_SHOWN_PROPERTY = "HideHandleIfOnlyOneDrawerShown";
    private static final String PROPERTY_USER_LANGUAGE = "user.language";
    private static final String PROPERTY_USER_COUNTRY = "user.country";
    private static final String EXPAND_DRAWER_ON_ACTIVATION = "ExpandDrawerOnActivation";
    public static final int DROP_DOWN_ACTION_ID = Ide.createCmdID("DDW.dropDown");
    public static final int RESTORE_ACTION_ID = Ide.createCmdID("DDW.Restore");
    public static final int MOVE_ACTION_ID = Ide.createCmdID("DDW.Move");
    public static final int SIZE_ACTION_ID = Ide.createCmdID("DDW.Size");
    public static final int FLOAT_ACTION_ID = Ide.createCmdID("DDW.Float");
    public static final int MINIMIZE_ACTION_ID = Ide.createCmdID("DDW.Minimize");
    public static final int MAXIMIZE_ACTION_ID = Ide.createCmdID("DDW.Maximize");
    public static final int CLOSE_ACTION_ID = Ide.createCmdID("DDW.Close");
    private final DrawerWindowModel model;
    private final List<Controller> delegates = new ArrayList<Controller>();
    private final Controller controller = new DrawerController();
    private DrawerWindowUI drawerWindowUI;
    private JPanel ui;
    private String tabName;
    private Icon tabIcon;
    private String titleName;
    private JComponent topComponent;
    private StructuredPropertyAccess savedPanelLayout;
    private final View decorated;
    private boolean expandOneDrawerAtATime;
    private boolean hideHandleIfOnlyOneDrawerShown;
    private boolean expandDrawerOnActivation;
    private final Collection<DrawerListener> _listeners = new ArrayList<DrawerListener>();
    private Boolean differentLanguageCountry = null;
    private static final ElementName DOCKABLE_HOOK_ELEMENT = new ElementName("http://xmlns.oracle.com/ide/extension", "dockable-hook");

    public DrawerWindow(String viewId, View decorated, DrawerWindowConfig config) {
        this(viewId, decorated, decorated.getController(), config);
    }

    public DrawerWindow(String viewId, View decorated, Controller controller, DrawerWindowConfig config) {
        super(viewId);
        this.decorated = this.validate(decorated);
        this.addDelegateControllers(controller);
        this.applyConfig(this.validate(config));
        this.model = new DrawerWindowModel(this);
        this.mustExpandDrawerOnActivation(true);
    }

    public final void addDrawerListener(DrawerListener listener) {
        this._listeners.add(listener);
    }

    public final void removeDrawerListener(DrawerListener listener) {
        this._listeners.remove(listener);
    }

    private View validate(View decorated) {
        if (decorated == null) {
            throw new IllegalArgumentException("The decorated view should not be null");
        }
        return decorated;
    }

    private DrawerWindowConfig validate(DrawerWindowConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("The drawer configuration should not be null");
        }
        return config;
    }

    public void expandOneDrawerAtATime() {
        this.expandOneDrawerAtATime = true;
        if (this.drawerWindowUI(false) != null) {
            this.drawerWindowUI(false).expandOneDrawerAtATime();
        }
    }

    public void hideHandleIfOnlyOneDrawerShown() {
        this.mustHideHandle(true);
    }

    private void mustHideHandle(boolean newValue) {
        this.hideHandleIfOnlyOneDrawerShown = newValue;
        if (this.hideHandleIfOnlyOneDrawerShown && this.drawerWindowUI(false) != null) {
            this.drawerWindowUI(false).hideHandleIfOnlyOneDrawerShown();
        }
    }

    private void mustExpandDrawerOnActivation(boolean newValue) {
        this.expandDrawerOnActivation = newValue;
        if (this.expandDrawerOnActivation && this.drawerWindowUI(false) != null) {
            this.drawerWindowUI(false).expandDrawerOnActivation();
        }
    }

    private void applyConfig(DrawerWindowConfig config) {
        this.tabName = config.tabName();
        this.titleName = config.titleName();
        this.topComponent = config.topComponent();
        this.tabIcon = config.icon();
        this.setType(config.type());
    }

    public void topComponent(JComponent topComponent) {
        this.topComponent = topComponent;
    }

    @Override
    public Toolbar getToolbar() {
        return this.decorated.getToolbar();
    }

    @Override
    public HelpInfo getHelpInfo() {
        return this.decorated.getHelpInfo();
    }

    private boolean moreThanOneVisibleDrawer() {
        return this.drawerWindowUI(true).visibleDrawers().size() > 1;
    }

    public void addDrawer(View view, DrawerConfig config) {
        this.model.addDrawer(view, config);
    }

    public void addDrawer(DockableWindow view) {
        this.model.addDrawer(view);
    }

    public void addDrawer(DockableWindow view, float weight) {
        if (view instanceof ProxyDockable) {
            ProxyDockable proxyDockable = (ProxyDockable)view;
            if (DockableFactoryHook.get().isExtensionFullyLoaded(proxyDockable.getFactoryId())) {
                this.removeIfPresent(view);
                proxyDockable.markAsDrawer(this);
                view = (DockableWindow)DockStationImpl.getInstance().swapDockable(proxyDockable);
                this.removeIfPresent(view);
            }
        }
        this.model.addDrawer(view, weight);
    }

    public void addDrawerThatCanHideHandle(DockableWindow view) {
        this.model.addDrawerThatCanHideHandle(view);
    }

    public void addCloseableDrawer(DockableWindow view, int index) {
        this.model.addCloseableDrawer(view, index);
    }

    public void addDrawer(DockableWindow view, int index) {
        this.model.addDrawer(view, index);
    }

    public void updateDrawerHandlesVisibility() {
        if (this.drawerWindowUI(false) == null) {
            return;
        }
        this.drawerWindowUI(false).updateDrawerHandlesVisibility();
    }

    public void addDelegateControllers(Controller ... delegates) {
        this.delegates.addAll(Arrays.asList(delegates));
    }

    @Override
    public Controller getController() {
        return this.controller;
    }

    @Override
    public Component getGUI() {
        if (this.ui == null) {
            this.createGUI();
        }
        return this.ui;
    }

    private DrawerWindowUI drawerWindowUI(boolean create) {
        if (create && this.drawerWindowUI == null) {
            this.drawerWindowUI = new DrawerWindowUI(this);
        }
        return this.drawerWindowUI;
    }

    private void createGUI() {
        if (this.expandOneDrawerAtATime) {
            this.drawerWindowUI(true).expandOneDrawerAtATime();
        }
        if (this.hideHandleIfOnlyOneDrawerShown) {
            this.drawerWindowUI(true).hideHandleIfOnlyOneDrawerShown();
        }
        if (this.expandDrawerOnActivation) {
            this.drawerWindowUI(true).expandDrawerOnActivation();
        }
        this.ui = new JPanel(new BorderLayout());
        this.ui.putClientProperty("print.printable", Boolean.TRUE);
        this.ui.setOpaque(false);
        if (this.topComponent != null) {
            this.ui.add((Component)this.topComponent, "North");
        }
        this.ui.add((Component)this.drawerWindowUI(true), "Center");
        this.loadLayoutIfNecessary();
    }

    private void loadLayoutIfNecessary() {
        if (this.savedPanelLayout == null) {
            return;
        }
        this.drawerWindowUI(true).loadLayout(this.savedPanelLayout);
        this.savedPanelLayout = null;
    }

    @Override
    public String getTabName() {
        return this.tabName;
    }

    @Override
    public Icon getTabIcon() {
        return this.tabIcon;
    }

    @Override
    public String getTitleName() {
        return this.titleName;
    }

    DrawerWindowModel model() {
        return this.model;
    }

    DockableWindow view(DrawerUI drawer) {
        int i = this.model.indexOf(drawer);
        return this.model.drawerAt(i).view();
    }

    public void minimize(View view) {
        Drawer drawer = this.drawerFrom(view);
        if (drawer != null) {
            DrawerUI drawerUI = drawer.drawerUI();
            assert (drawerUI != null);
            drawer.state(DrawerConfig.State.MINIMIZED);
            this.drawerWindowUI(true).minimizeWithAnimation(drawerUI);
            this.updateDrawerHandlesVisibility();
            DrawerEvent de = new DrawerEvent(drawer);
            for (DrawerListener l : this._listeners) {
                l.drawerMinimized(de);
            }
        }
    }

    public void expandFirstDrawer() {
        if (this.model == null || this.model.drawerCount() == 0) {
            return;
        }
        if (this.drawerWindowUI(false) == null) {
            return;
        }
        Drawer d = this.model.drawerAt(0);
        this.drawerWindowUI(false).expand(d.drawerUI());
    }

    public void expand(View view) {
        if (view == null) {
            Logger.getAnonymousLogger().warning("View is null, cant expand drawer");
            return;
        }
        int index = this.model.indexOf(view);
        if (index == -1 && view instanceof ProxyDockable) {
            String proxyID = view.getId();
            for (Drawer drawer : this.model.drawers()) {
                if (drawer == null || drawer.view() == null || drawer.view().getId() == null) {
                    Logger.getAnonymousLogger().warning("Cant expand drawer");
                    continue;
                }
                if (!drawer.view().getId().equals(proxyID)) continue;
                view = drawer.view();
                index = this.model.indexOf(view);
                break;
            }
        }
        if (index < 0) {
            index = this.model.findIndexForView(view);
        }
        this.assertKnownView(index, view);
        if (index == -1) {
            Logger.getAnonymousLogger().warning("Couldn't find drawer for view " + view.getId());
            return;
        }
        this.getGUI();
        this.drawerWindowUI(true).expand(this.model.drawerAt(index).drawerUI());
    }

    public void expand(View view, double ratio) {
        int index = this.model.indexOf(view);
        if (index < 0) {
            index = this.model.findIndexForView(view);
        }
        this.assertKnownView(index, view);
        this.getGUI();
        this.drawerWindowUI(true).expand(this.model.drawerAt(index).drawerUI(), ratio);
    }

    public boolean expanded(View view) {
        int index = this.model.indexOf(view);
        if (index < 0) {
            index = this.model.findIndexForView(view);
        }
        this.assertKnownView(index, view);
        return this.model.drawerAt(index).drawerUI().ratio() != 0.0;
    }

    public void activate(View view, boolean whetherToActivate) {
        int index = this.model.indexOf(view);
        if (index < 0) {
            index = this.model.findIndexForView(view);
        }
        this.assertKnownView(index, view);
        for (int drawerIndex = 0; drawerIndex < this.model.drawerCount(); ++drawerIndex) {
            Drawer nextDrawer = this.model.drawerAt(drawerIndex);
            if (drawerIndex == index || !nextDrawer.drawerUI().active()) continue;
            nextDrawer.drawerUI().deactivate();
        }
        if (whetherToActivate) {
            this.drawerWindowUI(true).activate(this.model.drawerAt(index).drawerUI());
        } else {
            this.drawerWindowUI(true).deactivate(this.model.drawerAt(index).drawerUI());
        }
    }

    public void removeIfPresent(View view) {
        Drawer removed = this.model.removeDrawerIfPresent(view);
        if (removed == null) {
            return;
        }
        this.updateViewInHostedDrawerWindow(removed.viewWithoutDecoration(), view);
        if (this.drawerWindowUI(false) == null) {
            return;
        }
        this.updateDrawerHandlesVisibility();
        this.drawerWindowUI(false).doLayout();
        for (DrawerUI drawerUI : this.drawerWindowUI(false).expandedDrawers()) {
            drawerUI.revalidate();
        }
        this.drawerWindowUI(false).updateTrayIcon();
    }

    private void assertKnownView(int viewIndex, View view) {
        assert (viewIndex >= 0) : "> No index for view : " + view + " \n" + this.model.printDrawersModelInfo();
    }

    public void restore(View view) {
        Drawer drawer = this.drawerFrom(view);
        if (drawer != null) {
            this.drawerWindowUI(true).restoreWithoutAnimation(drawer);
            DrawerEvent de = new DrawerEvent(drawer);
            for (DrawerListener l : this._listeners) {
                l.drawerRestored(de);
            }
        }
    }

    public Component getMinimizerTray() {
        return this.drawerWindowUI(true).bottomComponent();
    }

    public boolean showing(View view) {
        Drawer drawer = this.drawerFrom(view);
        return drawer != null && !drawer.state().equals((Object)DrawerConfig.State.HIDDEN) && !drawer.state().equals((Object)DrawerConfig.State.HIDDEN_AND_MINIMIZED) && !drawer.state().equals((Object)DrawerConfig.State.MINIMIZED);
    }

    public void show(View view) {
        Drawer drawer = this.drawerFrom(view);
        if (drawer != null) {
            this.drawerWindowUI(true).show(drawer);
        }
    }

    public void hide(View view) {
        Drawer drawer = this.drawerFrom(view);
        if (this.drawerWindowUI(false) != null && drawer != null) {
            this.drawerWindowUI(true).hide(drawer);
        }
    }

    private Drawer drawerFrom(View view) {
        int index = this.model.indexOf(view);
        return index >= 0 ? this.model.drawerAt(index) : null;
    }

    public View undecorateIfNecessary(DockableWindow dockable) {
        Drawer drawer = this.drawerFrom(dockable);
        if (drawer == null) {
            return null;
        }
        return drawer.viewWithoutDecoration();
    }

    public void togglePanelsWithAnimation(List<View> toExpand, List<View> toCollapse) {
        this.drawerWindowUI(true).toggleWithAnimation(this.drawers(toExpand), this.drawers(toCollapse));
    }

    public void togglePanelsWithoutAnimation(View toExpand, View toCollapse) {
        this.togglePanelsWithoutAnimation(Collections.singletonList(toExpand), Collections.singletonList(toCollapse));
    }

    public void togglePanelsWithoutAnimation(List<View> toExpand, List<View> toCollapse) {
        this.drawerWindowUI(true).toggleWithoutAnimation(this.drawers(toExpand), this.drawers(toCollapse));
    }

    private List<DrawerUI> drawers(List<View> views) {
        if (views == null || !this.model.views().containsAll(views)) {
            return null;
        }
        ArrayList<DrawerUI> drawers = new ArrayList<DrawerUI>();
        for (View view : views) {
            DrawerUI drawerUI = this.drawerUIFrom(view);
            if (drawerUI == null) continue;
            drawers.add(drawerUI);
        }
        return drawers;
    }

    private DrawerUI drawerUIFrom(View view) {
        Drawer drawer = this.drawerFrom(view);
        return drawer != null ? drawer.drawerUI() : null;
    }

    public boolean accessibleDrawer() {
        for (Drawer drawer : this.model.drawers()) {
            if (!drawer.accessible()) continue;
            return true;
        }
        return false;
    }

    public List<Integer> drawerDockableStatuses(Object view) {
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (Drawer drawer : this.model.drawers()) {
            if (!view.equals(drawer.view())) continue;
            l.add(drawer.dockableStatus());
        }
        return l;
    }

    public void clientVisible(Object view, boolean visible, int flags) {
        for (Drawer drawer : this.model.drawers()) {
            if (!view.equals(drawer.view())) continue;
            drawer.clientVisible(visible, flags);
        }
    }

    @Override
    public void saveLayout(PropertyAccess p) {
        StructuredPropertyAccess root = (StructuredPropertyAccess)p;
        root.setBooleanProperty(HIDE_HANDLE_IF_ONLY_ONE_DRAWER_SHOWN_PROPERTY, this.hideHandleIfOnlyOneDrawerShown);
        root.setBooleanProperty(EXPAND_DRAWER_ON_ACTIVATION, this.expandDrawerOnActivation);
        String userLanguage = System.getProperty(PROPERTY_USER_LANGUAGE);
        root.setProperty(PROPERTY_USER_LANGUAGE, userLanguage);
        String userCountry = System.getProperty(PROPERTY_USER_COUNTRY);
        root.setProperty(PROPERTY_USER_COUNTRY, userCountry);
        for (Drawer drawer : this.model.drawers()) {
            if (BitField.isSet(drawer.view().getType(), 64)) continue;
            root.appendChild(this.drawerProperties(drawer));
        }
        if (this.drawerWindowUI(false) != null) {
            root.appendChild(this.panelProperties());
        } else if (this.savedPanelLayout != null) {
            root.appendChild(this.savedPanelLayout);
        }
        StructuredPropertyAccess userProperties = this.newPropertyAccess(USER_PROPERTY);
        this.decorated.saveLayout(userProperties);
        root.appendChild(userProperties);
    }

    private StructuredPropertyAccess drawerProperties(Drawer drawer) {
        StructuredPropertyAccess p = this.newPropertyAccess(DRAWER_PROPERTY);
        drawer.saveLayout(p);
        p.appendChild(this.viewProperties(drawer.view()));
        return p;
    }

    private StructuredPropertyAccess viewProperties(View view) {
        StructuredPropertyAccess p = this.newPropertyAccess(VIEW_PROPERTY);
        view.saveLayout(p);
        return p;
    }

    private StructuredPropertyAccess panelProperties() {
        StructuredPropertyAccess p = this.newPropertyAccess(PANEL_PROPERTY);
        this.drawerWindowUI(true).beStored(p);
        return p;
    }

    @Override
    public void loadLayout(PropertyAccess p) {
        String lastLanguage = p.getProperty(PROPERTY_USER_LANGUAGE, "");
        String lastCountry = p.getProperty(PROPERTY_USER_COUNTRY, "");
        String currentLanguage = System.getProperty(PROPERTY_USER_LANGUAGE, "");
        String currentCountry = System.getProperty(PROPERTY_USER_COUNTRY, "");
        if (!(this.differentLanguageCountry != null || currentLanguage.equals(lastLanguage) && lastCountry.equals(currentCountry))) {
            this.differentLanguageCountry = Boolean.TRUE;
        } else if (this.differentLanguageCountry == null) {
            this.differentLanguageCountry = Boolean.FALSE;
        }
        StructuredPropertyAccess root = (StructuredPropertyAccess)p;
        this.mustHideHandle(this.hideHandleIfOnlyOneDrawerShown(root));
        this.mustExpandDrawerOnActivation(this.expandDrawerOnActivation(root));
        Iterator children = root.getChildNodes(DRAWER_PROPERTY);
        while (children.hasNext()) {
            StructuredPropertyAccess drawerProperties = (StructuredPropertyAccess)children.next();
            this.createDrawer(drawerProperties, root, true);
        }
        this.savedPanelLayout = root.getChildNode(PANEL_PROPERTY);
        StructuredPropertyAccess userProperties = root.getChildNode(USER_PROPERTY);
        if (userProperties != null) {
            this.decorated.loadLayout(userProperties);
        }
    }

    Drawer createDrawer(StructuredPropertyAccess drawerProperties, StructuredPropertyAccess root, boolean checkIfExpanded) {
        DrawerConfig drawerConfig = Drawer.loadConfig(drawerProperties);
        if (drawerConfig.uniqueName() == null) {
            return null;
        }
        ViewId viewId = new ViewId(drawerConfig.uniqueName());
        float weight = this.getWeigth(viewId.getId());
        if (weight >= 0.0f) {
            drawerConfig.weight(weight);
        }
        View view = null;
        if (!checkIfExpanded || !(this.getCachedDockable() instanceof LazyDrawerUpdateProvider) || DrawerLayoutUtil.isDrawerExpanded(drawerConfig.uniqueName()) || drawerConfig.uniqueName().equals("_SUB_ApplicationNavigatorWindow._SUB_ApplicationNavigatorName") || this.differentLanguageCountry.booleanValue()) {
            view = this.view(viewId);
        } else if (!this.model.drawerExists(viewId.getId())) {
            view = new ProxyDrawer(viewId);
        }
        if (view == null) {
            return null;
        }
        view.loadLayout(this.viewProperties(drawerProperties));
        Drawer drawer = this.model.addDrawer(view, drawerConfig);
        drawer.loadLayout(drawerProperties);
        return drawer;
    }

    private boolean hideHandleIfOnlyOneDrawerShown(StructuredPropertyAccess root) {
        String propertyName = HIDE_HANDLE_IF_ONLY_ONE_DRAWER_SHOWN_PROPERTY;
        return root.getBooleanProperty(propertyName, false);
    }

    private boolean expandDrawerOnActivation(StructuredPropertyAccess root) {
        return root.getBooleanProperty(EXPAND_DRAWER_ON_ACTIVATION, false);
    }

    private View view(ViewId viewId) {
        DockableFactory factory = null;
        DockStation dockStation = DockStation.getDockStation();
        factory = dockStation instanceof DockStationImpl ? DockStationImpl.getInstance().lookupDrawerFactory(viewId) : DockStation.getDockStation().lookupFactory(viewId);
        if (factory == null) {
            return null;
        }
        if (factory instanceof BaseDockableFactory) {
            return ((BaseDockableFactory)factory).lookupView(viewId);
        }
        return (View)((Object)factory.getDockable(viewId));
    }

    private StructuredPropertyAccess viewProperties(StructuredPropertyAccess drawerProperties) {
        StructuredPropertyAccess p = drawerProperties.getChildNode(VIEW_PROPERTY);
        if (p == null) {
            p = this.newPropertyAccess(VIEW_PROPERTY);
        }
        return p;
    }

    private StructuredPropertyAccess newPropertyAccess(String name) {
        return new DefaultStructuredPropertyAccess(name);
    }

    public List<View> drawerViews() {
        ArrayList<View> views = new ArrayList<View>();
        for (Drawer drawer : this.model.drawers()) {
            views.add(drawer.viewWithoutDecoration());
        }
        return views;
    }

    @Override
    public void updateVisibleActions(UpdateMessage updateMessage) {
        List<View> views = this.drawerViews();
        for (View v : views) {
            v.updateVisibleActions(updateMessage);
        }
    }

    private float getWeigth(String viewId) {
        HashStructureHook sh;
        float weight;
        ExtensionHook hook = ExtensionRegistry.getExtensionRegistry().getHook(DOCKABLE_HOOK_ELEMENT);
        if (hook instanceof HashStructureHook && (weight = this.searchForWeight((sh = (HashStructureHook)hook).getHashStructure(), viewId)) >= 0.0f) {
            return weight;
        }
        return -1.0f;
    }

    private float searchForWeight(HashStructure hs, String viewId) {
        List hostedList = hs.getAsList("hosted-dockable");
        if (hostedList != null) {
            for (Object hostObj : hostedList) {
                HashStructure hostedHash = (HashStructure)hostObj;
                String _viewId = hostedHash.getString("view-id");
                if (!_viewId.equals(viewId)) continue;
                return hostedHash.containsKey("weight") ? hostedHash.getFloat("weight") : 0.0f;
            }
        }
        return -1.0f;
    }

    public void closeAllExpandedDrawers() {
        if (this.drawerWindowUI(false) == null || this.drawerWindowUI(true).expandedDrawers() == null) {
            return;
        }
        List<DrawerUI> drawerUIs = this.drawerWindowUI(true).expandedDrawers();
        for (DrawerUI drawerUI : drawerUIs) {
            if (drawerUI == null) continue;
            drawerUI.expanded(false);
        }
    }

    void updateViewInHostedDrawerWindow(View oldView, View newView) {
        DockableWindow hostDockable = (DockableWindow)this.getCachedDockable();
        if (hostDockable instanceof LazyDrawerUpdateProvider) {
            ((LazyDrawerUpdateProvider)((Object)hostDockable)).replaceHostedView(oldView, newView);
        }
    }

    public boolean isDrawerExpanded(String drawerID) {
        if (this.drawerWindowUI(false) == null || this.drawerWindowUI(false).expandedDrawers() == null || drawerID == null) {
            return false;
        }
        for (DrawerUI drawerUI : this.drawerWindowUI(false).expandedDrawers()) {
            if (drawerUI == null || !drawerUI.getView().getId().equals(drawerID)) continue;
            return true;
        }
        return false;
    }

    private class DrawerController
    implements Controller {
        private DrawerController() {
        }

        @Override
        public boolean handleEvent(IdeAction action, Context context) {
            Editor editor;
            EditorManager em;
            List<EditorAddin> addins;
            if (context != null && context.getView() instanceof Editor && !(addins = (em = EditorManager.getEditorManager()).getAddins(context)).contains((editor = (Editor)context.getView()).getEditorAddin())) {
                return false;
            }
            if (this.eventHandledByDelegates(action, context)) {
                return true;
            }
            if (this.unimplementedHandled(action)) {
                return true;
            }
            if (this.minimizeHandled(action, context)) {
                return true;
            }
            return this.closeHandled(action, context);
        }

        private boolean unimplementedHandled(IdeAction action) {
            if (!this.isUnimplementedAction(action)) {
                return false;
            }
            action.setEnabled(false);
            return true;
        }

        private boolean minimizeHandled(IdeAction action, Context context) {
            if (!this.isMinimizeAction(action)) {
                return false;
            }
            DrawerWindow.this.minimize(this.view(context));
            return true;
        }

        private boolean closeHandled(IdeAction action, Context context) {
            if (!this.isCloseAction(action)) {
                return false;
            }
            View view = this.view(context);
            DrawerWindow.this.removeIfPresent(view);
            view.close();
            return true;
        }

        private View view(Context context) {
            View drawerView = (View)context.getProperty("DrawerWindow.DRAWER_VIEW");
            return drawerView != null ? drawerView : context.getView();
        }

        private boolean eventHandledByDelegates(IdeAction action, Context context) {
            if (DrawerWindow.this.delegates.isEmpty()) {
                return false;
            }
            for (Controller delegate : DrawerWindow.this.delegates) {
                if (delegate == null || !delegate.handleEvent(action, context)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean update(IdeAction action, Context context) {
            if (this.updateHandledByDelegates(action, context)) {
                return true;
            }
            if (this.unimplementedUpdated(action)) {
                return true;
            }
            if (this.minimizeUpdated(action)) {
                return true;
            }
            return this.closeUpdated(action);
        }

        private boolean updateHandledByDelegates(IdeAction action, Context context) {
            if (DrawerWindow.this.delegates.isEmpty()) {
                return false;
            }
            for (Controller delegate : DrawerWindow.this.delegates) {
                if (delegate == null || !delegate.update(action, context)) continue;
                return true;
            }
            return false;
        }

        private boolean unimplementedUpdated(IdeAction action) {
            if (!this.isUnimplementedAction(action)) {
                return false;
            }
            action.setEnabled(false);
            return true;
        }

        private boolean minimizeUpdated(IdeAction action) {
            if (!this.isMinimizeAction(action)) {
                return false;
            }
            this.disableIfOnlyOneVisibleDrawer(action);
            return true;
        }

        private boolean closeUpdated(IdeAction action) {
            if (!this.isCloseAction(action)) {
                return false;
            }
            this.disableIfOnlyOneVisibleDrawer(action);
            return true;
        }

        private void disableIfOnlyOneVisibleDrawer(IdeAction action) {
            action.setEnabled(DrawerWindow.this.moreThanOneVisibleDrawer());
        }

        private boolean isUnimplementedAction(IdeAction action) {
            int commandId = action.getCommandId();
            return commandId == RESTORE_ACTION_ID || commandId == MOVE_ACTION_ID || commandId == SIZE_ACTION_ID || commandId == MAXIMIZE_ACTION_ID || commandId == FLOAT_ACTION_ID;
        }

        private boolean isMinimizeAction(IdeAction action) {
            return action.getCommandId() == MINIMIZE_ACTION_ID;
        }

        private boolean isCloseAction(IdeAction action) {
            return action.getCommandId() == CLOSE_ACTION_ID;
        }
    }

    class ProxyDrawer
    extends DockableWindow {
        private JPanel panel;
        private String titleName;

        ProxyDrawer(ViewId viewId) {
            super(viewId.getId());
            this.panel = new JPanel();
            this.titleName = viewId.getDisplayName();
        }

        @Override
        public Component getGUI() {
            return this.panel;
        }

        @Override
        public void saveLayout(PropertyAccess p) {
        }

        @Override
        public String getTitleName() {
            return this.titleName;
        }
    }
}

