/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class DropDownMenuButton
extends JToggleButton {
    private static final PopupMenuListener POPUP_CLOSE_LISTENER = new PopupMenuListener(){

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            Component invoker;
            Object source = e.getSource();
            if (source instanceof JPopupMenu && (invoker = ((JPopupMenu)source).getInvoker()) instanceof DropDownMenuButton) {
                DropDownMenuButton button = (DropDownMenuButton)invoker;
                button.getModel().setArmed(false);
                button.setSelected(false);
            }
        }
    };
    private AWTEventListener _awtListener;
    private boolean _popupAlreadyShown;

    public DropDownMenuButton() {
        this.setModel(new DropDownButtonModel());
        this.getPopupMenu().addPopupMenuListener(POPUP_CLOSE_LISTENER);
        this._awtListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                if (event.getSource() == DropDownMenuButton.this && event.getID() == 501) {
                    DropDownMenuButton.this._popupAlreadyShown = DropDownMenuButton.this.getPopupMenu().isVisible();
                }
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(this._awtListener, 16L);
    }

    public JMenuItem addPopupItem(JMenuItem menuItem) {
        this.getPopupMenu().add(menuItem);
        return menuItem;
    }

    public JMenuItem addPopupItem(Action action) {
        JMenuItem menuItem = new JMenuItem(action);
        return this.addPopupItem(menuItem);
    }

    public JMenuItem addPopupItem(String s) {
        JMenuItem menuItem = new JMenuItem(s);
        return this.addPopupItem(menuItem);
    }

    public void addPopupSeparator() {
        this.getPopupMenu().addSeparator();
    }

    public void removePopupItem(JMenuItem menuItem) {
        this.getPopupMenu().remove(menuItem);
    }

    public void removeAllPopupItems() {
        this.getPopupMenu().removeAll();
    }

    public JPopupMenu getPopupMenu() {
        DropDownButtonModel model = (DropDownButtonModel)this.getModel();
        return model.getPopupMenu();
    }

    public void showPopupMenu() {
        JPopupMenu popup = this.getPopupMenu();
        if (popup.getComponentCount() <= 0) {
            return;
        }
        Point p = this.calculateMenuLocation();
        popup.show(this, p.x, p.y);
    }

    private Point calculateMenuLocation() {
        JPopupMenu popup = this.getPopupMenu();
        if (popup.getComponentCount() <= 0) {
            return null;
        }
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        Dimension sizeScreen = new Dimension(gc.getBounds().width, gc.getBounds().height);
        Dimension sizeButton = this.getSize();
        Dimension sizeMenu = popup.getPreferredSize();
        Point ptButton = this.getLocationOnScreen();
        Point p = new Point(0, sizeButton.height);
        if (ptButton.x + sizeMenu.width >= sizeScreen.width) {
            p.x = -sizeMenu.width + sizeButton.width;
        }
        if (ptButton.y + sizeButton.height + sizeMenu.height >= sizeScreen.height) {
            p.y = Math.max(-ptButton.y, -sizeMenu.height);
        }
        return p;
    }

    @Override
    protected ItemListener createItemListener() {
        return new ForwardItemEventsAndShowMenu();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        Toolkit.getDefaultToolkit().removeAWTEventListener(this._awtListener);
    }

    private class DropDownButtonModel
    extends JToggleButton.ToggleButtonModel {
        private final JPopupMenu _popup = new JPopupMenu();

        public JPopupMenu getPopupMenu() {
            return this._popup;
        }

        @Override
        public void setArmed(boolean b) {
            if (DropDownMenuButton.this._popupAlreadyShown && b) {
                return;
            }
            super.setArmed(b);
        }
    }

    private final class ForwardItemEventsAndShowMenu
    implements ItemListener {
        private ForwardItemEventsAndShowMenu() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            DropDownMenuButton.this.fireItemStateChanged(e);
            if (e.getStateChange() == 1) {
                DropDownMenuButton.this.showPopupMenu();
            }
        }
    }
}

