/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controller;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.ContextMenuListenerSupport;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuFilter;
import oracle.ide.controller.MenuManager;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.util.Assert;
import oracle.ide.util.MnemonicSolver;
import oracle.javatools.ui.GraphicsUtils;
import oracle.javatools.util.Pair;

public final class ContextMenu
extends MenuManager {
    private static final String CONTEXTMENU_CONTEXT = "ContextMenuContext";
    private static final String PERFKEY_MENUWILLSHOW = "oracle.ide.ContextMenu.callMenuWillShow";
    private static final String FIXED_MNEMONIC_PROPERTY = "fixedMnemonic";
    private final ContextMenuListenerSupport menuListenerSupport;
    private Context currentContext;
    private JPopupMenu popup;
    private MnemonicSolver mnemonicSolver;
    private final List<MenuFilter> filters = new CopyOnWriteArrayList<MenuFilter>();
    private Throwable menuWillShowException = null;
    private final Collection<JMenu> attachedMenus = new ArrayList<JMenu>();

    public ContextMenu() {
        this(null);
    }

    public ContextMenu(MnemonicSolver solver) {
        this(solver, ContextMenuListenerSupport.createInstance());
    }

    public ContextMenu(MnemonicSolver solver, ContextMenuListenerSupport menuListenerSupport) {
        this.menuListenerSupport = menuListenerSupport;
        this.mnemonicSolver = solver;
    }

    @Override
    public void add(Component child) {
        this.add(child, Float.MAX_VALUE);
    }

    @Override
    public void add(Component child, float sectionId) {
        this.add(child, sectionId, false);
    }

    public void add(Component child, float sectionId, boolean fixed) {
        if (child == null) {
            Logger.getAnonymousLogger().warning("Menu Item is null, action is not added to the menu, sectionId=" + sectionId);
            return;
        }
        if (Ide.getMenubar().getGlobalFilter() != null && !Ide.getMenubar().getGlobalFilter().accept(child)) {
            return;
        }
        super.add(child, sectionId);
        ((JComponent)child).putClientProperty(FIXED_MNEMONIC_PROPERTY, fixed);
    }

    public void addContextMenuListener(ContextMenuListener l) {
        this.addContextMenuListener(l, null);
    }

    public void addContextMenuListener(ContextMenuListener l, Class cls) {
        this.menuListenerSupport.addContextMenuListener(l, cls);
    }

    public void removeContextMenuListener(ContextMenuListener l) {
        this.menuListenerSupport.removeContextMenuListener(l);
    }

    public List<Pair<Class, ContextMenuListener>> getContextMenuListeners() {
        return Collections.unmodifiableList(this.menuListenerSupport.getContextMenuListeners());
    }

    @Override
    public synchronized Container getGUI(boolean create) {
        if (this.popup == null && create) {
            this.popup = new JPopupMenu();
            this.popup.putClientProperty("menu-addin-section-id", Float.valueOf(MenuConstants.SECTION_ADDITIONAL_CTXT_MENU));
            this.popup.addContainerListener(this.getContainerListener());
            this.popup.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public final void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    ContextMenu.this.callMenuWillHide();
                    ContextMenu.this.currentContext = null;
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public final void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
        return this.popup;
    }

    public boolean isShowing() {
        return this.popup != null && this.popup.isShowing();
    }

    public int getMenuCount() {
        return this.getGUI(true).getComponentCount();
    }

    public void removeAll() {
        if (this.popup != null) {
            this.popup.removeAll();
        }
    }

    public final void show(Context context) {
        Assert.precondition((context != null ? 1 : 0) != 0, (String)"context null");
        EventObject eventObject = context.getEvent();
        Assert.precondition((boolean)(context.getEvent() instanceof MouseEvent), (String)("event not MouseEvent: " + context.getEvent()));
        MouseEvent event = (MouseEvent)eventObject;
        this.prepareShow(context);
        if (this.popup == null || this.popup.isShowing() || this.popup.getComponentCount() == 0) {
            return;
        }
        try {
            Component popupParent = (Component)event.getSource();
            Point showPoint = GraphicsUtils.getPopupMenuShowPoint((JPopupMenu)this.popup, (MouseEvent)event);
            this.popup.show(popupParent, showPoint.x, showPoint.y);
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
    }

    public final void prepareShow(Context context) {
        this.currentContext = new Context(context);
        this.getGUI(true);
        this.removeAll();
        this.callMenuWillShow();
        ContextMenu.updatePopupMenuItems(this.popup, this.currentContext);
        this.addMenuComponentsToResolver();
        this.solveMnemonics();
        this.popup.putClientProperty(CONTEXTMENU_CONTEXT, this.currentContext);
    }

    private void applyFilters(JPopupMenu popup) {
        List<MenuFilter> ideList = Ide.getMenubar().getMenuFilters();
        ArrayList<MenuFilter> filtersToApply = new ArrayList<MenuFilter>(ideList.size() + this.filters.size());
        filtersToApply.addAll(ideList);
        filtersToApply.addAll(this.filters);
        if (!filtersToApply.isEmpty()) {
            this.applyFiltersImpl(popup, filtersToApply);
        }
    }

    private void applyFiltersImpl(Container container, List<MenuFilter> filtersToApply) {
        ArrayList<Component> componentsToRemove = new ArrayList<Component>();
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (ContextMenu.isMenuComponentAccepted(component, filtersToApply)) {
                if (!(component instanceof Container) || ((Container)component).getComponentCount() <= 0) continue;
                this.applyFiltersImpl((Container)component, filtersToApply);
                continue;
            }
            componentsToRemove.add(component);
        }
        for (Component component : componentsToRemove) {
            container.remove(component);
        }
    }

    public final Context getContext() {
        return this.currentContext;
    }

    static Context getContext(JMenuItem menuItem, EventObject e) {
        Context ctx = null;
        for (Container item = menuItem; item != null; item = item.getParent()) {
            if (!(item instanceof JPopupMenu) && !(item instanceof JMenuBar)) continue;
            JComponent menu = item;
            ctx = (Context)menu.getClientProperty(CONTEXTMENU_CONTEXT);
            if (ctx == null) break;
            ctx.setEvent(e);
            break;
        }
        return ctx;
    }

    static void clearContext(JMenuItem menuItem) {
        for (Container item = menuItem; item != null; item = item.getParent()) {
            if (!(item instanceof JPopupMenu) && !(item instanceof JMenuBar)) continue;
            JComponent menu = item;
            menu.putClientProperty(CONTEXTMENU_CONTEXT, null);
            break;
        }
    }

    public void addSeparator() {
        int cnt = this.popup.getComponentCount();
        if (cnt > 0 && this.popup.getComponent(cnt - 1) instanceof JPopupMenu.Separator) {
            return;
        }
        this.popup.add(new JPopupMenu.Separator());
    }

    public boolean fireDefaultAction(Context context) {
        Element ctxElem = ContextMenu.getContextElement(context);
        Class ctxClass = ContextMenu.getElementDataClass(ctxElem);
        List<Pair<Class, ContextMenuListener>> listeners = this.menuListenerSupport.getContextMenuListeners();
        for (Pair<Class, ContextMenuListener> listenerHolder : listeners) {
            ContextMenuListener listener = (ContextMenuListener)listenerHolder.getSecond();
            Class cls = (Class)listenerHolder.getFirst();
            if (cls != null && (context == null || ctxElem == null || cls != ctxClass)) continue;
            long time = System.nanoTime();
            boolean handled = listener.handleDefaultAction(context);
            PerformanceLogger.get().log("ContextMenuListener.handleDefaultAction", listener.getClass().getName(), System.nanoTime() - time);
            if (!handled) continue;
            Assert.println((String)("Listener handled default action:" + listener));
            IdeMainWindow.updateVisibleActions(Controller.UPDATE_FROM_ACTION_PERFORMED);
            return true;
        }
        return false;
    }

    public MnemonicSolver getMnemonicSolver() {
        return this.mnemonicSolver;
    }

    public static Element unwrapDecoratedElement(Element elem) {
        if (elem != null) {
            Object data;
            int decorationLevel = 0;
            while (elem.getAttributes().isSet(ElementAttributes.DECORATES_DATA_ELEMENT) && decorationLevel++ < 15 && (data = elem.getData()) != elem && data instanceof Element) {
                elem = (Element)data;
            }
        }
        return elem;
    }

    private static final Element getContextElement(Context context) {
        if (context != null) {
            Element elem = context.getElement();
            return ContextMenu.unwrapDecoratedElement(elem);
        }
        return null;
    }

    private static final Class getElementDataClass(Element elem) {
        Object data;
        if (elem != null && (data = elem.getData()) != null) {
            return data.getClass();
        }
        return null;
    }

    private static final Class getContextElementClass(Context context) {
        Element elem = ContextMenu.getContextElement(context);
        return ContextMenu.getElementDataClass(elem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callMenuWillShow() {
        this.menuWillShowException = null;
        Class ctxClass = ContextMenu.getContextElementClass(this.currentContext);
        this.clearMnemonics();
        Assert.printHeader((String)"Popping up context menu");
        Assert.startTracking((String)PERFKEY_MENUWILLSHOW);
        try {
            List<Pair<Class, ContextMenuListener>> listeners = this.menuListenerSupport.getContextMenuListeners();
            for (Pair<Class, ContextMenuListener> holder : listeners) {
                Assert.markTracking((String)PERFKEY_MENUWILLSHOW);
                Class cls = (Class)holder.getFirst();
                if (cls != null && (ctxClass == null || !cls.isAssignableFrom(ctxClass))) continue;
                ContextMenuListener listener = (ContextMenuListener)holder.getSecond();
                this.invokeMenuWillShow(listener);
                Assert.checkTracking((String)PERFKEY_MENUWILLSHOW, (Object)listener);
            }
        }
        finally {
            Assert.endTracking((String)PERFKEY_MENUWILLSHOW, (String)"Popped up context menu");
        }
        this.applyFilters(this.popup);
        this.removeDuplicateActions();
        this.sortContainer(this.popup);
    }

    private void clearMnemonics() {
        if (this.mnemonicSolver != null) {
            this.mnemonicSolver.clear();
        }
    }

    private void solveMnemonics() {
        List<Pair<Class, ContextMenuListener>> listeners = this.menuListenerSupport.getContextMenuListeners();
        if (!listeners.isEmpty() && this.mnemonicSolver != null) {
            this.mnemonicSolver.solve();
        }
    }

    private void addMenuComponentsToResolver() {
        List<Pair<Class, ContextMenuListener>> listeners = this.menuListenerSupport.getContextMenuListeners();
        if (!listeners.isEmpty() && this.mnemonicSolver != null) {
            for (Component c : this.getGUI(true).getComponents()) {
                if (!(c instanceof AbstractButton)) continue;
                Object prop = ((AbstractButton)c).getClientProperty(FIXED_MNEMONIC_PROPERTY);
                boolean fixed = prop instanceof Boolean ? (Boolean)prop : false;
                this.addToSolver(c, fixed);
            }
        }
    }

    public void removeDuplicateActions() {
        ArrayList<IdeAction> foundActions = new ArrayList<IdeAction>();
        ContextMenu.removeDuplicateActions(this.popup, foundActions, this.popup.getComponents());
    }

    private static void removeDuplicateActions(JComponent menu, List<IdeAction> foundActions, Component[] menuComponents) {
        ArrayList<Component> duplicates = new ArrayList<Component>();
        for (Component menuComponent : menuComponents) {
            if (!(menuComponent instanceof JMenuItem)) continue;
            JMenuItem menuItem = (JMenuItem)menuComponent;
            Action action = menuItem.getAction();
            if (action instanceof IdeAction) {
                IdeAction ideAction = (IdeAction)action;
                if (foundActions.contains(ideAction)) {
                    duplicates.add(menuComponent);
                } else {
                    foundActions.add(ideAction);
                }
            }
            if (!(menuComponent instanceof JMenu)) continue;
            JMenu subMenu = (JMenu)menuComponent;
            Component[] subMenuComponents = subMenu.getMenuComponents();
            ContextMenu.removeDuplicateActions(subMenu, foundActions, subMenuComponents);
        }
        for (Component duplicateComp : duplicates) {
            menu.remove(duplicateComp);
        }
    }

    private void invokeMenuWillShow(ContextMenuListener listener) {
        try {
            long time = System.nanoTime();
            listener.menuWillShow(this);
            PerformanceLogger.get().log("ContextMenuListener.menuWillShow", listener.getClass().getName(), System.nanoTime() - time);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.menuWillShowException = t;
        }
    }

    private void callMenuWillHide() {
        this.reportMenuWillShowException();
        Class ctxClass = ContextMenu.getContextElementClass(this.currentContext);
        List<Pair<Class, ContextMenuListener>> listeners = this.menuListenerSupport.getContextMenuListeners();
        for (Pair<Class, ContextMenuListener> holder : listeners) {
            Class cls = (Class)holder.getFirst();
            if (cls != null && (ctxClass == null || !cls.isAssignableFrom(ctxClass))) continue;
            this.invokeMenuWillHide((ContextMenuListener)holder.getSecond());
        }
        for (JMenu menu : this.attachedMenus) {
            this.unregisterFilterContainerListener(menu);
        }
        this.attachedMenus.clear();
    }

    private void reportMenuWillShowException() {
        if (this.menuWillShowException == null) {
            return;
        }
        FeedbackManager.reportException(this.menuWillShowException);
        this.menuWillShowException = null;
    }

    private void invokeMenuWillHide(ContextMenuListener listener) {
        try {
            long time = System.nanoTime();
            listener.menuWillHide(this);
            PerformanceLogger.get().log("ContextMenuListener.menuWillHide", listener.getClass().getName(), System.nanoTime() - time);
        }
        catch (ThreadDeath t) {
            throw t;
        }
        catch (Throwable t) {
            FeedbackManager.reportException(t);
        }
    }

    private void addToSolver(Component component, boolean fixed) {
        if (this.mnemonicSolver == null) {
            return;
        }
        this.mnemonicSolver.addMenuLabel(component, fixed);
    }

    @Override
    public final void addMenuFilter(MenuFilter menuFilter) {
        if (menuFilter == null) {
            throw new NullPointerException("menuFilter is null");
        }
        if (!this.filters.contains(menuFilter)) {
            this.filters.add(menuFilter);
        }
    }

    @Override
    public final void removeMenuFilter(MenuFilter menuFilter) {
        this.filters.remove(menuFilter);
    }

    @Override
    protected void registerFilterContainerListener(JMenu menu) {
        this.attachedMenus.add(menu);
        super.registerFilterContainerListener(menu);
    }
}

