/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.panels.TraversableContext;
import oracle.ide.wizard.WizardCallbacks;
import oracle.ideimpl.webupdate.UpdateArb;
import oracle.ideimpl.webupdate.wizard.CFUUpdatesTreePanel;
import oracle.ideimpl.webupdate.wizard.UpdatePageConditions;
import oracle.ideimpl.webupdate.wizard.UpdateWizardPage;

final class UpdatePage
extends UpdateWizardPage {
    private final CFUUpdatesTreePanel _updatesPanel = new CFUUpdatesTreePanel(){

        @Override
        protected void completeValueChanged() {
            if (!UpdatePage.this.getModel(UpdatePage.this.getTraversableContext()).isWizardCancelled()) {
                UpdatePage.this.completeValueChanged();
                UpdatePage.this.updateExpectedTransition();
            }
        }
    };
    private final GridBagLayout _layout = new GridBagLayout();
    private final JLabel _labelForTreePanel = new JLabel();

    UpdatePage() {
        this.resControls();
        this.layoutControls();
    }

    private void resControls() {
        String label = UpdateArb.getString(10);
        this._labelForTreePanel.setText(StringUtils.stripMnemonic((String)label));
        this._labelForTreePanel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)label));
        this._labelForTreePanel.setLabelFor(this._updatesPanel.getInitialFocus());
    }

    private void layoutControls() {
        this.setLayout(this._layout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.insets = INSETS_HINT;
        this.add(this._labelForTreePanel, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = INSETS_ZERO;
        this.add(this._updatesPanel, gbc);
    }

    @Override
    public Component getInitialFocus() {
        return this._updatesPanel.getInitialFocus();
    }

    private void updateExpectedTransition() {
        WizardCallbacks wc = this.getTraversableContext().getWizardCallbacks();
        wc.wizardUpdateExpectedTransition(this.getExitTransition());
    }

    @Override
    public void pageSelected(TraversableContext context) {
        if (context.getDirection() == 1) {
            this._updatesPanel.cleanUp();
            this._updatesPanel.populate(this.getModel(context));
        }
    }

    @Override
    protected void pageDeselected(TraversableContext context) {
    }

    @Override
    public boolean isComplete() {
        return this._updatesPanel.isComplete();
    }

    @Override
    protected void save(TraversableContext context) {
        this._updatesPanel.save(this.getModel(context));
    }

    @Override
    public boolean canFinish() {
        return false;
    }

    public Object getExitTransition() {
        if (this._updatesPanel.isCheckedForUpdates() && !this._updatesPanel.hasUpdates()) {
            return "updatesToSummary";
        }
        UpdatePageConditions state = new UpdatePageConditions(false, this._updatesPanel.isLicenseRequired(), this._updatesPanel.getSelectedUpdates());
        if (state.isLicense()) {
            return "updatesToLicense";
        }
        if (state.isSingleUser()) {
            return "updatesToDownload";
        }
        return "updatesToDlLocation";
    }
}

