/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.usages;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.NoRouteToHostException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbtools.raptor.usages.ServerLocation;
import oracle.dbtools.raptor.usages.ServerLocationsParser;
import oracle.dbtools.raptor.usages.UsageClient;
import oracle.dbtools.util.Logger;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.HttpResponseException;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.xml.sax.SAXException;

final class ServerLocations {
    static String _masterServerURL;

    ServerLocations() {
    }

    static Set<ServerLocation> getServers(UsageClient usageClient) {
        HashSet<ServerLocation> hashSet = new HashSet<ServerLocation>();
        try {
            HttpGet httpGet = new HttpGet(ServerLocations.getMasterUsageServerURL());
            List<ServerLocation> list = usageClient.executeRequest((HttpUriRequest)httpGet, new HttpClientResponseHandler<List<ServerLocation>>(){

                public List<ServerLocation> handleResponse(ClassicHttpResponse classicHttpResponse) throws IOException {
                    List<ServerLocation> list;
                    block12: {
                        HttpEntity httpEntity = classicHttpResponse.getEntity();
                        if (classicHttpResponse.getCode() >= 300) {
                            throw new HttpResponseException(classicHttpResponse.getCode(), classicHttpResponse.getReasonPhrase());
                        }
                        if (httpEntity == null) {
                            throw new ClientProtocolException("Response contains no content");
                        }
                        ContentType contentType = ContentType.parse((CharSequence)httpEntity.getContentType());
                        Charset charset = contentType.getCharset();
                        if (charset == null) {
                            charset = Charset.defaultCharset();
                        }
                        InputStream inputStream = httpEntity.getContent();
                        try {
                            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset);
                            list = new ServerLocationsParser().parse(inputStreamReader);
                            if (inputStream == null) break block12;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (inputStream != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (ParserConfigurationException parserConfigurationException) {
                                throw new IOException(parserConfigurationException);
                            }
                            catch (SAXException sAXException) {
                                throw new IOException(sAXException);
                            }
                        }
                        inputStream.close();
                    }
                    return list;
                }
            });
            for (ServerLocation serverLocation : list) {
                hashSet.add(serverLocation);
            }
        }
        catch (NoRouteToHostException noRouteToHostException) {
            Logger.severe(ServerLocations.class, (String)"Failed to upload usage logs to server. Possible cause: proxy may not be configured correctly.", (Throwable)noRouteToHostException);
        }
        catch (Exception exception) {
            Logger.severe(ServerLocations.class, (String)"Failed to upload usage logs to server.", (Throwable)exception);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    static String getMasterUsageServerURL() {
        if (_masterServerURL == null) {
            String string = System.getProperty("ide.update.usage.servers");
            if (string == null || string.trim().length() == 0) {
                string = "http://download.oracle.com/otn-pub/jdeveloper/cfu/usage.xml";
            }
            _masterServerURL = string;
        }
        return _masterServerURL;
    }
}

