/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.compiler;

public class QName {
    String name;
    String pkg = null;
    String clazz = null;
    String className = null;
    String flat = null;
    String inFile;

    public QName(String name) {
        if (name == null) {
            name = "";
        }
        this.name = name;
    }

    public QName(String packageName, String className) {
        String packagePart = packageName == null || packageName.equals("") ? "" : (packageName.endsWith(".") ? packageName : packageName + ".");
        String classPart = className;
        if (classPart == null) {
            classPart = "";
        }
        classPart = classPart.replace('.', '$');
        this.name = packagePart + classPart;
    }

    public String getPackagePart() {
        if (this.pkg == null) {
            int ix = this.name.lastIndexOf(46);
            this.pkg = ix > 0 ? this.name.substring(0, ix) : "";
        }
        return this.pkg;
    }

    public String getClassPart() {
        if (this.clazz == null) {
            this.clazz = this.getFlatName();
            this.clazz = this.clazz.replace('$', '.');
        }
        return this.clazz;
    }

    public String toString() {
        return this.name;
    }

    public String getFullName() {
        String p = this.getPackagePart();
        String c = this.getClassPart();
        if (p.equals("")) {
            return c;
        }
        if (c.equals("")) {
            return p;
        }
        return p + "." + c;
    }

    public String getName() {
        return this.name;
    }

    public String getClassfileName() {
        if (this.inFile == null) {
            this.inFile = this.name.replace('.', '/');
        }
        return this.inFile;
    }

    public String getFlatName() {
        if (this.flat == null) {
            int ix = this.name.lastIndexOf(46);
            this.flat = ix > 0 ? this.name.substring(ix + 1) : this.name;
        }
        return this.flat;
    }

    public String getOutermost() {
        if (this.className == null) {
            this.className = this.getClassPart();
            int x = this.className.indexOf(46);
            if (x >= 0) {
                this.className = this.className.substring(0, x);
            }
        }
        return this.className;
    }

    public boolean isInner() {
        return this.getClassPart().indexOf(46) >= 0;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof QName && this.name.equals(((QName)other).name);
    }

    public static QName noName() {
        return new QName("<<noName>>");
    }
}

