/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cms.CMSUtils;
import oracle.security.crypto.cms.OSInputStream;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.CBCAlgorithmIdentifier;
import oracle.security.crypto.util.InvalidInputException;

class ECIInputStream
extends FilterInputStream {
    private Cipher cipher;
    private AlgorithmIdentifier contentEncryptionAlgID;
    private ASN1ObjectID contentType;
    private final int blockSize;
    private byte[] cipherBlock;
    private byte[] plainBlock;
    private int plainBlockRead;
    private int cipherBlockWritten;
    boolean lastBlock;
    private int plainBlockLimit;
    private byte[] readbuf;
    private final int readbufSize;
    private static final int TARGET_READBUF_SIZE = 1024;
    private ASN1ConstructedInputStream eci_in;
    private OSInputStream econtent_in;
    private boolean noContent = false;
    private boolean terminated = false;

    ECIInputStream(InputStream in, byte[] contentEncryptionKeyBytes) throws IOException {
        super(in);
        this.eci_in = new ASN1SequenceInputStream(in);
        this.contentType = new ASN1ObjectID((InputStream)this.eci_in);
        this.contentEncryptionAlgID = new AlgorithmIdentifier((InputStream)this.eci_in);
        try {
            String algoName = CMSUtils.getAlgoName(this.contentEncryptionAlgID, true);
            SecretKeySpec contentEncryptionKey = new SecretKeySpec(contentEncryptionKeyBytes, algoName);
            algoName = null;
            algoName = CMSUtils.addPadding(CMSUtils.getAlgoName(this.contentEncryptionAlgID));
            this.cipher = Cipher.getInstance(algoName);
            if (algoName.indexOf("CBC") != -1) {
                byte[] iv = ((ASN1OctetString)this.contentEncryptionAlgID.getParameters()).getValue();
                this.contentEncryptionAlgID = new CBCAlgorithmIdentifier(this.contentEncryptionAlgID.getOID(), iv);
                this.cipher.init(2, (Key)contentEncryptionKey, new IvParameterSpec(iv));
            } else {
                this.cipher.init(2, contentEncryptionKey);
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw new InvalidInputException("Algorithm identifier not recognized.");
        }
        catch (InvalidKeyException ex) {
            throw new InvalidInputException("Key is not valid.");
        }
        catch (NoSuchPaddingException ex) {
            throw new InvalidInputException("No Such padding supported");
        }
        catch (InvalidAlgorithmParameterException ed) {
            throw new InvalidInputException("Algorithm Parameters - IV not valid.");
        }
        if (this.eci_in.hasMoreData()) {
            this.econtent_in = new OSInputStream((InputStream)this.eci_in, 0);
            this.cipher = this.cipher;
            this.blockSize = this.cipher.getBlockSize();
            this.cipherBlock = new byte[this.blockSize];
            this.plainBlock = new byte[this.blockSize];
            this.plainBlockLimit = 0;
            this.plainBlockRead = 0;
            this.cipherBlockWritten = 0;
            this.readbufSize = Math.max(1024 / this.blockSize, 1) * this.blockSize;
        } else {
            this.readbufSize = 0;
            this.blockSize = 0;
            this.noContent = true;
            this.finishRead();
        }
    }

    ECIInputStream(ASN1SequenceInputStream in, byte[] contentEncryptionKeyBytes, ASN1ObjectID cType, AlgorithmIdentifier cEncryptionAlgId) throws IOException {
        super((InputStream)in);
        this.eci_in = in;
        this.contentType = cType;
        this.contentEncryptionAlgID = cEncryptionAlgId;
        try {
            String algoName = CMSUtils.getAlgoName(this.contentEncryptionAlgID, true);
            SecretKeySpec contentEncryptionKey = new SecretKeySpec(contentEncryptionKeyBytes, algoName);
            algoName = null;
            algoName = CMSUtils.addPadding(CMSUtils.getAlgoName(this.contentEncryptionAlgID));
            this.cipher = Cipher.getInstance(algoName);
            if (algoName.indexOf("CBC") != -1) {
                byte[] iv = ((ASN1OctetString)this.contentEncryptionAlgID.getParameters()).getValue();
                this.contentEncryptionAlgID = new CBCAlgorithmIdentifier(this.contentEncryptionAlgID.getOID(), iv);
                this.cipher.init(2, (Key)contentEncryptionKey, new IvParameterSpec(iv));
            } else {
                this.cipher.init(2, contentEncryptionKey);
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw new InvalidInputException("Algorithm identifier not recognized.");
        }
        catch (InvalidKeyException ex) {
            throw new InvalidInputException("Key is not valid.");
        }
        catch (NoSuchPaddingException ex) {
            throw new InvalidInputException("No Such padding supported");
        }
        catch (InvalidAlgorithmParameterException ed) {
            throw new InvalidInputException("Algorithm Parameters - IV not valid.");
        }
        if (this.eci_in.hasMoreData()) {
            this.econtent_in = new OSInputStream((InputStream)this.eci_in, 0);
            this.cipher = this.cipher;
            this.blockSize = this.cipher.getBlockSize();
            this.cipherBlock = new byte[this.blockSize];
            this.plainBlock = new byte[this.blockSize];
            this.plainBlockLimit = 0;
            this.plainBlockRead = 0;
            this.cipherBlockWritten = 0;
            this.readbufSize = Math.max(1024 / this.blockSize, 1) * this.blockSize;
        } else {
            this.readbufSize = 0;
            this.blockSize = 0;
            this.noContent = true;
            this.finishRead();
        }
    }

    ECIInputStream(InputStream in, SecretKey contentEncryptionKey) throws IOException {
        super(in);
        this.eci_in = new ASN1SequenceInputStream(in);
        this.contentType = new ASN1ObjectID((InputStream)this.eci_in);
        this.contentEncryptionAlgID = new AlgorithmIdentifier((InputStream)this.eci_in);
        try {
            String algoName = CMSUtils.getAlgoName(this.contentEncryptionAlgID);
            this.cipher = Cipher.getInstance(CMSUtils.addPadding(algoName));
            if (algoName.indexOf("CBC") != -1) {
                byte[] iv = ((ASN1OctetString)this.contentEncryptionAlgID.getParameters()).getValue();
                this.contentEncryptionAlgID = new CBCAlgorithmIdentifier(this.contentEncryptionAlgID.getOID(), iv);
                this.cipher.init(2, (Key)contentEncryptionKey, new IvParameterSpec(iv));
            } else {
                this.cipher.init(2, contentEncryptionKey);
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw new InvalidInputException("Algorithm identifier not recognized.");
        }
        catch (NoSuchPaddingException ex) {
            throw new InvalidInputException("Algorithm identifier not recognized.");
        }
        catch (InvalidKeyException ex) {
            throw new InvalidInputException("Key is not valid.");
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new InvalidInputException("IV bytes are not valid");
        }
        if (this.eci_in.hasMoreData()) {
            this.econtent_in = new OSInputStream((InputStream)this.eci_in, 0);
            this.cipher = this.cipher;
            this.blockSize = this.cipher.getBlockSize();
            this.cipherBlock = new byte[this.blockSize];
            this.plainBlock = new byte[this.blockSize];
            this.plainBlockLimit = 0;
            this.plainBlockRead = 0;
            this.cipherBlockWritten = 0;
            this.readbufSize = Math.max(1024 / this.blockSize, 1) * this.blockSize;
        } else {
            this.readbufSize = 0;
            this.blockSize = 0;
            this.noContent = true;
            this.finishRead();
        }
    }

    private boolean getNextBlock() throws IOException {
        int bytesRead;
        int len = 0;
        for (int offset = this.cipherBlockWritten; offset < this.blockSize; offset += bytesRead) {
            bytesRead = this.econtent_in.read(this.cipherBlock, offset, this.blockSize - offset);
            if (bytesRead > 0) continue;
            throw new InvalidInputException("Incomplete ciphertext block.");
        }
        try {
            boolean bl = this.lastBlock = !this.econtent_in.hasMoreData();
            if (this.lastBlock) {
                this.plainBlock = new byte[2 * this.blockSize];
                len = this.cipher.doFinal(this.cipherBlock, 0, this.blockSize, this.plainBlock, 0);
            } else {
                len = this.cipher.update(this.cipherBlock, 0, this.blockSize, this.plainBlock, 0);
            }
        }
        catch (ShortBufferException ex) {
            throw new InvalidInputException((Exception)ex);
        }
        catch (IllegalBlockSizeException ex) {
            throw new InvalidInputException((Exception)ex);
        }
        catch (BadPaddingException ex) {
            throw new InvalidInputException((Exception)ex);
        }
        this.cipherBlockWritten = 0;
        this.plainBlockRead = 0;
        boolean bl = this.lastBlock = !this.econtent_in.hasMoreData();
        if (this.lastBlock) {
            this.finishRead();
            this.plainBlockLimit = 2 * this.blockSize;
        } else {
            this.plainBlockLimit = this.blockSize;
        }
        return len > 0;
    }

    private void finishRead() throws IOException {
        if (!this.terminated) {
            this.eci_in.terminate();
            this.terminated = true;
        }
    }

    private void removePadding() throws IOException {
        int pad = this.plainBlock[this.blockSize - 1] & 0xFF;
        if (pad == 0 || pad > this.blockSize) {
            throw new InvalidInputException("Invalid padding.");
        }
        for (int i = 2; i <= pad; ++i) {
            if ((this.plainBlock[this.blockSize - i] & 0xFF) == pad) continue;
            throw new InvalidInputException("Invalid padding.");
        }
        this.plainBlockLimit = this.blockSize - pad;
    }

    public AlgorithmIdentifier getContentEncryptionAlgID() {
        return this.contentEncryptionAlgID;
    }

    @Override
    public int read() throws IOException {
        if (this.noContent) {
            return -1;
        }
        while (this.plainBlockRead == this.plainBlockLimit) {
            if (this.lastBlock) {
                return -1;
            }
            if (this.getNextBlock()) continue;
            this.getNextBlock();
        }
        return this.plainBlock[this.plainBlockRead++] & 0xFF;
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        if (this.noContent) {
            return -1;
        }
        if (len == 0) {
            return 0;
        }
        int ch = this.read();
        if (ch == -1) {
            return -1;
        }
        int count = offset;
        buffer[count++] = (byte)ch;
        while (count < len && (ch = this.read()) != -1) {
            buffer[count++] = (byte)ch;
        }
        return count - offset;
    }

    @Override
    public int available() throws IOException {
        throw new IOException("available not supported");
    }

    @Override
    public long skip(long n) throws IOException {
        throw new IOException("skip not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public ASN1ObjectID getContentType() {
        return this.contentType;
    }
}

